% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiRKAT_Q.R
\name{MiRKAT.Q}
\alias{MiRKAT.Q}
\title{Robust MiRKAT (quantile regression)}
\usage{
MiRKAT.Q(y, X, Ks, omnibus = "kernel_om", returnKRV = FALSE, returnR2 = FALSE)
}
\arguments{
\item{y}{A numeric vector of the a continuous or dichotomous outcome variable.}

\item{X}{A numerical matrix or data frame, containing additional covariates that you want to adjust for. Mustn't be NULL.}

\item{Ks}{A list of n by n kernel matrices (or a single n by n kernel matrix), where n is the sample size. If you have distance metric from metagenomic data, each kernel can 
be constructed through function D2K. Each kernel can also be constructed through other mathematical approaches, such as linear or Gaussian kernels.}

\item{omnibus}{A string equal to either "Cauchy" or "kernel_om" (or nonambiguous abbreviations thereof), specifying whether 
to use the Cauchy combination test or an omnibus kernel to generate the omnibus p-value.}

\item{returnKRV}{A logical indicating whether to return the KRV statistic. Defaults to FALSE.}

\item{returnR2}{A logical indicating whether to return the R-squared coefficient. Defaults to FALSE.}
}
\value{
Returns p-values for each individual kernel matrix, an omnibus p-value if multiple kernels were provided, and measures of effect size KRV and R2. 
   \item{p_values}{labeled individual p-values for each kernel}
   \item{omnibus_p}{omnibus p_value, calculated as for the KRV test}
   \item{KRV}{A vector of kernel RV statistics (a measure of effect size), one for each candidate kernel matrix. Only returned if returnKRV = TRUE}
   \item{R2}{A vector of R-squared statistics, one for each candidate kernel matrix. Only returned if returnR2 = TRUE}
}
\description{
A more robust version of MiRKAT utlizing a linear model that uses quantile regression.
}
\details{
MiRKAT.Q creates a kernel matrix using the linear model created with the function rq, a quantile regression function, then does 
the KRV analysis on Ks and the newly formed kernel matrix representing the outome traits. 

Missing data is not permitted. Please remove all individuals with missing y, X, Ks prior to analysis
}
\examples{
    
library(GUniFrac)
library(quantreg)
library(vegan) 

# Generate data
data(throat.tree)
data(throat.otu.tab)
data(throat.meta)

unifracs = GUniFrac(throat.otu.tab, throat.tree, alpha = c(1))$unifracs
Ds = list(w = unifracs[,,"d_1"], uw = unifracs[,,"d_UW"], 
         BC= as.matrix(vegdist(throat.otu.tab, method="bray"))) 
Ks = lapply(Ds, FUN = function(d) D2K(d))

covar = scale(cbind(throat.meta$Age, as.numeric(throat.meta$Sex == "Male")))

# Continuous phenotype
n = nrow(throat.meta)
y = rchisq(n, 2) + apply(covar, 1, sum) 
MiRKAT.Q(y, X = covar, Ks = Ks)

}
\author{
Weija Fu
}
