% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{subset_samples_sd_surrogates}
\alias{subset_samples_sd_surrogates}
\title{subset_samples_sd_surrogates}
\usage{
subset_samples_sd_surrogates(x, MEAN, SD, N = 5, quiet = FALSE)
}
\arguments{
\item{x}{numeric data-frame with Nightingale-metabolomics}

\item{MEAN}{numeric vector indicating the mean of the metabolites in x}

\item{SD}{numeric vector indicating the standard deviations of the metabolites in x}

\item{N}{numeric vector indicating the amount of standard deviations away from the mean after which we consider an outlier (N suggested=5)}

\item{quiet}{logical to suppress the messages in the console}
}
\value{
matrix with the samples with limited amount of outliers in the Nightingale-metabolomics dataset
}
\description{
Helper function that subsets the NH-metabolomics matrix to the samples with limited numbers of outliers
}
\details{
Bizzarri et al. built multivariate models,using 56 metabolic features quantified by Nightingale, to predict the 19 binary characteristics of an individual.
The binary variables are: sex, diabetes status, metabolic syndrome status, lipid medication usage, blood pressure lowering medication,
current smoking, alcohol consumption, high age, middle age, low age, high hsCRP, high triglycerides, high ldl cholesterol,
high total cholesterol, low hdl cholesterol, low eGFR, low white blood cells, low hemoglobin levels.
}
\examples{
\dontrun{
library(MiMIR)

#load the Nightignale metabolomics dataset
metabolic_measures <- read.csv("Nightingale_file_path",header = TRUE, row.names = 1)
#Select the samples with low outliers
mat <- subset_samples_sd_surrogates(x=metabolic_measures, Nmax=1)
}

}
\references{
This function was made to vidualize the binarized variables calculated following the rules indicated in the article:
Bizzarri,D. et al. (2022) 1H-NMR metabolomics-based surrogates to impute common clinical risk factors and endpoints. EBioMedicine, 75, 103764, \url{doi:10.1016/j.ebiom.2021.103764}
}
\seealso{
QCprep_surrogates, calculate_surrogate_scores, apply.fit_surro
}
\keyword{internal}
