% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{scatterplot_predictions}
\alias{scatterplot_predictions}
\title{scatterplot_predictions}
\usage{
scatterplot_predictions(x, p, title, xname = "x", yname = "predicted x")
}
\arguments{
\item{x}{numeric vector}

\item{p}{second numeric vector}

\item{title}{string vector with the title}

\item{xname}{string vector with the name of the variable on the x axis}

\item{yname}{string vector with the name of the variable on the y axis}
}
\value{
plotly image with the scatterplot
}
\description{
Function to visualize a scatter-plot comparing two variables
}
\examples{
library(plotly)
#load the dataset
metabolic_measures <- synthetic_metabolic_dataset
phenotypes <- synthetic_phenotypic_dataset

#Pre-process the metabolic features
prepped_met<-QCprep(as.matrix(metabolic_measures), MiMIR::PARAM_metaboAge)
#Apply the metaboAge
metaboAge<-apply.fit(prepped_met, FIT=PARAM_metaboAge$FIT_COEF)

age<-data.frame(phenotypes$age)
rownames(age)<-rownames(phenotypes)
scatterplot_predictions(age, metaboAge, title="Chronological Age vs MetaboAge")

}
