% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{MetaculR_brier}
\alias{MetaculR_brier}
\title{Calculate Brier statistics on MetaculR_questions object}
\usage{
MetaculR_brier(MetaculR_questions, me = TRUE, thresholds = seq(0, 1, 0.1))
}
\arguments{
\item{MetaculR_questions}{A MetaculR_questions object}

\item{me}{Show my scores alongside Metaculus scores}

\item{thresholds}{Thresholds to bin questions}
}
\value{
A list of Brier statistics for you and Metaculus.
\item{brier_me, brier_Metaculus}{}
\item{baseline.tf}{Logical indicator of whether climatology was provided.}
\item{bs}{Brier score}
\item{bs.baseline}{Brier Score for climatology}
\item{ss}{Skill score}
\item{bs.reliability}{Reliability portion of Brier score.}
\item{bs.resolution}{Resolution component of Brier score.}
\item{bs.uncert}{Uncertainty component of Brier score.}
\item{y.i}{Forecast bins -- described as the center value of the bins.}
\item{obar.i}{Observation bins -- described as the center value of the bins.}
\item{prob.y}{Proportion of time using each forecast.}
\item{obar}{Forecast based on climatology or average sample observations.}
\item{thresholds}{The thresholds for the forecast bins.}
\item{check}{ Reliability - resolution + uncertainty should equal brier score.}
\item{Other}{}
\item{ss_me_Metaculus}{Skill score, me vs. Metaculus.}
\item{count_questions}{Number of total questions included.}
\item{brier_df: Used for plotting Brier score statistics}{}
\item{ID}{Predictor.}
\item{name}{Name of value, see above.}
\item{value}{Value.}
\item{brier_bins_df: Used for plotting histogram and calibration plots.}{}
\item{ID}{Predictor.}
\item{centers}{y.i, see above.}
\item{freqs}{prob.y, see above.}
\item{obars}{obar.i, see above.}
\item{ideal}{Ideal calibration where centers equals obars.}
\item{ci_low}{Low end of 95\% confidence interval for obar.i.}
\item{ci_high}{High end of 95\% confidence interval for obar.i.}
}
\description{
Calculate Brier statistics on MetaculR_questions object
}
\examples{
\dontrun{
brier_me <-
  MetaculR_brier(
    questions_myPredictions_resolved)
}
}
