% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{c_net_plot}
\alias{c_net_plot}
\title{Plot a metanet}
\usage{
c_net_plot(
  go,
  coors = NULL,
  ...,
  labels_num = 5,
  vertex_size_range = NULL,
  legend_number = FALSE,
  legend = TRUE,
  legend_cex = 1,
  legend_position = c(left_leg_x = -2, left_leg_y = 1, right_leg_x = 1.2, right_leg_y =
    1),
  lty_legend = FALSE,
  lty_legend_title = "Edge class",
  size_legend = FALSE,
  size_legend_title = "Node Size",
  edge_legend = TRUE,
  edge_legend_title = "Edge type",
  edge_legend_order = NULL,
  width_legend = FALSE,
  width_legend_title = "Edge width",
  col_legend = TRUE,
  col_legend_order = NULL,
  group_legend_title = NULL,
  group_legend_order = NULL,
  plot_module = FALSE,
  mark_module = FALSE,
  mark_color = NULL,
  mark_alpha = 0.3,
  seed = 1234
)
}
\arguments{
\item{go}{an igraph or metanet object}

\item{coors}{the coordinates you saved}

\item{...}{additional parameters for \code{\link[igraph]{igraph.plotting}}}

\item{labels_num}{show how many labels,>1 indicates number, <1 indicates fraction, "all" indicates all, default:5}

\item{vertex_size_range}{the vertex size range, e.g. c(1,10)}

\item{legend_number}{legend with numbers}

\item{legend}{all legends}

\item{legend_cex}{character expansion factor relative to current par("cex"), default: 1}

\item{legend_position}{legend_position, default: c(left_leg_x=-1.9,left_leg_y=1,right_leg_x=1.2,right_leg_y=1)}

\item{lty_legend}{logical}

\item{lty_legend_title}{lty_legend_title}

\item{size_legend}{logical}

\item{size_legend_title}{size_legend_title}

\item{edge_legend}{logical}

\item{edge_legend_title}{edge_legend_title}

\item{edge_legend_order}{edge_legend_order vector, e.g. c("positive","negative")}

\item{width_legend}{logical}

\item{width_legend_title}{width_legend_title}

\item{col_legend}{logical}

\item{col_legend_order}{col_legend_order vector,}

\item{group_legend_title}{group_legend_title, length must same to the numbers of v_group}

\item{group_legend_order}{group_legend_order vector}

\item{plot_module}{logical, plot module?}

\item{mark_module}{logical, mark the modules?}

\item{mark_color}{mark colors}

\item{mark_alpha}{mark fill alpha, default 0.3}

\item{seed}{random seed, default:1234, make sure each plot is the same.}
}
\value{
a network plot
}
\description{
Plot a metanet
}
\examples{
data("c_net")
c_net_plot(co_net)
c_net_plot(co_net2)
c_net_plot(multi1)
}
