% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryROCPlot.R
\name{summaryROCPlot}
\alias{summaryROCPlot}
\title{Generate a plot with a summary ROC curve}
\usage{
summaryROCPlot(metaObject, filterObject, bootstrapReps = 500,
  orderByAUC = TRUE, alphaBetaPlots = TRUE)
}
\arguments{
\item{metaObject}{a Meta object which must have the $originalData populated}

\item{filterObject}{a MetaFilter object containing the signature genes that will be used for calculating the score}

\item{bootstrapReps}{number of bootstrap simulations to run for confidence interval on summary ROC}

\item{orderByAUC}{if TRUE, then order legend by summary AUC. Otherwise, use default ordering.}

\item{alphaBetaPlots}{if TRUE, then draw forest plots of alpha and beta. If false, suppress plotting.}
}
\value{
Generates a ROC plot for all datasets
}
\description{
Generate a plot with a summary ROC curve
}
\examples{
\dontrun{
summaryROCPlot(tinyMetaObject,filterObject = 
   tinyMetaObject$filterResults$pValueFDR0.05_es0_nStudies1_looaTRUE_hetero0)
}
}
\author{
Timothy E. Sweeney
}
