% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pooledROCplot.R
\name{pooledROCPlot}
\alias{pooledROCPlot}
\title{Generate a plot with a pooled ROC curve}
\usage{
pooledROCPlot(metaObject, filterObject, points = 1000, weighting = TRUE,
  title = NULL, size = 14, rounding = 3, smoothed = FALSE,
  auc1.thresh = 0.99, bootReps = 1000, minPoints = 5, numCores = 1,
  method = "random")
}
\arguments{
\item{metaObject}{a metaObject which must have \code{metaObject$originalData} populated with a list of \code{datasetObjects} that will be used for discovery}

\item{filterObject}{a metaFilter object containing the signature genes that will be used for calculating the score}

\item{points}{number of points to simulate for the approximated ROC curves during the linear interpolation (default: 1000)}

\item{weighting}{when calculating the mean AUC, if \code{weighting}=TRUE then the weighted mean AUC is calculated (default: TRUE)}

\item{title}{title of the plot}

\item{size}{size of the text/legend/etc (default: 14)}

\item{rounding}{how many digits to round the AUC and CI to (default: 3)}

\item{smoothed}{if TRUE, then a smoothed ROC curve is estimated using a modified version of the Kester and Buntinx Method}

\item{auc1.thresh}{(if \code{smoothed}=TRUE) if the AUC of a dataset is above this threshold, then it is treated as if the AUC were 1 (default: 0.99)}

\item{bootReps}{(if \code{smoothed}=TRUE) number of bootstrap iterations (default: 1000)}

\item{minPoints}{(if \code{smoothed}=TRUE) minimum number of points required for bootstrap to be used (default: 5)}

\item{numCores}{(if \code{smoothed}=TRUE) number of CPUs to use if parallel computing is desired (default: 1)}

\item{method}{(if \code{smoothed}=TRUE) method used to compute summary meta-statistics (default: "random")}
}
\value{
Generates a plot with each individual ROC curve as well as the pooled ROC curve
}
\description{
Given a \code{metaObject} with \code{$originalData} populated, this function calculates and
plots a "pooled" ROC curve that represents the average of all the individual ROC
curves. This version of the function is for use with MetaIntegrator.
}
\details{
To make sure the input is correctly formatted, the input \code{metaObject} should be checked with
\code{checkDataObject(metaObject, "Meta", "Pre-Analysis")} before starting the meta-analysis.

By default, this average ROC curve is calculated by first using linear
interpolation to create approximated versions of each given ROC curve that all
have the same set of FPR values. A pooled ROC curve is then calculated by
taking the weighted mean of the corresponding TPR values (weighting corresponds
to the number of samples in each dataset). This pooled curve is represented as
a black curve. In addition, the weighted standard deviation is calculated for
each TPR, which is represented by a grey area on the plot. The pooled AUC is
calculated by using the trapezoid method on the pooled ROC curve, and the 95\%
confidence interval of the pooled AUC is calculated using the pooled standard
error of the individual ROC curves.

If \code{smoothed}=TRUE, then a smoothed version of the pooled ROC curve will be
plotted instead, with the surrounding gray area representing the weighted
standard deviation of the pooled ROC curve. The statistics for this smoothed
curve are based on the Kester and Buntinx Method, from (Kester and Buntinx,
\emph{Med Decis Making}, 2000). Methods have been added by Tim Sweeney (2015) for better
estimates in cases with low numbers of tpr/fpr values. Methods have also been
added by Aditya Rao (2018) to predict the curve's alpha parameter for a given
beta parameter and AUC, as well as to calculate the weighted standard deviation
of the given ROC curves.
}
\examples{
pooledROCPlot(tinyMetaObject, filterObject = 
   tinyMetaObject$filterResults$pValueFDR0.05_es0_nStudies1_looaTRUE_hetero0)
}
\references{
Kester and Buntinx, \emph{Med Decis Making}, 2000
}
\seealso{
\code{\link{summaryROCPlot}}
}
\author{
Aditya Rao (with help from Hayley Warsinske and Francesco Vallania, original idea from Madeleine Scott, and some code adapted from Tim Sweeney)
}
