\name{get_mesh_pairs}
\alias{get_mesh_pairs}
\title{Get all pairs from list of 3D meshes}
\description{Generates all possible pairs based on a list of 3D meshes to enable post-processing with pairwise agreement measures.}
\usage{
get_mesh_pairs(x, sep=" <-> ", names_only=FALSE)
}
\arguments{
  \item{x}{\code{list} of observer/mesh objects as generated by \code{\link[MeshAgreement]{read_mesh}}.}
  \item{sep}{\code{character}. The string that indicates the separator between the first and second element in naming each generated pair of meshes.}
  \item{names_only}{\code{logical}. If \code{TRUE}, only include the names of the meshes and of their comparisons in the returned list, but not the meshes themselves.}
}
\details{Preparation for postprocessing with pairwise agreement measures using \code{\link[MeshAgreement]{get_mesh_agree_pair}}, \code{\link[MeshAgreement]{get_mesh_metro_pair}}, or \code{\link[MeshAgreement]{get_mesh_ui_pair}}.}
\value{\code{list} of \code{list}s with two mesh objects each, together with the name of the comparison, and a name for the compared structure as derived from the position of a mesh in the list representing an observer.}
\seealso{
\code{\link[MeshAgreement]{data_heart_obsL}},
\code{\link[MeshAgreement]{read_mesh}},
\code{\link[MeshAgreement]{get_mesh_agree_pair}},
\code{\link[MeshAgreement]{get_mesh_metro_pair}},
\code{\link[MeshAgreement]{get_mesh_ui_pair}}
}
\examples{
heartL <- mesh3dL_to_cgalMeshL(data_heart_obsL)
pairL  <- get_mesh_pairs(heartL)
pairL[[1]]
}
