\name{meshL_to_observerL}
\alias{meshL_to_observerL}
\title{Turn list of meshes into list of observer/mesh lists}
\description{Utility function that turns a list of meshes into a list of observers, each with a list of meshes.}
\usage{
meshL_to_observerL(x)
}
\arguments{
  \item{x}{\code{list} of meshes as generated by \code{\link[MeshAgreement]{read_mesh_obs}}.}
}
\details{Each mesh in the supplied list is assigned to a different observer. As a result, there will be as many observers as meshes, each observer with one mesh.}
\value{\code{list} of observer/mesh objects as generated by \code{\link[MeshAgreement]{read_mesh}}.}
\seealso{
\code{\link[MeshAgreement]{read_mesh}},
\code{\link[MeshAgreement]{read_mesh_obs}}
}
\examples{
heartL <- mesh3dL_to_cgalMeshL(data_heart_obsL)
meshL  <- heartL[["Obs01"]]
obsL   <- meshL_to_observerL(meshL)
}
