% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mr_egger-methods.R
\name{egger.bounds}
\alias{egger.bounds}
\title{Calculates confidence intervals for the MR-Egger method}
\usage{
egger.bounds(type, dist, .theta, .thetase, df = 0, .rse, .alpha)
}
\arguments{
\item{type}{"l" for lower, "u" for upper.}

\item{dist}{"normal" for normal distribution, "t-dist" for t-distribution.}

\item{df}{Degrees of freedom (for t-distribution).}

\item{.rse}{Residual standard error.}

\item{.alpha}{Significance level.}

\item{mean}{Causal estimate.}

\item{se}{Standard error of estimate.}
}
\value{
Numeric value of confidence interval limit.
}
\description{
Internal function for calculating confidence intervals for the MR-Egger method.
}
\details{
The slight complication of this function is that when the estimate of the residual standard error (RSE) is less than one, the t-distribution confidence interval is calculated as either the confidence interval using a normal deviate and setting the RSE to 1, or a t-distribution deviate and using the estimated RSE. The wider of the two intervals is reported. This ensures that under-dispersion is not doubly penalized, while also making sure that the estimate is no more precise than that from a fixed-effect analysis.

None.
}
\examples{
egger.bounds(type = "l", dist = "normal", .theta = 0, .thetase = 1, df = 0, .rse = 1, .alpha = 0.05)

}
\keyword{internal}
