% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertNaturalEarthAdm1.R
\name{convertNaturalEarthAdm1}
\alias{convertNaturalEarthAdm1}
\title{Convert Level 1 (State) Borders Shapefile}
\usage{
convertNaturalEarthAdm1(nameOnly = FALSE, simplify = TRUE)
}
\arguments{
\item{nameOnly}{Logical specifying whether to only return the name without
creating the file.}

\item{simplify}{Logical specifying whether to create "_05", _02" and "_01"
versions of the file that are simplified to 5\%, 2\% and 1\%.}
}
\value{
Name of the dataset being created.
}
\description{
Returns a SpatialPolygonsDataFrame for 1st level administrative divisions
}
\details{
A state border shapefile is downloaded and converted to a
SpatialPolygonsDataFrame with additional columns of data. The resulting file
will be created in the spatial data directory which is set with
\code{setSpatialDataDir()}.

Within the \pkg{MazamaSpatialUtils} package the phrase 'state' refers to
administrative divisions beneath the level of the country or nation. This
makes sense in the United 'States'. In other countries this level is known as
'province', 'territory' or some other term.
}
\references{
\url{http://www.naturalearthdata.com/downloads/}

\url{http://www.statoids.com/ihasc.html}
}
\seealso{
setSpatialDataDir

getVariable
}
\keyword{datagen}
