% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStateCode.R
\name{getStateCode}
\alias{getStateCode}
\title{Return State ISO Codes at Specified Locations}
\usage{
getStateCode(lon, lat, dataset = "NaturalEarthAdm1",
  countryCodes = NULL, allData = FALSE, useBuffering = FALSE)
}
\arguments{
\item{lon}{vector of longitudes in decimal degrees}

\item{lat}{vector of latitudes in decimal degrees}

\item{dataset}{name of spatial dataset to use}

\item{countryCodes}{vector of country codes}

\item{allData}{logical specifying whether a full dataframe should be returned}

\item{useBuffering}{logical flag specifying the use of location buffering to find the nearest polygon if no target polygon is found}
}
\value{
Vector of ISO-3166-2 alpha-2 state codes.
}
\description{
Uses spatial comparison to determine which 'state' polygons the 
    locations fall into and returns the ISO 3166 2-character state code
    strings for those polygons.
    
    Specification of \code{countryCodes} limits spatial searching to the specified
    countries and greatly improves performance.
    
    If \code{allData=TRUE}, additional data is returned.
}
\examples{
\dontrun{
lon <- seq(-140,-90)
lat <- seq(20,70)
getStateCode(lon,lat)
}
}
\seealso{
getSpatialData
}
\keyword{locator}
