% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCAcv.R
\name{PCAcv}
\alias{PCAcv}
\title{Principal Component Analysis cross-validation error}
\usage{
PCAcv(X, ncomp)
}
\arguments{
\item{X}{\code{matrix} object to perform PCA on.}

\item{ncomp}{\code{integer} number of components.}
}
\value{
A vector of PRESS-values.
}
\description{
PRESS values for PCA as implemented by Eigenvector and described by Bro et al. (2008).
}
\details{
For each number of components predicted residual sum of squares are calculated
based on leave-one-out cross-validation. The implementation ensures no over-fitting or
information bleeding.
}
\examples{
X1  <- scale( matrix( rnorm(100*300), 100,300), scale = FALSE)
PCAcv(X1,10)

}
\author{
Kristian Hovde Liland
}
\references{
R. Bro, K. Kjeldahl, A.K. Smilde, H.A.L. Kiers, Cross-validation of component models: A critical look at current methods. Anal Bioanal Chem (2008) 390: 1241-1251.
}
\seealso{
\code{\link{plot.SMI}} (print.SMI/summary.SMI), \code{\link{RV}} (RV2/RVadj), \code{\link{r1}} (r2/r3/r4/GCD), \code{\link{allCorrelations}} (matrix correlation comparison).
}

