\name{CsparseMatrix-class}
\docType{class}
\alias{CsparseMatrix-class}
\alias{coerce,CsparseMatrix,lsparseMatrix-method}
\alias{coerce,CsparseMatrix,lMatrix-method}
\alias{coerce,CsparseMatrix,nsparseMatrix-method}
\alias{coerce,CsparseMatrix,nMatrix-method}
\alias{coerce,CsparseMatrix,TsparseMatrix-method}
\alias{coerce,CsparseMatrix,denseMatrix-method}
\alias{coerce,matrix,CsparseMatrix-method}
\alias{coerce,numeric,CsparseMatrix-method}
\alias{diag,CsparseMatrix-method}
\alias{t,CsparseMatrix-method}
% "[" are in ./Xtrct-methods.Rd; "[<-" in ./Subassign-methods.Rd
%% Group methods --------- FIXME: not tested yet (or documented)
\alias{Compare,CsparseMatrix,CsparseMatrix-method}
\alias{Arith,CsparseMatrix,CsparseMatrix-method}
\alias{Arith,CsparseMatrix,numeric-method}
\alias{Arith,numeric,CsparseMatrix-method}
\alias{Logic,CsparseMatrix,CsparseMatrix-method}
\alias{Math,CsparseMatrix-method}
%
\alias{.validateCsparse}
%
\title{Class "CsparseMatrix" of Sparse Matrices in Column-compressed Form}
\description{The \code{"CsparseMatrix"} class is the virtual class of
  all sparse matrices coded in sorted compressed column-oriented form.
  Since it is a virtual class, no objects may be created from it.  See
  \code{showClass("CsparseMatrix")} for its subclasses.
}

\section{Slots}{
  \describe{
    \item{\code{i}:}{Object of class \code{"integer"} of length nnzero
      (number of non-zero elements).  These are the \emph{0-based} row numbers for
      each non-zero element in the matrix, i.e., \code{i} must be in
      \code{0:(nrow(.)-1)}.}
    \item{\code{p}:}{\code{\link{integer}} vector for providing pointers, one
      for each column, to the initial (zero-based) index of elements in
      the column.  \code{.@p} is of length \code{ncol(.) + 1}, with
      \code{p[1] == 0} and \code{p[length(p)] == nnzero}, such that in
      fact, \code{diff(.@p)} are the number of non-zero elements for
      each column.

      In other words, \code{m@p[1:ncol(m)]} contains the indices of
      those elements in \code{m@x} that are the first elements in the
      respective column of \code{m}.
    }
    \item{\code{Dim}, \code{Dimnames}:}{inherited from
      the superclass, see the \code{\linkS4class{sparseMatrix}} class.}
  }
}
\section{Extends}{
Class \code{"sparseMatrix"}, directly.
Class \code{"Matrix"}, by class \code{"sparseMatrix"}.
}
\section{Methods}{
  \describe{
    matrix products \code{\link[=crossprod-methods]{\%*\%}},
    \code{\link[=crossprod-methods]{crossprod}()} and \code{tcrossprod()},
    several \code{\link{solve}} methods,
    and other matrix methods available:
    %% The following is generated by promptClass(..) --
    %% FIXME: write a script that update all the *-class.Rd files
    \item{Arith}{\code{signature(e1 = "CsparseMatrix", e2 = "numeric")}: ... }
    \item{Arith}{\code{signature(e1 = "numeric", e2 = "CsparseMatrix")}: ... }
    \item{Math}{\code{signature(x = "CsparseMatrix")}: ... }

    \item{band}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{-}{\code{signature(e1 = "CsparseMatrix", e2 = "numeric")}: ... }
    \item{-}{\code{signature(e1 = "numeric", e2 = "CsparseMatrix")}: ... }
    \item{+}{\code{signature(e1 = "CsparseMatrix", e2 = "numeric")}: ... }
    \item{+}{\code{signature(e1 = "numeric", e2 = "CsparseMatrix")}: ... }
    \item{coerce}{\code{signature(from = "CsparseMatrix", to = "TsparseMatrix")}: ... }
    \item{coerce}{\code{signature(from = "CsparseMatrix", to = "denseMatrix")}: ... }
    \item{coerce}{\code{signature(from = "CsparseMatrix", to = "matrix")}: ... }
    \item{coerce}{\code{signature(from = "CsparseMatrix", to = "lsparseMatrix")}: ... }
    \item{coerce}{\code{signature(from = "CsparseMatrix", to = "nsparseMatrix")}: ... }
    \item{coerce}{\code{signature(from = "TsparseMatrix", to = "CsparseMatrix")}: ... }
    \item{coerce}{\code{signature(from = "denseMatrix", to = "CsparseMatrix")}: ... }
    \item{diag}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{gamma}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{lgamma}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{log}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{t}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{tril}{\code{signature(x = "CsparseMatrix")}: ... }
    \item{triu}{\code{signature(x = "CsparseMatrix")}: ... }
  }
}
\note{
  All classes extending \code{CsparseMatrix} have a common validity
  (see \code{\link{validObject}}) check function.  That function
  additionally checks the \code{i} slot for each column to contain
  increasing row numbers. \cr
  In earlier versions of \pkg{Matrix} (\code{<= 0.999375-16}),
  \code{\link{validObject}} automatically re-sorted the entries when
  necessary, and hence \code{new()} calls with somewhat permuted
  \code{i} and \code{x} slots worked, as \code{\link{new}(...)}
  (\emph{with} slot arguments) automatically checks the validity.

  Now, you have to use \code{\link{sparseMatrix}} to achieve the same
  functionality or know how to use \code{.validateCsparse()} to do so.
}
\seealso{
  \code{\link{colSums}}, \code{\link{kronecker}}, and other such methods
  with own help pages.

  Further, the super class of \code{CsparseMatrix},
  \code{\linkS4class{sparseMatrix}}, and, e.g.,
  class \code{\linkS4class{dgCMatrix}} for the links to other classes.
}
\examples{
getClass("CsparseMatrix")

## The common validity check function (based on C code):
getValidity(getClass("CsparseMatrix"))
}
\keyword{classes}
