\name{unmaskAndGetSampleBatch}
\alias{unmaskAndGetSampleBatch}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Batch function that allows the user to unmask a number of variables as
well as to sample from the estimated joint density function. 
Serves as a wrapper for the first and second functions the End-User
calls to obtain the samples from the 
marginal distributions of the unmasked data.
}
\description{
Use the sample-moment-based density approximant method to estimate the
density function 
of univariate distributions based noise multiplied data. 
Afterwards if the Data Provider supplies all the means, standard deviations and the correlation matrix of the original data then these can be used as arguments. Otherwise, these are calculated using the mean of noise sample and the mean of the vector created by squaring each element of the noise sample.

A sample of the chosen size is then simulated from the estimated joint density function.

}
\usage{
unmaskAndGetSampleBatch(listOfMaskedVectorsToBeUnmasked,
                                    listOfNoisefiles,
                                    mu, s, rho_X,
                                    cores = 1, size,
                                    verbose = -1,
                                    onlyUnmasked = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{listOfMaskedVectorsToBeUnmasked}{
list of masked vectors. The masked data were generated by R Function mask, or maskBatch.
}
  \item{listOfNoisefiles}{
Noise files containing a sample of the noise used to mask the vectors in listOfMaskedVectorsToBeUnmasked from R function mask, or maskBatch
}
  \item{mu}{
List of means of unmasked vectors - if not supplied will be estimated
}
  \item{s}{
List of standard deviations of unmasked vectors - if not supplied will be estimated 
}
  \item{rho_X}{
Correlation matrix of unmasked vectors - if not supplied will be estimated 
}
  \item{cores}{
Passed to mclapply
}
  \item{size}{
Passed to actualPosition
}
  \item{verbose}{
If greater than 0 output is printed to tell the user at what stage the function is in, is also passed to many internal functions and will give more detailed output from them if it is greater than 1
}
  \item{onlyUnmasked}{
If true then only the output from unmask is returned. Effectively this makes the function "unmaskBatch" - so to speak. False by default.
}
}
\details{
unmask is fully described in Lin and Fielding (2015). The theory used to support unmask can 
be found in Lin (2014). unmask implements the sample-moment-based density approximate method 
the estimated the smoothed density function of the original data based on their make data maskedVectorToBeUnmasked. 
The output of the function unmask is a set of sample data from the estimated mouthed density 
function. 

Using this function is the equivalent of calling unmask once for each variable and then calling getSampleBasedOnUnmaskedData

}
\value{
If onlyUnmasked is false then returns a list with two elements, both of which are lists.
 \item{unmaskedOutputs }{list containing the three (four if categorical) outputs from the function unmask namely: unmaskedVariable, meanOfNoise, meanOfSquaredNoise, prob}
 \item{getSampleOutputs }{list containing the output from getSampleBasedOnUnmaskedData which is a list containing vectors corresponding to samples for each variable }
If onlyUnmasked is true then returns a list with only one element:
 \item{unmaskedOutputs }{list containing the three (four if categorical) outputs from the function unmask namely: unmaskedVariable, meanOfNoise, meanOfSquaredNoise, prob}
}
\references{
Lin, Yan-Xia (2014). Density approximant based on noise multiplied data. In J. Domingo-Ferrer (Eds.), Privacy in Statistical Databases 2014, 
LNCS 8744, Springer International Publishing Switzerland, 2014, pp. 89-104.
Lin, Yan-Xia and Fielding, Mark James (2015). MaskDensity14: An R Package for the Density Approximant of a Univariate
Based on Noise Multiplied Data, SoftwareX 34, 3743, doi:10.1016/j.softx.2015.11.002

}
\author{
Luke Mazur
}

\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.

##outputNL1 <- unmaskAndGetSampleBatch(listOfMaskedVectorsToBeUnmasked = ##list(ystar1, ystar2),
##                                    listOfNoisefiles = 
## (file.path(tempdir(),"noise1.bin"),file.path(tempdir(),"noise2.bin")),
##                                    cores = 1, size = 1000,
##                                    verbose = 2)
## not a real example because ultimately in order to demonstrate this
## function the entire package functionality must be demonstrated
## this is demonstrated in the package example
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
