% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{Resamples}
\alias{Resamples}
\title{Resamples Class Contructor}
\usage{
Resamples(..., method = NULL, seed = NULL)
}
\arguments{
\item{...}{named or unnamed resample output from one or more models.}

\item{method}{character string indicating the type of resampling method.}

\item{seed}{integer seed from the resampling control object.}
}
\value{
Resamples class object.
}
\description{
Create an object of resampled performance metrics from one or more models.
}
\details{
Arguments \code{method} and \code{seed} need only be specified if
the supplied output is not a Resamples object.  Output being combined from
more than one model must have been generated with the same resampling
method, random number generator seed, performance metrics, and number of
resampling evaluations.
}
\examples{
## Factor response example

fo <- factor(Species) ~ .
control <- CVControl()

gbmperf1 <- resample(fo, iris, GBMModel(n.trees = 25), control)
gbmperf2 <- resample(fo, iris, GBMModel(n.trees = 50), control)
gbmperf3 <- resample(fo, iris, GBMModel(n.trees = 100), control)

perf <- Resamples(GBM1 = gbmperf1, GBM2 = gbmperf2, GBM3 = gbmperf3)
summary(perf)
plot(perf)

}
\seealso{
\code{\link{resample}}, \code{\link{plot}}, \code{\link{summary}}
}
