% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R2mtch.R
\name{compute_R2mtch}
\alias{compute_R2mtch}
\title{Modified tchebyscheff R2-indicator}
\usage{
compute_R2mtch(dataPoints, reference, weights = NULL, nWeight = 100)
}
\arguments{
\item{dataPoints}{The Points coordinate. Each column contains a single point (column major).}

\item{reference}{The reference point for computing R2-mtch (similar as reference for HV)}

\item{weights}{The weights/direction to be used to compute the achievement scalarization. Each column contains a single weight vector. If no weight is supplied, weights are generated using Sobol sequences.}

\item{nWeight}{Used only when no weights are supplied. An input for the sobol weight generation. This defines how many points to be generated.}
}
\value{
The function return the R2-indicator of the set.
}
\description{
Compute the R2-mtch indicator from Shang et al.
}
\examples{
nPointToSample <- 100
nObjective <- 3
points <- matrix(runif(nPointToSample*nObjective), nrow = nObjective) # sample the points
ranks <- nsga2R::fastNonDominatedSorting(t(points)) # non-dominated sorting
points <- points[,ranks[[1]],drop=FALSE] # take only the non-dominated front
nPoints <- ncol(points) # check how many points are on the non-dominated front
reference <- rep(2,nObjective)

compute_R2mtch(points,reference)
}
\references{
Ke Shang, Hisao Ishibuchi, Min-Ling Zhang, and Yiping Liu. 2018. A new R2 indicator for better hypervolume approximation. In Proceedings of the Genetic and Evolutionary Computation Conference (GECCO '18), Hernan Aguirre (Ed.). ACM, New York, NY, USA, 745-752. DOI: https://doi.org/10.1145/3205455.3205543
}
