% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstats.R
\name{Get_zeta}
\alias{Get_zeta}
\title{Calculate Covariances of Z-scores between Traits from Overlapping Samples}
\usage{
Get_zeta(Zscore, pval_cutoff = 0.05, Indp_common_snp)
}
\arguments{
\item{Zscore}{a numeric list, each sublist containing a vector of Z scores of SNPs with minor allele frequency (MAF) larger than 0.05. The chr:pos for each SNP is required.}

\item{pval_cutoff}{a numeric value indicating the cutoff threshold of p-values. The default value is 0.05. Variants with p-value less than or equal to this threshold will be automatically removed.}

\item{Indp_common_snp}{a numeric list of independent common SNPs}
}
\value{
A \eqn{K \times K} matrix \eqn{\zeta}, where \eqn{K} is the number of traits.
}
\description{
This function allows you to estimate the matrix \eqn{\zeta} to adjust for the potential sample overlap in the data set. Here we applied LD pruning (\eqn{r^2 < 0.1} in 500kb region) on 1000 Genome genotype dataset (hg19) as a list of reference independent SNPs. The SNP ID is chr:pos.
}
\examples{
\donttest{data(zeta.example)
attach(zeta.example)
# Downloading independent common SNPs from 1000Genome data set.
githubURL <- "https://github.com/lan/MTAR/blob/master/indp_snps.1KG.rda?raw=true"
utils::download.file(githubURL,"1kgfile")
load("1kgfile")
zeta1 <- Get_zeta(Zscore = Zscore, Indp_common_snp = indp_snps.1KG)
zeta1
detach(zeta.example)
}
}
\author{
Lan Luo
}
