% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htest_HLRTest.R
\name{HLRTest}
\alias{HLRTest}
\title{Hansen (1992) likelihood ratio test}
\usage{
HLRTest(Y, p, control = list())
}
\arguments{
\item{Y}{A (\code{T x 1}) matrix of observations.}

\item{p}{Integer determining the number of autoregressive lags.}

\item{control}{List with test procedure options including: 
\itemize{
  \item ix: List of Markov Switching parameters. 1 = just mean c(1,2) = mean and first param, (default: 1).
  \item msvar: Boolean indicator. If \code{TRUE}, there is a switch in variance. If \code{FALSE} only switch in mean is considered. Default is \code{FALSE}.
  \item qbound: Indicator that bounds q by 1-p (default: \code{FALSE}).
  \item gridsize: Integer determining the number of grid points for markov switching parameters. Default is \code{20}.
  \item pgrid_from: Double determining the initial grid point for transition probabilities. Default is \code{0.1}.
  \item pgrid_by: Double determining the step size for grid points of transition probabilities. This, along with \code{p_gridsize} will determine the bounds of search space. Default is \code{0.075}.
  \item pgrid_to: Double determining the end grid point for transition probabilities. Default is \code{0.925}.
  \item mugrid_from: Double determining the minimum value of mean in second regime. Default is \code{0.1}.
  \item mugrid_by: Double determining the step size for grid points of mean in second regime. This, along with \code{gridsize} will determine the max value of mean in second regime. Default is \code{0.1}.
  \item siggrid_from: Double determining the minimum value of sigma in second regime (if \code{msvar = TRUE}). Default is \code{0.1}.
  \item siggrid_by: Double determining the step size for grid points of sigma in second regime. This, along with \code{gridsize} will determine the max value of sigma in second regime. Default is \code{0.1}.
  \item N: Integer determining the number of replications. Default is \code{1000}.
  \item nwband: Integer determining maximum bandwidth in Bartlett kernel. Critical values and p-values are returned for each bandwidth from \code{0:nwband} as suggested in Hansen (1996). Default is \code{4}.
  \item theta_null_low: Vector determining lower bound on parameters under the null hypothesis. Length of vector should be number of model coefficients + 1 for variance. Default is to only bound variance at \code{0.01}.
  \item theta_null_upp: Vector determining upper bound on parameters under the null hypothesis. Length of vector should be number of model coefficients + 1 for variance. Default is to no bounds (i.e. \code{Inf}).
  \item optim_method: String determining the type of optimization procedure used. Allowed options are "gp-optim" for general purpose optimization using \code{\link{optim}} from \code{\link{stats}} or "nl-optim" using \code{\link{slsqp}} from \code{\link{nloptr}}. Default is "gp-optim".
}}
}
\value{
List of class \code{HLRTest} (\code{S3} object) with model attributes including: 
\itemize{
  \item mdl_h0: List with restricted model attributes. This will be of class \code{ARmdl} (\code{S3} object). See \code{\link{ARmdl}}.
  \item LR0: Likelihood ratio test statistic value.
  \item LRN: A (\code{N x 1}) vector with simulated LRT statistics under null hypothesis.
  \item pval: P-value.
  \item LR_cv: A (\code{nwband x 3}) matrix with 90\%, 95\%, and 99\% critical values in each column respectively.
  \item coef: Vector of coefficients from restricted model and grid search that maximized standardized LRT. 
  \item control: List with test procedure options used.
}
}
\description{
This function performs Hansen's likelihood ratio test as described in Hansen (1992).
Original source code can be found \href{https://www.ssc.wisc.edu/~bhansen/progs/jae_92.html}{here}.
}
\examples{
# --------------------------- Use simulated process ----------------------------
set.seed(1234)
# Define DGP of MS AR process
mdl_ms2 <- list(n     = 200, 
                mu    = c(5,1),
                sigma = c(1,1),
                phi   = c(0.5),
                k     = 2,
                P     = rbind(c(0.90, 0.10),
                              c(0.10, 0.90)))

# Simulate process using simuMSAR() function
y_ms_simu <- simuMSAR(mdl_ms2)

hlrt_control  <- list(ix          = 1, 
                      gridsize    = 5,
                      p_gridsize  = 9,
                      p_stepsize  = 0.1,
                      mugrid_from = 0,
                      mugrid_by   = 1)

\donttest{
  hlrt <- HLRTest(y_ms_simu$y, p = 1, control = hlrt_control)
  summary(hlrt)
}

}
\references{
Hansen, Bruce E. 1992. “The likelihood ratio test under nonstandard conditions: testing the Markov switching model of GNP.” \emph{Journal of applied Econometrics} 7 (S1): S61–S82.

Hansen, Bruce E. 1996. “Erratum: The likelihood ratio test under nonstandard conditions: testing the Markov switching model of GNP.” \emph{Journal of applied Econometrics} 7 (S1): S61–S82.
}
