% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simuVAR}
\alias{simuVAR}
\title{Simulate VAR process}
\usage{
simuVAR(mdl_h0, burnin = 100L)
}
\arguments{
\item{mdl_h0}{List containing the following DGP parameters
\itemize{
  \item{\code{n}: }{Length of series.}
  \item{\code{mu}: }{A (\code{q x 1}) vector of means.}
  \item{\code{sigma}: }{A (\code{q x q}) covariance matrix.}
  \item{\code{phi}: }{ A (\code{q x qp}) matrix of autoregressive coefficients.}
  \item{\code{p}: }{Number of autoregressive lags.}
  \item{\code{q}: }{Number of series.}
  \item{\code{eps}: }{An optional (\code{T+burnin x q}) matrix with standard normal errors to be used. Errors will be generated if not provided.}
}}

\item{burnin}{Number of simulated observations to remove from beginning. Default is \code{100}.}
}
\value{
List with simulated vector autoregressive series and its DGP parameters.
}
\description{
This function simulates a vector autoregresive process.
}
\examples{
set.seed(1234)
# Define DGP of VAR process
mdl_3var2 <- list(n     = 1000, 
                  p     = 2,
                  q     = 3,
                  mu    = c(5, -2, 1),
                  sigma = rbind(c(5.0, 1.5, 2.5),
                                c(1.5, 1.0, 1.5),
                                c(2.5, 1.5, 4.2)),
                  phi   = rbind(c(0.70, 0.30, 0.35,  -0.50, -0.20,   0.25),
                                c(0.20, 0.40, 0.35,  -0.30,  0.30,   0.25),
                                c(0.20, 0.30, 0.50,  -0.30, -0.20,  -0.40)))

# Simulate process using simuVAR() function
y3var2_simu <- simuVAR(mdl_3var2)

}
