% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC.R
\name{AIC}
\alias{AIC}
\alias{AIC.MSGARCH_ML_FIT}
\alias{AIC.MSGARCH_MCMC_FIT}
\title{Akaike information criterion (AIC).}
\usage{
AIC(fit)

\method{AIC}{MSGARCH_ML_FIT}(fit)

\method{AIC}{MSGARCH_MCMC_FIT}(fit)
}
\arguments{
\item{fit}{Fit object of type \code{MSGARCH_ML_FIT} created with \code{\link{FitML}}
or \code{MSGARCH_MCMC_FIT} created with \code{\link{FitMCMC}}.}
}
\value{
AIC value.
}
\description{
Method which computes the Akaike information criterion (AIC) from a fit object of type
\code{MSGARCH_ML_FIT} created with \code{\link{FitML}}
or \code{MSGARCH_MCMC_FIT} created with \code{\link{FitMCMC}}.
}
\details{
Computes the Akaike information criterion (AIC) based on the work of Akaike (Akaike, 1974).
If a matrix of MCMC posterior draws is given, the AIC on the posterior mean is calculated.
}
\examples{
# load data
data("SMI", package = "MSGARCH")

# create model specification
# MS(2)-GARCH(1,1)-Normal (default)
spec <- CreateSpec()

# fit the model on data by ML
fit <- FitML(spec = spec, data = SMI)

# compute AIC
AIC(fit)
}
\references{
Akaike, H. (1974).
A new look at the statistical model identification.
\emph{IEEE Transactions on Automatic Control}, 19, 716-723.
}
