# 基础作图法绘制控制变量 z 之后 y 与 x 的关系
set.seed(123)
x = seq(0, 4, length = 100)
z = rep(0:4, each = 20)
y = -x + z + rnorm(100, 0, .25)
par(mar = c(4.5, 4.5, .1, 0.5), mfrow = c(1, 2))
plot(x, y)
abline(lm(y ~ x), col = "red")
plot(x, y, pch = z, col = rainbow(5)[z + 1])
# 对每一组 z 的取值，分别拿相应的 x 和 y 回归并画回归直线
for (i in z) abline(lm(y ~ x, subset = z == i), col = "darkgray")
