% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuartetTally.R
\name{quartetTablePrint}
\alias{quartetTablePrint}
\title{Print a quartet table with nice formatting}
\usage{
quartetTablePrint(qt)
}
\arguments{
\item{qt}{a table such as returned by \code{quartetTable}, \code{quartetTableResolved}, 
or \code{quartetTableDominant}, possibly with extra columns added by other functions}
}
\description{
Print a quartet table with the taxa in each quartet shown by name.
}
\examples{
 gtrees=read.tree(file=system.file("extdata","dataGeneTreeSample",package="MSCquartets"))
 tnames=taxonNames(gtrees)
 QT=quartetTable(gtrees,tnames[1:6])
 QT[1:6,]
 quartetTablePrint(QT[1:6,])  
 RQT=quartetTableResolved(QT)
 RQT[1:6,]
 quartetTablePrint(RQT[1:6,])
 pTable=quartetTreeTestInd(RQT,"T3")
 pTable[1:6,] 
 quartetTablePrint(pTable[1:6,])
 DQT=quartetTableDominant(RQT)
 DQT[1:6,]
 quartetTablePrint(DQT[1:6,])
 
}
