% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MVGMM-class}
\alias{MVGMM-class}
\title{MVGMM Class}
\description{
An object containing the estimates produced using the multivariable generalized method of methods (GMM) method.
}
\section{Slots}{

\describe{
\item{\code{robust}}{Whether the robust model with overdispersion heterogeneity is estimated.}

\item{\code{Exposure}}{The names of the exposure variables.}

\item{\code{Outcome}}{The name of the outcome variable.}

\item{\code{Correlation}}{The matrix of correlations between genetic variants if specified. If not specified, an identity matrix will be returned.}

\item{\code{ExpCorrelation}}{Whether an exposure correlation matrix was specified.}

\item{\code{CondFstat}}{The conditional F-statistic for each exposure.}

\item{\code{Estimate}}{The causal estimates from the GMM method.}

\item{\code{StdError}}{The standard errors associated with \code{Estimate}.}

\item{\code{CILower}}{The lower bounds of the confidence interval for \code{Estimate} based on \code{StdError}.}

\item{\code{CIUpper}}{The upper bounds of the confidence interval for \code{Estimate} based on \code{StdError}.}

\item{\code{Overdispersion}}{The estimate of the overdispersion parameter for the robust model. If this is negative, then a value of zero is used in the method.}

\item{\code{Pvalue}}{P-value associated with the causal estimates.}

\item{\code{Alpha}}{The significance level used in constructing confidence intervals (default is 0.05).}

\item{\code{Heter.Stat}}{Heterogeneity statistic (Cochran's Q statistic) and associated p-value (for non-robust model): the null hypothesis is that all genetic variants estimate the same causal parameter; rejection of the null is an indication that one or more genetic variants may be pleiotropic.}
}}

