% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_vs_n_plot.R
\name{power_vs_n_plot}
\alias{power_vs_n_plot}
\title{Returns a plot of power vs sample size in the context of a binary outcome
MRT. See the vignette for more details.}
\usage{
power_vs_n_plot(
  avail_pattern,
  f_t,
  g_t,
  beta,
  alpha,
  p_t,
  gamma,
  min_n = max(min_samp(alpha, beta), 11),
  max_n = max_samp(min_n)
)
}
\arguments{
\item{avail_pattern}{A vector of length T that is the average availability at
each time point}

\item{f_t}{Defines marginal excursion effect MEE(t) under
alternative together with beta. Assumed to be matrix of size T*p.}

\item{g_t}{Defines success probability null curve together with
alpha. Assumed to be matrix of size T*q.}

\item{beta}{Length p vector that defines marginal excursion effect
MEE(t) under alternative together with f_t.}

\item{alpha}{Length q vector that defines success probability null
curve together with g_t.}

\item{p_t}{Length T vector of Randomization probabilities at each
time point.}

\item{gamma}{Desired Type I error}

\item{min_n}{Minimum of range of sample sizes to plot. Should be
greater than the sum of the dimensions of alpha and beta.}

\item{max_n}{Maximum of range of sample sizes to plot. Should be
greater than min_n.}
}
\value{
Plot of power and sample size
}
\description{
Returns a plot of power vs sample size in the context of a binary outcome
MRT. See the vignette for more details.
}
\examples{
           power_vs_n_plot(tau_t_1, f_t_1, g_t_1, beta_1, alpha_1,
                        p_t_1, 0.05, 15, 700)
}
