#### 1- ... #### 
Line 25 :   \item{...}{arguments to be passed to \code{\link{calcGR}} for specifying the settings of the growing region algorithm : \code{range}, \code{range.seed}, \code{breaks}, \code{scale}, \code{iter_max}, \code{sd.robust}, \code{keep.lower} and  \code{keep.upper}.}   # GRalgo-calcSigmaGR.Rd
Line 24 :   \item{...}{additional arguments for the graphical device : \code{window}, \code{width}, \code{height}, \code{path}, \code{unit}, \code{res} (see \code{\link{optionsMRIaggr}}).} # GRalgo-plotSigmaGR.Rd
Line 31 :   \item{...}{additional arguments to be passed to \code{\link{optionsMRIaggr}} for specifying the graphical parameters.} # MRIaggr-boxplotMask.Rd
Line 36 :   \item{...}{additional arguments to be passed to \code{\link{optionsMRIaggr}} for specifying the graphical parameters.} # MRIaggr-calcBrainMask.Rd
Line 41 :   \item{...}{additional arguments to be passed to \code{\link{optionsMRIaggr}} for specifying the graphical parameters.} # MRIaggr-calcHemisphere.Rd
Line 23 :   \item{...}{additional arguments to be passed to \code{\link{optionsMRIaggr}} for specifying the graphical parameters.} # MRIaggr-calcROCthreshold.Rd
Line 34 :   \item{...}{additional arguments to be passed to \code{\link{optionsMRIaggr}} for specifying the graphical parameters.} # MRIaggr-heatmapMRIaggr.Rd
Line 38 :   \item{...}{additional arguments to be passed to \code{\link{optionsMRIaggr}} for specifying the graphical parameters.} # MRIaggr-multiplot.Rd
Line 37 :   \item{...}{additional arguments to be passed to \code{\link{optionsMRIaggr}} for specifying the graphical parameters.} # MRIaggr-plotDistClass.Rd
Line 33 :   \item{...}{additional arguments to be passed to \code{\link{optionsMRIaggr}} for specifying the graphical parameters.} # MRIaggr-plotTableLesion.Rd
Line 11 :   \item{...}{arguments in tag = value form, or a list of tagged values. \emph{character} or \emph{list}.} # options-optionsMRIaggr.Rd
Line 17 :   \item{...}{additional arguments to be passed to the function called by \code{calcPottsParameter} to perform the estimation. See the arguments of \code{link{rhoMF}} or \code{link{rhoLvfree}}.} # sfMM-calcPottsParameter.Rd

#### 2- accept.coords #### 
Line 18 :   \item{accept.coords}{should coordinates be accepted as parameters ? \emph{logical}.} # MRIaggr-initParameter.Rd

#### 3- accept.index #### 
Line 20 :   \item{accept.index}{should index be accepted as a parameter ? \emph{logical}.} # MRIaggr-initParameter.Rd

#### 4- accept.mask #### 
Line 19 :   \item{accept.mask}{should mask be accepted as a parameter ? \emph{logical}.} # MRIaggr-initParameter.Rd

#### 5- add #### 
Line 15 :   \item{add}{should \code{value} be added to the existing clinical slot ? \emph{logical}.} # MRIaggr-allocClinic.Rd

#### 6- alpha #### 
Line 17 :   \item{alpha}{the type 1 error rate. \emph{numeric}.}   # Miscellaneous-calcAUPRC.Rd

#### 7- angle.test #### 
Line 29 :   \item{angle.test}{the angle or the number of angle to test. \emph{numeric vector} or \emph{postive integer}.} # MRIaggr-calcHemisphere.Rd

#### 8- angle_pos #### 
Line 21 :   \item{angle_pos}{the angle between the axis of the second coordinate and the mid-sagittal plane. \emph{numeric}.} # MRIaggr-calcHemi_cpp.Rd

#### 9- arg_name #### 
Line 18 :   \item{arg_name}{a short name for the error message. \emph{character}.} # MRIaggr-initMask.Rd
Line 21 :   \item{arg_name}{a short name for the error message. \emph{character}.} # MRIaggr-initParameter.Rd

#### 10- array #### 
Line 12 :   \item{array}{the values of the contrast parameter. \code{array}. REQUIRED.} # Carto3D-constCarto3D.Rd
Line 12 :   \item{array}{the array that should be converted into a data.frame. \emph{array} or \emph{matrix}. REQUIRED.} # MRIaggr-array2df.Rd
Line 13 :   \item{array}{alternative specification of the spatial coordinates using an array where the non-NA values indicates the points of interest. \emph{array} or \code{NULL} leading to consider the \code{coords} argument.} # MRIaggr-calcGroupsCoords.Rd
Line 12 :   \item{array}{alternative specification of the spatial coordinates using an array where the non-NA values indicates the points of interest. \emph{array} or \code{NULL} leading to use the \code{coords} argument.} # MRIaggr-plotOutline.Rd

#### 11- asp #### 
Line 17 :   \item{asp}{the aspect ratio y/x. \emph{numeric}.} # MRIaggr-plotMRI.Rd

#### 12- author #### 
Line 36 :   \item{author}{the author of the latex document. \emph{character}.} # Miscellaneous-constLatex.Rd

#### 13- axes #### 
Line 23 :   \item{axes}{should the axes be plotted ? \emph{logical}.} # MRIaggr-plotMRI.Rd

#### 14- bandwidth #### 
Line 12 :   \item{bandwidth}{the bandwidth of the kernel. \emph{numeric}.} # Miscellaneous-EDK.Rd
Line 17 :   \item{bandwidth}{the bandwidth of the kernel. \emph{postive numeric}. REQUIRED.} # MRIaggr-calcRegionaContrast.Rd

#### 15- beta #### 
Line 18 :   \item{beta}{the parameter 'inverse temperature' of the Potts model. \emph{numeric}.} # MRIaggr-calcTissueType.Rd

#### 16- bg #### 
Line 21 :   \item{bg}{the color used for the background. \emph{character}.} # MRIaggr-initDisplayWindow.Rd

#### 17- bilateral #### 
Line 21 :   \item{bilateral}{should the influence of each neighbor be ponderated by the difference in signal with the considered observation ? \emph{logical}.} # MRIaggr-calcFilter.Rd
Line 14 :   \item{bilateral}{should the influence of each neighbor be ponderated by the difference in signal with the considered observation ?} # MRIaggr-filtrage2D_cpp.Rd
Line 17 :   \item{bilateral}{should the influence of each neighbor be ponderated by the difference in signal with the considered observation ?} # MRIaggr-filtrage3D_cpp.Rd

#### 18- breaks #### 
Line 17 :   \item{breaks}{the break points to use to categorize the contrast distribution. \emph{numeric vector}.} # GRalgo-calcCriteriaGR.Rd
Line 21 :   \item{breaks}{the break points or the number of break points to use to categorize the contrast distribution. \emph{numeric vector} or \code{postive integer}.} # GRalgo-calcGR.Rd
Line 18 :   \item{breaks}{the break points to use to categorize the contrast distribution. \emph{numeric vector}.} # GRalgo-GRalgo.Rd
Line 20 :   \item{breaks}{the break points or the number of break points to use to categorize the contrast distribution. \emph{numeric vector} or \code{postive integer}.} # GRalgo-initGR.Rd
Line 24 :   \item{breaks}{the break points to use to generate the color intervals. \emph{numeric vector} or \code{NULL} leading to automatic breakpoints generation.} # MRIaggr-heatmapMRIaggr.Rd
Line 18 :   \item{breaks}{the break points or the number of breakpoints to use to generate the color intervals. \emph{numeric vector} or \emph{postive integer}.} # MRIaggr-initCol.Rd
Line 14 :   \item{breaks}{the break points to use to generate the color intervals. \emph{numeric vector}.} # MRIaggr-legendMRI.Rd
Line 30 :   \item{breaks}{the break points or the number of breakpoints to use to generate the color intervals . \emph{numeric vector} or \emph{postive integer}.} # MRIaggr-outlineMRIaggr.Rd
Line 14 :   \item{breaks}{the break points to use to generate the color intervals. \emph{numeric vector}.} # MRIaggr-plotMRI.Rd

#### 19- burn_in #### 
Line 26 :   \item{burn_in}{the number of iteration of the burn in phase. \emph{integer}.} # sfMM-rhoLvfree.Rd

#### 20- bw.adjust #### 
Line 21 :   \item{bw.adjust}{the smoothing bandwidth to use. \emph{numeric}. See \code{\link{density}} for more details.} # MRIaggr-plotDistClass.Rd

#### 21- calcBlockW #### 
Line 30 :   \item{calcBlockW}{should the partition into disjoint spatial blocks of sites be computed ? \emph{logical}.} # MRIaggr-calcW.Rd

#### 22- calcSigmaGR #### 
Line 16 :   \item{calcSigmaGR}{an object generated by the \code{\link{calcSigmaGR}} function. REQUIRED.}  # GRalgo-plotSigmaGR.Rd

#### 23- cex #### 
Line 20 :   \item{cex}{the expansion factor for the legend labels. \emph{positive numeric}.} # MRIaggr-legendMRI.Rd
Line 17 :   \item{cex}{the expansion factor used to plot the edge points, the interpolated edge points and the interior points. \emph{positive numeric vector of size 3}.} # MRIaggr-outline.Rd
Line 40 :   \item{cex}{the expansion factor used to plot the edge points, the interpolated edge points and the interior points. \emph{positive numeric vector of size 3}.} # MRIaggr-outlineMRIaggr.Rd
Line 22 :   \item{cex}{the expansion factor for the observation labels. \emph{positive numeric}.} # MRIaggr-plotMRI.Rd

#### 24- cex.axis #### 
Line 31 :   \item{cex.axis}{the magnification to be used for axis annotation relative to the current setting of cex. \emph{positive numeric}.} # MRIaggr-heatmapMRIaggr.Rd
Line 29 :   \item{cex.axis}{the magnification to be used for axis annotation relative to the current setting of cex. \emph{positive numeric}.}		 # MRIaggr-plotTableLesion.Rd

#### 25- cex.default #### 
Line 19 :   \item{cex.default}{the default expansion factor used to plot the observations. \emph{numeric}.} # MRIaggr-initIndex.Rd

#### 26- cex.lab #### 
Line 30 :   \item{cex.lab}{the magnification to be used for x and y labels relative to the current setting of cex. \emph{positive numeric}.}		 # MRIaggr-plotTableLesion.Rd

#### 27- cex.legend #### 
Line 28 :   \item{cex.legend}{the expansion factor of the legend. \emph{positive numeric}.}		 # MRIaggr-boxplotMask.Rd
Line 34 :   \item{cex.legend}{the expansion factor of the legend. \emph{positive numeric}.}		 # MRIaggr-plotDistClass.Rd
Line 28 :   \item{cex.legend}{the expansion factor of the legend. \emph{positive numeric}.}		 # MRIaggr-plotTableLesion.Rd

#### 28- cex.main #### 
Line 19 :   \item{cex.main}{the expansion factor for the legend title. \emph{positive numeric}.} # MRIaggr-legendMRI.Rd
Line 29 :   \item{cex.main}{the expansion factor for the main title. \emph{numeric}.} # MRIaggr-plotMRI.Rd
Line 27 :   \item{cex.main}{the expansion factor for the main title. \emph{numeric}.} # MRIaggr-plotTableLesion.Rd

#### 29- character2numeric #### 
Line 17 :   \item{character2numeric}{should the default values be converted from character to numeric. \emph{logical}.} # MRIaggr-selectDefault_value.Rd

#### 30- check.args #### 
Line 19 : \item{check.args}{Should the validity of the arguments be checked ? \emph{logical}.} # sfMM-calcMultiPotential.Rd

#### 31- ci #### 
Line 16 :   \item{ci}{should the confidence interval be computed ? \emph{logical}.}   # Miscellaneous-calcAUPRC.Rd

#### 32- clinic #### 
Line 12 :   \item{clinic}{the clinical data of the patient. \emph{data.frame}.}   # MRIaggr-class.Rd
Line 17 :   \item{clinic}{should detailed information be printed for the clinical attribute ? \emph{logical}.} # MRIaggr-summary.MRIaggr.Rd

#### 33- col #### 
Line 20 :   \item{col}{the color to use to plot each criterion. \emph{character vector}.} # GRalgo-plotSigmaGR.Rd
Line 23 :   \item{col}{the colors of the boxplots for observations inside and outside the mask(s). \emph{character vector of size 2}.} # MRIaggr-boxplotMask.Rd
Line 26 :   \item{col}{the colors with which the correlations will be displayed. \emph{character vector}.} # MRIaggr-heatmapMRIaggr.Rd
Line 16 :   \item{col}{the color with which the observations will be displayed. \emph{character vector}.} # MRIaggr-initCol.Rd
Line 32 :   \item{col}{the color with which the observations will be displayed. \emph{character vector} or \code{NULL} leading to determine the colors using the \code{palette} and \code{breaks} arguments.} # MRIaggr-multiplot.Rd
Line 15 :   \item{col}{the colors in which the user-defined edge points, the interpolated edge points and the interior points should be ploted. \emph{character vector of size 3}.} # MRIaggr-outline.Rd
Line 29 :   \item{col}{the color to use to plot the observations. \emph{character vector} or \code{NULL} leading to automatic generation of the colors using the \code{breaks} and \code{palette} arguments.} # MRIaggr-outlineMRIaggr.Rd
Line 26 :    \item{col}{the colors with which the distributions will be displayed. \emph{character vector}.} # MRIaggr-plotDistClass.Rd
Line 28 :   \item{col}{the color of the core of the lesion. \emph{character}.} # MRIaggr-plotLesion3D.Rd
Line 16 :   \item{col}{the colors with which the observations will be displayed. \emph{character vector}.} # MRIaggr-plotMRI.Rd
Line 21 :   \item{col}{the colors with which the volumes will be displayed. \emph{character vector} or \emph{numeric vector}.} # MRIaggr-plotTableLesion.Rd
Line 13 :   \item{col}{the color with which the mid-sagittal plan will be plotted. \emph{character}.} # MRIaggr-pointsHemisphere.Rd

#### 34- col.default #### 
Line 21 :   \item{col.default}{the default color used to plot the observations. \emph{character vector}.} # MRIaggr-initIndex.Rd

#### 35- col.edge #### 
Line 29 :   \item{col.edge}{the color of the edge of the lesion. \emph{character}.} # MRIaggr-plotLesion3D.Rd

#### 36- col.NA #### 
Line 24 :   \item{col.NA}{the color to use to plot the NAs. \emph{character}.} # MRIaggr-plotMRI.Rd

#### 37- col.outline #### 
Line 38 :   \item{col.outline}{the colors in which the user-defined edge points, the interpolated edge points and the interior points should be ploted. \emph{character vector}[3].} # MRIaggr-outlineMRIaggr.Rd

#### 38- compression.factor #### 
Line 14 :   \item{compression.factor}{the compression factor. \emph{postive integer}. REQUIRED.} # MRIaggr-constCompressMRIaggr.Rd

#### 39- contrast #### 
Line 12 :   \item{contrast}{the contrast and the spatial coordinates of each voxel. \emph{data.frame} with four columns named \code{"i"} \code{"j"} \code{"k"} and the name of the contrast parameter.}   # Carto3D-class.Rd
Line 13 :   \item{contrast}{the contrast value of each observations. \emph{numeric vector}. REQUIRED.} # GRalgo-calcCriteriaGR.Rd
Line 14 :   \item{contrast}{the contrast value of each observation. \emph{numeric vector}. REQUIRED.} # GRalgo-calcGR.Rd
Line 13 :   \item{contrast}{the contrast value of each observation. \emph{numeric vector}. REQUIRED.} # GRalgo-calcSigmaGR.Rd
Line 12 :   \item{contrast}{the contrast value of each observation. \emph{numeric vector}.} # GRalgo-GRalgo.Rd
Line 13 :   \item{contrast}{the contrast value of each observation. \emph{numeric vector}.} # GRalgo-initGR.Rd
Line 12 :   \item{contrast}{the contrast value of each voxel on a given slice. \emph{matrix}.} # MRIaggr-calcContro_cpp.Rd
Line 22 :   \item{contrast}{the dataset containing the contrast parameter to be thresholded. \emph{matrix}. REQUIRED.} # MRIaggr-calcThresholdMRIaggr.Rd
Line 11 :   \item{contrast}{the value of the contrast parameters for each observation. \emph{data.frame}.}   # MRIaggr-class.Rd
Line 11 :   \item{contrast}{the dataset containing the observations in rows and the contrast parameters in columns. \emph{vector} or \emph{data.frame}. REQUIRED.} # MRIaggr-df2array.Rd
Line 12 :   \item{contrast}{the contrast value of each observation. \emph{matrix}.} # MRIaggr-initCol.Rd
Line 27 :   \item{contrast}{the intensities to display. \emph{numerical vector} or \code{NULL} leading to use the same color for all observations.} # MRIaggr-multiplot.Rd
Line 12 :   \item{contrast}{the intensities to display. \emph{numeric vector}.} # MRIaggr-plotMRI.Rd

#### 40- coords #### 
Line 13 :   \item{coords}{the spatial coordinates of the observations contained in \code{array}. \emph{matrix} or \code{NULL}.} # MRIaggr-array2df.Rd
Line 12 :   \item{coords}{the spatial coordinates of the observations. \emph{data.frame}. REQUIRED.} # MRIaggr-calcGroupsCoords.Rd
Line 12 :   \item{coords}{the spatial coordinates of the observations. \emph{matrix} with a number of rows equal to the number of rows of \code{data}. REQUIRED.} # MRIaggr-df2array.Rd
Line 13 :   \item{coords}{the spatial coordinates of the observations. \emph{data.frame}.} # MRIaggr-initCol.Rd
Line 13 :   \item{coords}{the spatial coordinates of the observations. \emph{data.frame}.} # MRIaggr-plotMRI.Rd
Line 11 :   \item{coords}{the spatial coordinates of the observations. \emph{data.frame}.} # MRIaggr-plotOutline.Rd
Line 23 :   \item{coords}{the coordinates that sould be extracted. \emph{logical} or any of \code{"i"} \code{"j"} \code{"k"}.} # MRIaggr-selectContrast.Rd
Line 18 :   \item{coords}{the coordinates that sould be extracted. Any of \code{"i"} \code{"j"} \code{"k"} or \code{"index"}.} # MRIaggr-selectCoords.Rd
Line 16 : \item{coords}{The voxel coordinates. \emph{matrix}. REQUIRED.} # sfMM-calcMultiPotential.Rd
Line 17 : \item{coords}{The voxel coordinates. \emph{matrix}.} # sfMM-calcMultiPotential_cpp.Rd
Line 21 : \item{coords}{The voxel coordinates. \emph{matrix}.} # sfMM-calcPotts.Rd
Line 18 : \item{coords}{the voxel coordinates. \emph{matrix}.} # sfMM-calcPotts_cpp.Rd
Line 13 :   \item{coords}{if argument \code{W_SR} is not specified, the coordinates of the sites used to compute the local neighbourhood matrix. \emph{data.frame}.} # sfMM-calcPottsParameter.Rd
Line 11 :   \item{coords}{the spatial coordinates of the observations. \emph{matrix} with a number of rows equal to the length of \code{sample}.} # sfMM-calcRadius_cpp.Rd
Line 23 :   \item{coords}{coordinates of each site. \emph{matrix}.} # sfMM-rhoMF.Rd
Line 15 :   \item{coords}{the voxels coordinates. \emph{matrix}.} # sfMM-simulPotts_cpp.Rd

#### 41- coords_max #### 
Line 17 :   \item{coords_max}{the maximum coordinate in each dimension. \emph{numerical vector}} # MRIaggr-calcGroupsCoords_cpp.Rd

#### 42- coords_NNA #### 
Line 12 :   \item{coords_NNA}{the spatial coordinates of the observations in C version (beginning at 0). \emph{matrix}.} # MRIaggr-calcGroupsCoords_cpp.Rd

#### 43- coords_px #### 
Line 13 :   \item{coords_px}{the coordinates of the observations. \emph{matrix}.} # MRIaggr-calcContro_cpp.Rd

#### 44- coordsI #### 
Line 13 :   \item{coordsI}{the coordinates of each voxel along the first coordinate. \emph{integer vector}.} # MRIaggr-calcHemi_cpp.Rd

#### 45- coordsJ #### 
Line 14 :   \item{coordsJ}{the coordinates of each voxel along the second coordinate. \emph{integer vector}.} # MRIaggr-calcHemi_cpp.Rd

#### 46- cpus #### 
Line 30 :   \item{cpus}{the number of CPU to use. \emph{integer}.} # sfMM-rhoLvfree.Rd

#### 47- criterion #### 
Line 21 :   \item{criterion}{the criterion to be displayed. \emph{character vector}.} # GRalgo-plotSigmaGR.Rd

#### 48- criterion.entropy #### 
Line 22 :   \item{criterion.entropy}{should the region criterion based on the entropy be computed ? \emph{logical}.}   # GRalgo-calcCriteriaGR.Rd
Line 20 :   \item{criterion.entropy}{should the region criterion based on the entropy be computed ? \emph{logical}.}   # GRalgo-calcSigmaGR.Rd

#### 49- criterion.Kalinsky #### 
Line 23 :   \item{criterion.Kalinsky}{should the region criterion based on the Kalinsky index be computed ? \emph{logical}.}   # GRalgo-calcCriteriaGR.Rd
Line 21 :   \item{criterion.Kalinsky}{should the region criterion based on the Kalinsky index be computed ? \emph{logical}.}   # GRalgo-calcSigmaGR.Rd

#### 50- criterion.Laboure #### 
Line 24 :   \item{criterion.Laboure}{should the region criterion based on the Laboure index  be computed ? \emph{logical}.} # GRalgo-calcCriteriaGR.Rd
Line 22 :   \item{criterion.Laboure}{should the region criterion based on the Laboure index  be computed ? \emph{logical}.} # GRalgo-calcSigmaGR.Rd

#### 51- criterion.sdfront #### 
Line 21 :   \item{criterion.sdfront}{should the boundary criterion based on the standard deviation be computed ? \emph{logical}.}   # GRalgo-calcCriteriaGR.Rd
Line 19 :   \item{criterion.sdfront}{should the boundary criterion based on the standard deviation be computed ? \emph{logical}.}   # GRalgo-calcSigmaGR.Rd

#### 52- criterion.transition #### 
Line 20 :   \item{criterion.transition}{should the boundary criterion based on the transition levels be computed ? \emph{logical}. }   # GRalgo-calcCriteriaGR.Rd
Line 18 :   \item{criterion.transition}{should the boundary criterion based on the transition levels be computed ? \emph{logical}. }   # GRalgo-calcSigmaGR.Rd

#### 53- cv.criterion #### 
Line 27 : \item{cv.criterion}{Convergence criterion of the ICM . \emph{numeric}.} # sfMM-calcPotts.Rd
Line 18 : \item{cv.criterion}{maximum difference in group probability membership for convergence ? \emph{double} between 0 and 1.} # sfMM-simulPotts.Rd

#### 54- cv_criterion #### 
Line 21 : \item{cv_criterion}{the convergence criterion. \emph{numeric}.} # sfMM-calcPotts_cpp.Rd
Line 20 :   \item{cv_criterion}{if the maximum absolute difference of the probabilistic membership between two iterations is below \code{critere} then the Gibbs sampler is stopped. \emph{numeric}.} # sfMM-simulPotts_cpp.Rd

#### 55- d_lim #### 
Line 16 :   \item{d_lim}{the distance within which the contralateral values are considered. \emph{numeric}.} # MRIaggr-calcContro_cpp.Rd

#### 56- data #### 
Line 12 :   \item{data}{the data to export. \emph{three dimensional array}. REQUIRED.} # MRIaggr-writeMRI.Rd

#### 57- date #### 
Line 35 :   \item{date}{the date on the latex document. \emph{character}.} # Miscellaneous-constLatex.Rd

#### 58- decreasing #### 
Line 27 :   \item{decreasing}{should the increasing thresholding (\code{FALSE}) or decreasing thresholding (\code{TRUE}) be used. \emph{logical}.} # MRIaggr-calcThresholdMRIaggr.Rd

#### 59- default_value #### 
Line 15 :   \item{default_value}{the reference values of the contrast parameters (e.g. the background value). \emph{character}.}    # Carto3D-class.Rd
Line 15 :   \item{default_value}{the reference values of the contrast parameters (e.g. the background value). \emph{character} or \code{NULL} leading to search the reference value in \code{array[pos_default_value]}.} # Carto3D-constCarto3D.Rd
Line 16 :   \item{default_value}{the reference values of the contrast parameters (e.g background values). A one row \emph{data.frame} where the column length must match the length of the \code{param} argument.} # MRIaggr-allocContrast.Rd
Line 15 :   \item{default_value}{a reference value for each contrast parameter. \emph{data.frame}.}   # MRIaggr-class.Rd
Line 16 :   \item{default_value}{the reference values of the contrast parameters (e.g. the background value). \emph{character} or \code{NULL} leading to search the reference value in \code{array[pos_default_value]}.} # MRIaggr-constMRIaggr.Rd
Line 14 :   \item{default_value}{the element used to fill the missing observations. \emph{numeric}.} # MRIaggr-df2array.Rd
Line 20 : 	\item{default_value}{the element used to fill the missing observations. \emph{numeric}.} # MRIaggr-writeMRIaggr.Rd

#### 60- descStats #### 
Line 18 :   \item{descStats}{should detailed information be printed for the \code{ls_descStats} attribute ? \emph{logical}.} # MRIaggr-summary.MRIaggr.Rd

#### 61- diagonal #### 
Line 19 :   \item{diagonal}{should the diagonal be added to the neighbourhood matrix ? \emph{logical}.} # MRIaggr-calcRegionaContrast.Rd

#### 62- digit #### 
Line 18 :   \item{digit}{the number of digits used to round the data. \emph{positive integer}. \code{NULL} indicates no rounding.} # MRIaggr-calcROCthreshold.Rd
Line 20 :   \item{digit}{the number of decimal places to use for the initialization. \emph{positive integer}.} # MRIaggr-calcTissueType.Rd
Line 23 :   \item{digit}{the number of decimal places to use for the legend label. \emph{positive integer}.} # MRIaggr-legendMRI.Rd

#### 63- dimensions #### 
Line 18 :   \item{dimensions}{the number of bytes per element in the byte stream. The default, NA_integer_, uses the natural size. Size changing is not supported for raw and complex vectors. Only active if \code{format} equals \code{rawb.gz}.} # MRIaggr-readMRI.Rd

#### 64- directory #### 
Line 15 :   \item{directory}{the path to the root directory. This directory should contains subsdirectories themself containing the image files. \emph{character}.} # Miscellaneous-constLatex.Rd
Line 19 :   \item{directory}{the path to the root directory. This directory should contains subsdirectories themself containing the image files. \emph{character}.} # Miscellaneous-initConstLatex.Rd

#### 65- directory.plot #### 
Line 20 :   \item{directory.plot}{the paths to the subdirectory(ies) containing the image files. \emph{character} or \emph{character vector}.} # Miscellaneous-initConstLatex.Rd

#### 66- dist.center #### 
Line 14 :   \item{dist.center}{the distance between each point and a reference point. \emph{numeric vector}.}   # MRIaggr-calcBlockW.Rd

#### 67- dist.max #### 
Line 15 :   \item{dist.max}{the neighbourhood range. \emph{numeric vector}.}  # MRIaggr-calcBlockW.Rd

#### 68- dist_center #### 
Line 14 :   \item{dist_center}{the distance between each point and a reference point. \emph{numeric vector}.}   # MRIaggr-calcBlockW_cpp.Rd

#### 69- dist_max #### 
Line 15 :   \item{dist_max}{the neighbourhood range. \emph{numeric vector}.}   # MRIaggr-calcBlockW_cpp.Rd

#### 70- distance.ref #### 
Line 14 : \item{distance.ref}{The intervals of distance defining the several neighborhood orders in \code{W_LR}. \emph{numeric vector}. REQUIRED.} # sfMM-calcMultiPotential.Rd
Line 22 : \item{distance.ref}{The intervals of distance defining the several neighborhood orders in \code{W_LR}. \emph{numeric vector}.} # sfMM-calcPotts.Rd
Line 20 :   \item{distance.ref}{the interval of distance defining the several neighbourhood orders in \code{W_LR}. \emph{numeric vector}.} # sfMM-rhoMF.Rd

#### 71- distance_ref #### 
Line 18 : \item{distance_ref}{The intervals of distance defining the several neighborhood orders in \code{W_LR}. \emph{numeric vector}.} # sfMM-calcMultiPotential_cpp.Rd
Line 24 : \item{distance_ref}{the distance defining the several neighborhood orders relatively to \code{W_LR}. \emph{numeric vector}.} # sfMM-calcPotts_cpp.Rd
Line 18 :   \item{distance_ref}{the distance defining the several neighbourhood orders relatively to \code{Wdist_LR}. \emph{numeric vector}.} # sfMM-simulPotts_cpp.Rd

#### 72- distband #### 
Line 19 :   \item{distband}{the distance within which the contralateral values are considered. \emph{postive numeric}.} # MRIaggr-calcControlateral.Rd

#### 73- dprior #### 
Line 21 :   \item{dprior}{the prior distribution. \emph{function}. Must be a density function between 0 and \code{rho_max}.} # sfMM-rhoLvfree.Rd

#### 74- edge #### 
Line 17 :   \item{edge}{should the edges of the lesion be ploted instead of the core ? \emph{logical}.} # MRIaggr-plotLesion3D.Rd

#### 75- epsilon #### 
Line 22 :   \item{epsilon}{the tolerance parameter regulating the acceptance of the parameter. \emph{double}.} # sfMM-rhoLvfree.Rd

#### 76- erosion.th #### 
Line 28 :   \item{erosion.th}{the threshold below which the observations will be removed by the erosion. \emph{numeric between 0 and 1}.} # MRIaggr-calcSmoothMask.Rd

#### 77- export.coda #### 
Line 31 :   \item{export.coda}{should the results be convert to the mcmc format of the coda package ? \emph{logical}.} # sfMM-rhoLvfree.Rd

#### 78- extra_text #### 
Line 21 :   \item{extra_text}{additionnal text to display. \emph{list of character vector} or \code{NULL} if there is no extra text to display.} # Miscellaneous-constLatex.Rd

#### 79- fast #### 
Line 19 : \item{fast}{should \code{simulPottsFast_cpp} be used ? \emph{logical}. Faster but diseable tracing and convergence checking.} # sfMM-simulPotts.Rd

#### 80- field #### 
Line 11 :   \item{field}{a named list containing the value(s) to be allocated. \emph{list}} # options-allocOptionsMRIaggr.Rd
Line 11 :   \item{field}{the field to be extracted. \emph{character}} # options-selectOptionsMRIaggr.Rd

#### 81- fieldDim #### 
Line 13 :   \item{fieldDim}{the dimension of the lattice containing the observations expressed in number of voxels. \emph{data.frame}.}   # Carto3D-class.Rd
Line 13 :   \item{fieldDim}{the dimensions of the spatial field (expressed in number of voxels) containing the voxels. \emph{data.frame}.}   # MRIaggr-class.Rd

#### 82- filename #### 
Line 23 :   \item{filename}{the name of the file used to export the plot. \emph{character}.} # GRalgo-plotSigmaGR.Rd
Line 16 :   \item{filename}{the name of the latex file that should be generated. \emph{character} or \emph{NULL}.} # Miscellaneous-constLatex.Rd
Line 30 :   \item{filename}{the name of the file used to export the plot. \emph{character}.} # MRIaggr-boxplotMask.Rd
Line 32 :   \item{filename}{the name of the file used to export the plot. \emph{character}.} # MRIaggr-calcBrainMask.Rd
Line 38 :   \item{filename}{the name of the file used to export the plot. \emph{character}.} # MRIaggr-calcHemisphere.Rd
Line 19 :   \item{filename}{the name of the file used to export the plot. \emph{character}.} # MRIaggr-calcROCthreshold.Rd
Line 33 :   \item{filename}{the name of the file used to export the plot. \emph{character}.} # MRIaggr-heatmapMRIaggr.Rd
Line 13 :   \item{filename}{the name of the file used to export the plot. \emph{character}.} # MRIaggr-initDisplayWindow.Rd
Line 13 :   \item{filename}{the name of the file used to export the plot. \emph{character}.} # MRIaggr-initWindow.Rd
Line 37 :   \item{filename}{the name of the file used to export the plot. \emph{character}.} # MRIaggr-multiplot.Rd
Line 36 :   \item{filename}{the name of the file used to export the plot. \emph{character}.} # MRIaggr-plotDistClass.Rd
Line 32 :   \item{filename}{the name of the file used to export the plot. \emph{character}.} # MRIaggr-plotTableLesion.Rd
Line 13 :   \item{filename}{the file name of the image file. \emph{character}. REQUIRED.} # MRIaggr-readMRI.Rd
Line 13 :   \item{filename}{the name of the image file. \emph{character}. REQUIRED.} # MRIaggr-writeMRI.Rd
Line 22 : 	\item{filename}{the name of the image file. \emph{character}. REQUIRED.} # MRIaggr-writeMRIaggr.Rd

#### 83- fill #### 
Line 32 :   \item{fill}{should the spatial region be filled ? Otherwise only the edge is used. \emph{logical}.} # MRIaggr-outlineMRIaggr.Rd

#### 84- filter #### 
Line 19 :   \item{filter}{the filter to use. Can be a \emph{matrix} or an \emph{array}, or a name indicating which filter should be used. REQUIRED.} # MRIaggr-calcFilter.Rd
Line 11 :   \item{filter}{the filter to be initialized. \emph{character}. REQUIRED.} # MRIaggr-initFilter.Rd
Line 13 :   \item{filter}{the type of filter, see \code{\link{calcFilter}} for more details. \emph{character}.} # MRIaggr-plotOutline.Rd

#### 85- filter.default #### 
Line 22 :   \item{filter.default}{the default filter used to define the neighbourhood. \emph{character}.}  # MRIaggr-initIndex.Rd

#### 86- flipud #### 
Line 21 :   \item{flipud}{is a logical variable for vertical flipping of the image (default is TRUE). Only active if \code{format} equals \code{dicom}.} # MRIaggr-readMRI.Rd

#### 87- format #### 
Line 28 :   \item{format}{the format of the output. Could be \code{"spam"} or \code{"dgCMatrix"}.} # MRIaggr-calcW.Rd
Line 13 :   \item{format}{the format of the output. Can be \code{"any"},\code{"matrix"},\code{"data.frame"} or \code{"list"}.} # MRIaggr-df2array.Rd
Line 17 :   \item{format}{the format of the output. Any of \code{"vector"}, \code{"matrix"} and \code{"data.frame"}.}   # MRIaggr-initMask.Rd
Line 14 :   \item{format}{the format of the image file. Can be \code{"raw.gz"}, \code{"analyze"},  \code{"nifti"} or \code{"dicom"}. REQUIRED.}  # MRIaggr-readMRI.Rd
Line 21 :   \item{format}{the format of the output. Can be \code{"matrix"}, \code{"data.frame"} or \code{"vector"}.} # MRIaggr-selectContrast.Rd
Line 24 :   \item{format}{the format of the output. Can be \code{"vector"}, \code{"matrix"} or \code{"data.frame"}.} # MRIaggr-selectCoords.Rd
Line 14 :   \item{format}{the format of the image file. Can be \code{"raw.gz"}, \code{"analyze"},  \code{"nifti"} or \code{"dicom"}. REQUIRED.}  # MRIaggr-writeMRI.Rd
Line 23 : 	\item{format}{the format of the image file. Can be \code{"raw.gz"}, \code{"analyze"},  \code{"nifti"} or \code{"dicom"}. REQUIRED.}  # MRIaggr-writeMRIaggr.Rd

#### 88- from,to #### 
Line 23 :   \item{from,to}{the left and right-most points of the grid at which the density is to be estimated. \emph{numeric} or \code{NULL} leading to automatic adjustment. See \code{\link{density}} for more details.} # MRIaggr-plotDistClass.Rd

#### 89- G #### 
Line 13 : \item{G}{the number of groups. \emph{postive integer}. REQUIRED.} # sfMM-simulPotts.Rd

#### 90- GRalgo #### 
Line 29 :   \item{GRalgo}{should a Growing Region algorithm be used to clean the thresholded parameter ? \emph{logical}.} # MRIaggr-calcThresholdMRIaggr.Rd

#### 91- gridSearch #### 
Line 27 :   \item{gridSearch}{Should grid search be used to find the mid-sagittal plane ? \emph{logical}.} # MRIaggr-calcHemisphere.Rd

#### 92- groups #### 
Line 14 :   \item{groups}{the indicator of group membership. \emph{logical vector}. REQUIRED.} # GRalgo-calcCriteriaGR.Rd

#### 93- gzipped #### 
Line 16 :   \item{gzipped}{is a character string that enables exportation of compressed (.gz) files.} # MRIaggr-writeMRI.Rd
Line 25 : 	\item{gzipped}{is a character string that enables exportation of compressed (.gz) files.} # MRIaggr-writeMRIaggr.Rd

#### 94- height #### 
Line 16 :   \item{height}{the height of the device used to export the plot. \emph{postive numeric}.} # MRIaggr-initDisplayWindow.Rd
Line 16 :   \item{height}{the height of the device used to export the plot. \emph{postive numeric}.} # MRIaggr-initWindow.Rd

#### 95- hemisphere #### 
Line 16 :   \item{hemisphere}{the hemisphere to use. \emph{character}.} # MRIaggr-calcDistTissues.Rd
Line 24 :   \item{hemisphere}{the hemisphere to use. \emph{character}.} # MRIaggr-calcRegionaContrast.Rd
Line 24 :   \item{hemisphere}{the hemisphere to consider. \emph{character} or \code{NULL}.} # MRIaggr-calcThresholdMRIaggr.Rd
Line 25 :   \item{hemisphere}{the hemisphere to use. \emph{character}.} # MRIaggr-calcW.Rd
Line 15 :   \item{hemisphere}{the hemisphere to display. \emph{character}.} # MRIaggr-initIndex.Rd
Line 22 :   \item{hemisphere}{the hemisphere to consider. \emph{character}.} # MRIaggr-outlineMRIaggr.Rd
Line 24 :   \item{hemisphere}{the hemisphere to extract. \emph{character}. See the details section.} # MRIaggr-selectContrast.Rd
Line 21 :   \item{hemisphere}{the hemisphere to extract. \emph{character}.} # MRIaggr-selectCoords.Rd
Line 13 :   \item{hemisphere}{the hemisphere of interest. \emph{character}. See the details section.} # MRIaggr-selectHemispheres.Rd
Line 17 :   \item{hemisphere}{the hemisphere to consider. \emph{character}.} # MRIaggr-selectN.Rd
Line 18 :   \item{hemisphere}{the hemisphere to extract. \emph{character}.} # MRIaggr-selectNormalization.Rd
Line 16 :   \item{hemisphere}{the hemisphere to use. \emph{character}.} # MRIaggr-selectW.Rd

#### 96- hemispheres #### 
Line 19 :   \item{hemispheres}{the presence or absence of lesion(s) in each hemisphere. \emph{data.frame}.}   # MRIaggr-class.Rd

#### 97- history #### 
Line 17 :   \item{history}{a list of the \code{calc} or \code{const} methods that have been applied to the \code{MRIaggr} object . \emph{data.frame}.}   # MRIaggr-class.Rd
Line 19 :   \item{history}{should the\code{calc} and \code{const} methods that have been applied to the object be listed ? \emph{logical}.} # MRIaggr-summary.MRIaggr.Rd

#### 98- history.front #### 
Line 31 :   \item{history.front}{should the propagation front of the GR set be recorded ? \emph{logical}.} # GRalgo-calcGR.Rd
Line 27 :   \item{history.front}{should the propagation front of the GR set be recorded ? \emph{logical}.} # GRalgo-GRalgo.Rd
Line 28 :   \item{history.front}{should the propagation front of the GR set be recorded ? \emph{logical}.} # GRalgo-initGR.Rd

#### 99- history.sigma #### 
Line 29 :   \item{history.sigma}{should the values of sigma be recorded ? \emph{logical}.} # GRalgo-calcGR.Rd
Line 25 :   \item{history.sigma}{should the values of sigma be recorded ? \emph{logical}.} # GRalgo-GRalgo.Rd
Line 26 :   \item{history.sigma}{should the values of sigma be recorded ? \emph{logical}.} # GRalgo-initGR.Rd

#### 100- history.step #### 
Line 30 :   \item{history.step}{should the number of observations included in the growing region set be recorded ? \emph{logical}.} # GRalgo-calcGR.Rd
Line 26 :   \item{history.step}{should the number of observations included in the GR set be recorded ? \emph{logical}.} # GRalgo-GRalgo.Rd
Line 27 :   \item{history.step}{should the number of observations included in the growing region set be recorded ? \emph{logical}.} # GRalgo-initGR.Rd

#### 101- i_pos #### 
Line 19 :   \item{i_pos}{the first coordinate of the center of the mid-sagittal plane. \emph{numeric}.} # MRIaggr-calcHemi_cpp.Rd

#### 102- i_test #### 
Line 28 :   \item{i_test}{the abscissa or the number of abscissa to test. \emph{numeric vector} or \emph{positive integer}.} # MRIaggr-calcHemisphere.Rd

#### 103- identifier #### 
Line 10 :   \item{identifier}{the patient identifier. \emph{character}.}   # Carto3D-class.Rd
Line 13 :   \item{identifier}{the identifier of the patient from which the data originated. \emph{character}. REQUIRED.} # Carto3D-constCarto3D.Rd
Line 18 :   \item{identifier}{the identifiers of the patients for which the graphics should be displayed. \emph{character vector} or \code{NULL} leading to use all patients.} # Miscellaneous-constLatex.Rd
Line 22 :   \item{identifier}{the identifiers of the patients for which the graphics should be displayed. \emph{character vector} or \code{NULL} leading to use all patients.} # Miscellaneous-initConstLatex.Rd
Line 10 :   \item{identifier}{the patient identifier. \emph{character}.}   # MRIaggr-class.Rd
Line 14 :   \item{identifier}{the identifier of the patient to which belong the contrast parameters. \emph{character}. REQUIRED.} # MRIaggr-constMRIaggr.Rd

#### 104- index #### 
Line 13 :   \item{index}{the coordinates of additionnal points to display. \emph{data.frame} or \emph{list}.} # MRIaggr-initIndex.Rd

#### 105- index_data #### 
Line 13 :   \item{index_data}{index of the non NA data.} # MRIaggr-filtrage2D_cpp.Rd
Line 13 :   \item{index_data}{index of the non NA data.} # MRIaggr-filtrage2Dmed_cpp.Rd
Line 16 :   \item{index_data}{index of the non NA data.} # MRIaggr-filtrage3D_cpp.Rd
Line 15 :   \item{index_data}{index of the non NA data.} # MRIaggr-filtrage3Dmed_cpp.Rd

#### 106- index_k #### 
Line 14 :   \item{index_k}{the index of the observations on the hemisphere of interest. \emph{integer vector}.} # MRIaggr-calcContro_cpp.Rd

#### 107- index_k_contro #### 
Line 15 :   \item{index_k_contro}{the index of the observations on the contralateral hemisphere. \emph{integer vector}.} # MRIaggr-calcContro_cpp.Rd

#### 108- index_NNA #### 
Line 13 :   \item{index_NNA}{the index of the coordinates in a array in C version (beginning at 0). \emph{numerical vector}.} # MRIaggr-calcGroupsCoords_cpp.Rd

#### 109- index1 #### 
Line 20 :   \item{index1}{the coordinates of additionnal points to display. \emph{data.frame} or \emph{list} or \code{NULL}.} # MRIaggr-outlineMRIaggr.Rd

#### 110- index1,index2,index3 #### 
Line 29 :   \item{index1,index2,index3}{the coordinates of additionnal points to display. \emph{data.frame} or \emph{list} or \code{NULL}.} # MRIaggr-multiplot.Rd

#### 111- indexNum #### 
Line 17 :   \item{indexNum}{the number associated to the index (for display). \emph{numeric}.} # MRIaggr-initIndex.Rd

#### 112- init #### 
Line 16 :   \item{init}{should the mask be initialized ? \emph{logical}. See the details section.} # MRIaggr-initMask.Rd
Line 18 :   \item{init}{should the slice numbers be initialized if \code{num} equals \code{NULL} ? \emph{logical}.  } # MRIaggr-initNum.Rd
Line 17 :   \item{init}{should the parameters be initialized if \code{param} equals \code{NULL} ? \emph{logical}.} # MRIaggr-initParameter.Rd

#### 113- initialization #### 
Line 15 : \item{initialization}{the probability membership of each voxel to each group used for initialisation. \emph{matrix}.} # sfMM-simulPotts.Rd

#### 114- iter_max #### 
Line 23 :   \item{iter_max}{the maximum number of iterations for the expansion of the growing region. \code{postive integer}.}   # GRalgo-calcGR.Rd
Line 20 :   \item{iter_max}{the maximum number of iterations for the expansion of the growing region. \code{postive integer}.}   # GRalgo-GRalgo.Rd
Line 21 :   \item{iter_max}{the maximum number of iterations for the expansion of the growing region. \code{postive integer}.}   # GRalgo-initGR.Rd
Line 26 : \item{iter_max}{Maximum number of ICM iterations. \emph{integer}.} # sfMM-calcPotts.Rd
Line 20 : \item{iter_max}{the maximum number of iterations. \emph{integer}.} # sfMM-calcPotts_cpp.Rd
Line 25 :   \item{iter_max}{the number of Gibbs move for each simulation. \emph{integer}.} # sfMM-rhoLvfree.Rd
Line 17 : \item{iter_max}{the number of iterations. \emph{numeric}.} # sfMM-simulPotts.Rd
Line 19 :   \item{iter_max}{the maximum number of iteration of the Gibbs sampler. \emph{integer}.} # sfMM-simulPotts_cpp.Rd

#### 115- iter_nb #### 
Line 19 :   \item{iter_nb}{The maximum number of iteration of the Gibbs sampler. \emph{integer}.} # sfMM-simulPottsFast_cpp.Rd

#### 116- j_pos #### 
Line 20 :   \item{j_pos}{the second coordinate of the center of the mid-sagittal plane. \emph{numeric}.} # MRIaggr-calcHemi_cpp.Rd

#### 117- keep.index #### 
Line 15 :   \item{keep.index}{should the previous \code{index} parameter be saved in the \code{ls_descStats} slot ? \emph{logical}.} # MRIaggr-constReduceMRIaggr.Rd

#### 118- keep.lower #### 
Line 25 :   \item{keep.lower}{should removing observations with high intensity of the region be forbidden ? \emph{logical}.}   # GRalgo-calcGR.Rd
Line 22 :   \item{keep.lower}{should removing observations with high intensity of the region be forbidden ? \emph{logical}.}   # GRalgo-GRalgo.Rd
Line 23 :   \item{keep.lower}{should removing observations with high intensity of the region be forbidden ? \emph{logical}.}   # GRalgo-initGR.Rd

#### 119- keep.upper #### 
Line 26 :   \item{keep.upper}{should removing observations with low intensity of the region be forbidden ? \emph{logical}.}   # GRalgo-calcGR.Rd
Line 23 :   \item{keep.upper}{should removing observations with low intensity of the region be forbidden ? \emph{logical}.}   # GRalgo-GRalgo.Rd
Line 24 :   \item{keep.upper}{should removing observations with low intensity of the region be forbidden ? \emph{logical}.}   # GRalgo-initGR.Rd

#### 120- kernel #### 
Line 22 :   \item{kernel}{the smoothing kernel to use. \emph{character}. See \code{\link{density}} for more details.} # MRIaggr-plotDistClass.Rd

#### 121- kmeans.n_groups #### 
Line 27 :   \item{kmeans.n_groups}{the number of groups to use in the kmeans algorithm. \emph{postive integer vector}.} # MRIaggr-calcBrainMask.Rd

#### 122- kmeans.Neighborhood #### 
Line 28 :   \item{kmeans.Neighborhood}{the range of the neighbourhood. \emph{postive integer}.} # MRIaggr-calcBrainMask.Rd

#### 123- label #### 
Line 24 :   \item{label}{the legend that will be displayed under each figure of a given parameter. \emph{character vector} or \code{NULL} leading to use \code{param} for the legend.} # Miscellaneous-constLatex.Rd
Line 26 :   \item{label}{the legend that will be displayed under each figure of a given parameter. \emph{character vector} or \code{NULL} leading to use \code{param} for the legend.} # Miscellaneous-initConstLatex.Rd

#### 124- lambda #### 
Line 17 :   \item{lambda}{the importance of the penalization by the distance. \emph{numeric}.} # MRIaggr-calcContro_cpp.Rd
Line 20 :   \item{lambda}{the importance of the penalization. \emph{numeric}.} # MRIaggr-calcControlateral.Rd

#### 125- las #### 
Line 30 :   \item{las}{the style of the axis labels. Any of \code{0}, \code{1}, \code{2} or \code{3}.} # MRIaggr-heatmapMRIaggr.Rd

#### 126- last_vs_others #### 
Line 30 : \item{last_vs_others}{should the regional potential be computed for each class or only for the last versus the others ? \emph{logical}.} # sfMM-calcPotts_cpp.Rd

#### 127- legend #### 
Line 19 :   \item{legend}{how should the legend be displayed ? \emph{logical}, \code{NULL} or \code{"only"}.} # MRIaggr-initCol.Rd
Line 27 :   \item{legend}{how should the legend be displayed ? \emph{logical} or \code{NULL}.} # MRIaggr-outlineMRIaggr.Rd

#### 128- log #### 
Line 18 : \item{log}{if TRUE, probabilities p are given as log(p). \emph{logical}. Default is \code{FALSE}.} # Miscellaneous-dtnorm.Rd

#### 129- long_name #### 
Line 19 :   \item{long_name}{the complete name for the error message. \emph{character}.} # MRIaggr-initMask.Rd
Line 22 :   \item{long_name}{the complete name for the error message. \emph{character}.} # MRIaggr-initParameter.Rd

#### 130- lower #### 
Line 16 : \item{lower}{truncation point. \emph{numeric}. Default is \code{-Inf}.} # Miscellaneous-dtnorm.Rd

#### 131- ls.array #### 
Line 13 :   \item{ls.array}{the value of the contrast parameter(s) for each observation. \code{list of array}. REQUIRED.} # MRIaggr-constMRIaggr.Rd

#### 132- ls.Carto3D #### 
Line 12 :   \item{ls.Carto3D}{a list of \code{\linkS4class{Carto3D}} objects. REQUIRED.} # MRIaggr-Carto3D2MRIaggr.Rd

#### 133- ls_indexK #### 
Line 15 :   \item{ls_indexK}{the index of the voxels on each slice. \emph{list}.} # MRIaggr-calcHemi_cpp.Rd

#### 134- ls_statDesc #### 
Line 27 :   \item{ls_statDesc}{a slot to store additional data. \emph{list}.}   # MRIaggr-class.Rd

#### 135- lty #### 
Line 22 :   \item{lty}{the line type used to represent the volume. \emph{numeric vector}.} # MRIaggr-plotTableLesion.Rd
Line 15 :   \item{lty}{the type of line used to represent the mid-sagittal plan. \emph{numeric vector}.} # MRIaggr-pointsHemisphere.Rd

#### 136- lwd #### 
Line 31 :   \item{lwd}{the line width. \emph{postive numeric}.} # MRIaggr-plotDistClass.Rd
Line 23 :   \item{lwd}{the line width. \emph{postive numeric}.} # MRIaggr-plotTableLesion.Rd
Line 14 :   \item{lwd}{the line width. \emph{postive numeric}.} # MRIaggr-pointsHemisphere.Rd

#### 137- M_data #### 
Line 11 :   \item{M_data}{matrix to which the filter will be applied.} # MRIaggr-filtrage2D_cpp.Rd
Line 11 :   \item{M_data}{matrix to which the filter will be applied.} # MRIaggr-filtrage2Dmed_cpp.Rd

#### 138- M_operateur #### 
Line 12 :   \item{M_operateur}{the filter to be applied.} # MRIaggr-filtrage2D_cpp.Rd
Line 12 :   \item{M_operateur}{the filter to be applied.} # MRIaggr-filtrage2Dmed_cpp.Rd

#### 139- main #### 
Line 19 :   \item{main}{an overall title for the plot. \emph{character}.} # GRalgo-plotSigmaGR.Rd
Line 24 :   \item{main}{an overall title for the plot. \emph{character}.} # MRIaggr-boxplotMask.Rd
Line 27 :   \item{main}{an overall title for the plot. \emph{character}.} # MRIaggr-heatmapMRIaggr.Rd
Line 21 :   \item{main}{an overall title for the legend. \emph{character}.} # MRIaggr-legendMRI.Rd
Line 27 :   \item{main}{an overall title for the plot. \emph{character}.} # MRIaggr-plotDistClass.Rd
Line 28 :   \item{main}{an overall title for the plot. \emph{character}.} # MRIaggr-plotMRI.Rd
Line 24 :   \item{main}{an overall title for the plot. \emph{character}.} # MRIaggr-plotTableLesion.Rd

#### 140- mar #### 
Line 17 :   \item{mar}{the number of margin lines to be specified on the four sides of the plot. \emph{positive numeric vector of size 4}.} # GRalgo-plotSigmaGR.Rd
Line 29 :   \item{mar}{the number of margin lines to be specified on the four sides of the plot. \emph{positive numeric vector of size 4}.} # MRIaggr-heatmapMRIaggr.Rd
Line 23 :   \item{mar}{the number of margin lines to be specified on the four sides of the plot. \emph{positive numeric vector of size 4}.} # MRIaggr-initDisplayWindow.Rd
Line 18 :   \item{mar}{the number of margin lines to be specified on the four sides of the legend. \emph{positive numeric vector of size 4}.} # MRIaggr-legendMRI.Rd
Line 26 :   \item{mar}{the number of margin lines to be specified on the four sides of the plot. \emph{positive numeric vector of size 4}.} # MRIaggr-plotTableLesion.Rd

#### 141- mask #### 
Line 18 :   \item{mask}{the binary contrast parameter(s) defining the spatial group(s). \emph{character vector}. REQUIRED.} # MRIaggr-boxplotMask.Rd
Line 15 :   \item{mask}{the binary contrast parameter(s) defining the spatial groups from which the distance will be computed. \emph{character vector}. REQUIRED.} # MRIaggr-calcDistMask.Rd
Line 15 :   \item{mask}{the binary contrast parameter that should be used to identifying the spatial groups. \emph{character}. REQUIRED.} # MRIaggr-calcGroupsMask.Rd
Line 24 :   \item{mask}{the binary contrast parameter(s) indicating the lesion. \emph{character vector} or \code{NULL} if no mask is available.} # MRIaggr-calcHemisphere.Rd
Line 16 :   \item{mask}{the binary contrast parameter that will be used as the outcome in the ROC analysis. \emph{character vector}. REQUIRED.} # MRIaggr-calcROCthreshold.Rd
Line 18 :   \item{mask}{the binary contrast parameter that should be smoothed. \emph{character}.} # MRIaggr-calcSmoothMask.Rd
Line 21 :   \item{mask}{the binary contrast parameter indentifing the lesion at timepoint[1]. \emph{character} or \code{NULL} if no mask is available.} # MRIaggr-calcTableHypoReperf.Rd
Line 15 :   \item{mask}{the binary contrast parameter indicating the brain. \emph{character} or \code{NULL} if no mask is available.} # MRIaggr-calcTableLesion.Rd
Line 16 :   \item{mask}{the binary contrast parameter(s). \emph{character vector}.} # MRIaggr-constCompressMRIaggr.Rd
Line 13 :   \item{mask}{the binary contrast parameter or a vector indicating the observations to be kept. \emph{character} or \emph{logical vector} with length equal to the number of observations in \code{object}. REQUIRED.} # MRIaggr-constReduceMRIaggr.Rd
Line 14 :   \item{mask}{the binary contrast parameters to check or initialize. \emph{character vector}.} # MRIaggr-initMask.Rd
Line 16 :   \item{mask}{the binary contrast parameter indicating the lesion. \emph{character}. REQUIRED.} # MRIaggr-plotLesion3D.Rd
Line 17 :   \item{mask}{the binary contrast parameter indicating the lesion. \emph{character}. REQUIRED.} # MRIaggr-plotTableLesion.Rd
Line 17 :   \item{mask}{should the mask be considered as an available contrast parameter ? \emph{logical}.} # MRIaggr-selectParameter.Rd

#### 142- maskN #### 
Line 14 :   \item{maskN}{the binary contrast parameter indicating the lesion. \emph{character}. REQUIRED.} # MRIaggr-calcTableLesion.Rd

#### 143- max #### 
Line 56 :   \item{max}{the maximum value for the argument. \emph{numeric} or \emph{NULL}.} # Miscellaneous-valid.Rd

#### 144- max_groups #### 
Line 15 :   \item{max_groups}{the maximum number of groups. \emph{postive integer}.} # MRIaggr-calcGroupsCoords.Rd
Line 18 :   \item{max_groups}{the maximum number of groups. \emph{postive integer}.} # MRIaggr-calcGroupsCoords_cpp.Rd
Line 14 :   \item{max_groups}{the maximum number of groups. \emph{postive integer}.} # MRIaggr-calcGroupsW.Rd
Line 14 :   \item{max_groups}{the maximum number of groups. \emph{postive integer}.} # MRIaggr-calcGroupsW_cpp.Rd

#### 145- max_index_NNA #### 
Line 15 :   \item{max_index_NNA}{the maximum number of index_NNA. \emph{postive integer}.} # MRIaggr-calcGroupsCoords_cpp.Rd

#### 146- maxit #### 
Line 34 :   \item{maxit}{The maximum number of iterations. \emph{postive integer}. See the details section of \code{optim}.} # MRIaggr-calcHemisphere.Rd

#### 147- mean #### 
Line 14 : \item{mean}{mean   vector of means. \emph{numeric}. Default is \code{0}.} # Miscellaneous-dtnorm.Rd

#### 148- method #### 
Line 32 :   \item{method}{the name of the function that called the initializer. \emph{character}.} # GRalgo-initGR.Rd
Line 18 :   \item{method}{the integration method used to compute the area under the curve. Any of \code{"integrate"}, \code{"Kronrod"}, \code{"Richardson"} \code{"Clenshaw"}, \code{"Simpson"} or \code{"Romberg"}.}   # Miscellaneous-calcAUPRC.Rd
Line 58 :   \item{method}{the name of the function that called the valid function. \emph{character}.} # Miscellaneous-valid.Rd
Line 22 :   \item{method}{the distance measure to be used. \emph{character}. This must be one of \code{"euclidean"}, \code{"maximum"}, \code{"minkowski"} or \code{"greatcircle"}.}   # MRIaggr-calcW.Rd
Line 21 :   \item{method}{the correlation coefficient which is to be computed. Can be \code{"pearson"}, \code{"kendall"} or \code{"spearman"}.} # MRIaggr-heatmapMRIaggr.Rd
Line 21 :   \item{method}{the name of the function that called the initializer. \emph{character}.} # MRIaggr-initCol.Rd
Line 12 :   \item{method}{the name of the function that called the initializer. \emph{character}.} # MRIaggr-initFilter.Rd
Line 23 :   \item{method}{the name of the function that called the initializer. \emph{character}.} # MRIaggr-initIndex.Rd
Line 20 :   \item{method}{the name of the function that called the initializer. \emph{character}.} # MRIaggr-initMask.Rd
Line 12 :   \item{method}{the name of the function that called the initializer. \emph{character}.} # MRIaggr-initNeighborhood.Rd
Line 20 :   \item{method}{the name of the function that called the initializer. \emph{character}.} # MRIaggr-initNum.Rd
Line 23 :   \item{method}{the name of the function that called the initializer. \emph{character}.} # MRIaggr-initParameter.Rd
Line 23 :   \item{method}{the name of the function that called the initializer. \emph{character}.} # MRIaggr-initWindow.Rd
Line 15 :   \item{method}{the method used to estimate the regularization parameter. Can be either \code{"MF"} or \code{"Lvfree"}.} # sfMM-calcPottsParameter.Rd

#### 149- mfrow #### 
Line 20 :   \item{mfrow}{the division of the device in plot region. \emph{numeric vector of size 2}.} # MRIaggr-initDisplayWindow.Rd
Line 20 :   \item{mfrow}{the division of the device in plot region. \emph{numeric vector of size 2}.} # MRIaggr-initWindow.Rd

#### 150- mgp #### 
Line 18 :   \item{mgp}{the margin line for the axis title, axis labels and axis line. \emph{positive numeric vector of size 3}.} # GRalgo-plotSigmaGR.Rd
Line 25 :   \item{mgp}{the margin line for the axis title, axis labels and axis line. \emph{positive numeric vector of size 3}.} # MRIaggr-boxplotMask.Rd
Line 28 :   \item{mgp}{the margin line for the axis title, axis labels and axis line. \emph{positive numeric vector of size 3}.} # MRIaggr-heatmapMRIaggr.Rd
Line 24 :   \item{mgp}{the margin line for the axis title, axis labels and axis line. \emph{positive numeric vector of size 3}.} # MRIaggr-initDisplayWindow.Rd
Line 28 :   \item{mgp}{the margin line for the axis title, axis labels and axis line. \emph{positive numeric vector of size 3}.} # MRIaggr-plotDistClass.Rd
Line 25 :   \item{mgp}{the margin line for the axis title, axis labels and axis line. \emph{positive numeric vector of size 3}.} # MRIaggr-plotTableLesion.Rd

#### 151- midplane #### 
Line 20 :   \item{midplane}{the position of the mid-sagittal plane. \emph{data.frame}.}   # MRIaggr-class.Rd
Line 30 :   \item{midplane}{should the mid-sagittal plan be displayed ? \emph{logical}.} # MRIaggr-multiplot.Rd

#### 152- min #### 
Line 55 :   \item{min}{the minimum value for the argument. \emph{numeric} or \emph{NULL}.} # Miscellaneous-valid.Rd

#### 153- min_dist #### 
Line 14 :   \item{min_dist}{if the distance between the new point and the initial point is inferior to \code{min_dist}, then the definition of the region ends. \emph{numeric}. Only active if \code{sequential} is \code{TRUE}.} # MRIaggr-outline.Rd
Line 35 :   \item{min_dist}{if the distance between the new point and the initial point is inferior to \code{min_dist}, then the definition of the region ends. \emph{numeric}. Only active if \code{sequential} is \code{TRUE}.} # MRIaggr-outlineMRIaggr.Rd

#### 154- min_index_NNA #### 
Line 14 :   \item{min_index_NNA}{the minimum value of index_NNA. \emph{postive integer}.} # MRIaggr-calcGroupsCoords_cpp.Rd

#### 155- mu #### 
Line 15 :   \item{mu}{should the centering values for the normalization be returned. \emph{logical}.  Active only if \code{type} is \code{"slice"} or \code{"3slices"}.} # MRIaggr-selectNormalization.Rd

#### 156- mu_type #### 
Line 16 :   \item{mu_type}{the type of centering. Can be \code{"mean"} or \code{"median"}. } # MRIaggr-calcNormalization.Rd

#### 157- multiV #### 
Line 20 : \item{multiV}{Should the regional potential range be specific to each spatial group ? \emph{logical}.} # sfMM-calcMultiPotential_cpp.Rd
Line 24 : \item{multiV}{Should the regional potential range be specific to each spatial group ? \emph{logical}.} # sfMM-calcPotts.Rd
Line 28 : \item{multiV}{should the regional potential range be specific to each spatial group ? \emph{logical}.} # sfMM-calcPotts_cpp.Rd
Line 25 :   \item{multiV}{should the regional neighbourhood range be computed for each spatial group ? \emph{logical}.} # sfMM-rhoMF.Rd

#### 158- n #### 
Line 13 : \item{n}{number of observations. \emph{integer}.} # Miscellaneous-dtnorm.Rd
Line 18 :   \item{n}{the number of voxels. \emph{integer}.} # MRIaggr-calcHemi_cpp.Rd
Line 12 :   \item{n}{maximum number of points to define the outline. \emph{integer}.} # MRIaggr-outline.Rd
Line 33 :   \item{n}{maximum number of points to define the outline. \emph{integer}.} # MRIaggr-outlineMRIaggr.Rd
Line 17 :   \item{n}{The number of observations. \emph{integer}.} # sfMM-simulPottsFast_cpp.Rd

#### 159- n.args #### 
Line 12 :   \item{n.args}{the number of default value(s) to be allocated. \emph{positive integer}} # options-allocOptionsMRIaggr.Rd

#### 160- n.chain #### 
Line 28 :   \item{n.chain}{the number of chain to use. \emph{integer}.} # sfMM-rhoLvfree.Rd

#### 161- n.contrast #### 
Line 25 :   \item{n.contrast}{the number of contrast parameters. \emph{postive integer}.} # MRIaggr-initDisplayWindow.Rd

#### 162- n.plot #### 
Line 19 :   \item{n.plot}{the number of images to display. \emph{integer}.} # MRIaggr-initWindow.Rd

#### 163- n.points #### 
Line 31 :   \item{n.points}{the number of points that represent the mid-sagittal plan to computed. \code{positive integer}.} # MRIaggr-calcHemisphere.Rd

#### 164- n.sample #### 
Line 24 :   \item{n.sample}{the number of iterations of the Gibbs sampler. \emph{integer}.} # sfMM-rhoLvfree.Rd

#### 165- n_num #### 
Line 16 :   \item{n_num}{the number of slices. \emph{integer}.} # MRIaggr-calcHemi_cpp.Rd

#### 166- na.rm #### 
Line 16 :   \item{na.rm}{should observations with missing values be removed ? \emph{logical}.} # MRIaggr-array2df.Rd
Line 22 :   \item{na.rm}{should observations with missing values in their neighbourhood be set to NA ? Otherwise the ponderation is adjusted. \emph{logical}.} # MRIaggr-calcFilter.Rd
Line 27 :   \item{na.rm}{should observations with missing values be removed ? \emph{logical}.} # MRIaggr-selectContrast.Rd

#### 167- na.value #### 
Line 15 :   \item{na.value}{the value with which NA values are replaced. \emph{numeric} or NA.}     # MRIaggr-readMRI.Rd

#### 168- na_rm #### 
Line 15 :   \item{na_rm}{should the observations with missing values in their neighbourhood be removed ? Otherwise the ponderation is adjusted.}   # MRIaggr-filtrage2D_cpp.Rd
Line 14 :   \item{na_rm}{should the observations with missing values in their neighbourhood be removed ? Otherwise the ponderation is adjusted.}   # MRIaggr-filtrage2Dmed_cpp.Rd
Line 18 :   \item{na_rm}{should the observations with missing values in their neighbourhood be removed ? Otherwise the ponderation is adjusted.}   # MRIaggr-filtrage3D_cpp.Rd
Line 16 :   \item{na_rm}{should the observations with missing values in their neighbourhood be removed ? Otherwise the ponderation is adjusted.}   # MRIaggr-filtrage3Dmed_cpp.Rd

#### 169- name #### 
Line 15 :   \item{name}{the name of the element storing \code{value}. \emph{character}. REQUIRED.} # MRIaggr-allocDescStats.Rd
Line 13 :   \item{name}{the name of the element to select. \emph{character} or \code{NULL} leading to select all available elements.} # MRIaggr-selectDescStats.Rd

#### 170- name, name1, name2 #### 
Line 47 :   \item{name, name1, name2}{the name(s) of the argument(s). \emph{character}.} # Miscellaneous-valid.Rd

#### 171- name_criteria #### 
Line 22 :   \item{name_criteria}{the name to be used in the legend. \emph{character vector}.} # GRalgo-plotSigmaGR.Rd

#### 172- name_newparam #### 
Line 14 :   \item{name_newparam}{the name of the contrast parameter to which cooresponds \code{array}. \emph{character}.} # MRIaggr-array2df.Rd
Line 16 :   \item{name_newparam}{the name of the new distance parameters. \emph{character vector}.} # MRIaggr-calcDistMask.Rd
Line 23 :   \item{name_newparam}{the name of the new parameters. \emph{character vector}.} # MRIaggr-calcFilter.Rd
Line 27 :   \item{name_newparam}{the name of the new parameters. \emph{character vector}.} # MRIaggr-calcRegionaContrast.Rd
Line 36 :   \item{name_newparam}{the name of the new parameters. \emph{character}.} # MRIaggr-calcThresholdMRIaggr.Rd
Line 23 :   \item{name_newparam}{the name of the new paramaters containing the probabilistic segmentation. \emph{character vector of size 3}.}   # MRIaggr-calcTissueType.Rd
Line 43 :   \item{name_newparam}{the name of the new parameter. \emph{character}.} # MRIaggr-outlineMRIaggr.Rd

#### 173- names_coords #### 
Line 15 :   \item{names_coords}{the name of the coordinates. \emph{character vector}.} # MRIaggr-array2df.Rd

#### 174- names_dirs #### 
Line 21 :   \item{names_dirs}{the names of the subdirectory(ies). \emph{character} or \emph{character vector}.} # Miscellaneous-initConstLatex.Rd

#### 175- nbGroup_min #### 
Line 18 : \item{nbGroup_min}{The minimum group size of the spatial groups required for computing the potential. \emph{integer}. Default is \code{100}.} # sfMM-calcMultiPotential.Rd
Line 19 : \item{nbGroup_min}{The minimum group size of the spatial groups required for performing regional regularization. \emph{integer}.} # sfMM-calcMultiPotential_cpp.Rd
Line 20 : \item{nbGroup_min}{The minimum group size of the spatial groups required for performing regional regularization. \emph{integer}.} # sfMM-calcPotts.Rd
Line 27 : \item{nbGroup_min}{the minimum group size of the spatial groups required for performing regional regularization. \emph{integer}.} # sfMM-calcPotts_cpp.Rd
Line 22 :   \item{nbGroup_min}{the minimum group size of the spatial groups required for computing the regional potential. \emph{integer}.} # sfMM-rhoMF.Rd

#### 176- Neighborhood #### 
Line 19 :   \item{Neighborhood}{the type of neighbourhood. \emph{character}.} # MRIaggr-calcDistMask.Rd
Line 14 :   \item{Neighborhood}{the type of neighbourhood. \emph{character}.} # MRIaggr-calcGroupsCoords.Rd
Line 16 :   \item{Neighborhood}{the type of neighbourhood. \emph{character}.} # MRIaggr-calcGroupsCoords_cpp.Rd
Line 11 :   \item{Neighborhood}{the name of neighbourhood configuration. \cr Any of \code{"2D_N4"}, \code{"2D_N8"} \code{"3D_N6"} \code{"3D_N10"} \code{"3D_N18"} \code{"3D_N26"}. REQUIRED.} # MRIaggr-initNeighborhood.Rd
Line 18 :   \item{Neighborhood}{the type of neighbourhood used to defined the edges. \emph{character}.} # MRIaggr-plotLesion3D.Rd

#### 177- Neighborhood_2D #### 
Line 22 :   \item{Neighborhood_2D}{the type of 2D neighbourhood. \emph{character}.} # MRIaggr-calcSmoothMask.Rd

#### 178- Neighborhood_3D #### 
Line 26 :   \item{Neighborhood_3D}{the type of 3D neighbourhood. \emph{character}.} # MRIaggr-calcSmoothMask.Rd

#### 179- Neighborhood_V #### 
Line 32 :   \item{Neighborhood_V}{the type of neighbourhood to use for the spatial regularization. \emph{character}.} # MRIaggr-calcSmoothMask.Rd

#### 180- NelderMead #### 
Line 33 :   \item{NelderMead}{Should the center of the grid search be searched using Nelder-Mead algorithm or set to the center of the image ? \emph{logical}.} # MRIaggr-calcHemisphere.Rd

#### 181- neutre #### 
Line 21 : \item{neutre}{the value to which the regional potential is set when the group is too small to compute it. \emph{numeric}.} # sfMM-calcMultiPotential_cpp.Rd
Line 26 : \item{neutre}{the value to which the regional potential is set when the group is too small to compute it. \emph{numeric}.} # sfMM-calcPotts_cpp.Rd

#### 182- niter #### 
Line 16 :   \item{niter}{the number of iterations used by \code{mritc.bayes}. \emph{positive integer}.} # MRIaggr-calcTissueType.Rd

#### 183- nnei #### 
Line 17 :   \item{nnei}{the number of neighbors. \emph{positive integer}.} # MRIaggr-calcTissueType.Rd

#### 184- norm.filter #### 
Line 20 :   \item{norm.filter}{should the filtered correspond to a weighted mean over site ? (or a weighted sum). \emph{logical}.} # MRIaggr-calcFilter.Rd

#### 185- norm_mu #### 
Line 23 :   \item{norm_mu}{the type of centering to apply on the parameter values. \emph{character}.} # MRIaggr-calcTableHypoReperf.Rd
Line 25 :   \item{norm_mu}{the type of centering to apply on the parameter values. \emph{character}. See the details section.} # MRIaggr-selectContrast.Rd
Line 18 : 	\item{norm_mu}{the type of centering to apply on the parameter values. \emph{character}. See the details section.} # MRIaggr-writeMRIaggr.Rd

#### 186- norm_sigma #### 
Line 24 :   \item{norm_sigma}{the type of scaling to apply on the parameter values. \emph{character}.} # MRIaggr-calcTableHypoReperf.Rd
Line 26 :   \item{norm_sigma}{the type of scaling to apply on the parameter values. \emph{character}. See the details section.} # MRIaggr-selectContrast.Rd
Line 19 : 	\item{norm_sigma}{the type of scaling to apply on the parameter values. \emph{character}. See the details section.} # MRIaggr-writeMRIaggr.Rd

#### 187- normalization #### 
Line 18 :   \item{normalization}{the normalization values of each contrast parameter. \emph{list}.}   # MRIaggr-class.Rd

#### 188- num #### 
Line 19 :   \item{num}{the slices to consider. \emph{numeric vector} or \code{NULL}.} # MRIaggr-boxplotMask.Rd
Line 16 :   \item{num}{the slices to extract. \emph{numeric vector} or \code{NULL}.} # MRIaggr-calcControlateral.Rd
Line 15 :   \item{num}{the slices to use. \emph{numeric vector} or \code{NULL}.} # MRIaggr-calcDistTissues.Rd
Line 20 :   \item{num}{the slices to use. \emph{numeric vector} or \code{NULL}.} # MRIaggr-calcHemisphere.Rd
Line 23 :   \item{num}{the slices to use. \emph{numeric vector} or \code{NULL}.} # MRIaggr-calcRegionaContrast.Rd
Line 24 :   \item{num}{the slices to use. \emph{numeric vector} or \code{NULL}.} # MRIaggr-calcW.Rd
Line 15 :   \item{num}{the slices to extract. \emph{numeric vector} or \code{NULL}.} # MRIaggr-Carto3D2MRIaggr.Rd
Line 18 :   \item{num}{the slices to use. \emph{numeric vector} or \code{NULL}.} # MRIaggr-heatmapMRIaggr.Rd
Line 14 :   \item{num}{the slices to display. \emph{numeric vector} or \code{NULL}.} # MRIaggr-initIndex.Rd
Line 16 :   \item{num}{the slice numbers to check or initialize. \emph{numeric vector} or \code{NULL}. See the details section.} # MRIaggr-initNum.Rd
Line 28 :   \item{num}{the slices to display. \emph{numeric vector} or \code{NULL}.} # MRIaggr-multiplot.Rd
Line 21 :   \item{num}{the slices on which the outline will be drawn. \emph{numeric vector} or \code{NULL}.} # MRIaggr-outlineMRIaggr.Rd
Line 19 :   \item{num}{the slices to use. \emph{numeric vector} or \code{NULL}.} # MRIaggr-plotDistClass.Rd
Line 18 :   \item{num}{the slices to display. \emph{numeric vector} or \code{NULL}.} # MRIaggr-plotTableLesion.Rd
Line 20 :   \item{num}{the slices to extract. \emph{numeric vector} or \code{NULL}.} # MRIaggr-selectContrast.Rd
Line 20 :   \item{num}{the slices to extract. \emph{numeric vector} or \code{NULL}.} # MRIaggr-selectCoords.Rd
Line 16 :   \item{num}{the slices to consider. \emph{numeric vector} or \code{NULL}.} # MRIaggr-selectN.Rd
Line 17 :   \item{num}{the slices to extract. \emph{numeric vector} or \code{NULL}.} # MRIaggr-selectNormalization.Rd
Line 17 :   \item{num}{the slices to use. \emph{numeric vector} or \code{NULL}.} # MRIaggr-selectW.Rd
Line 17 : 	\item{num}{the slices to extract. \emph{numeric vector} or \code{NULL}.} # MRIaggr-writeMRIaggr.Rd

#### 189- numeric2logical #### 
Line 18 :   \item{numeric2logical}{should \code{mask} be convert to logical ? \emph{logical}.} # MRIaggr-calcDistMask.Rd
Line 16 :   \item{numeric2logical}{should \code{mask} be convert to logical ? \emph{logical}.} # MRIaggr-calcGroupsMask.Rd
Line 25 :   \item{numeric2logical}{should \code{mask} be convert to logical ? \emph{logical}.} # MRIaggr-calcHemisphere.Rd
Line 19 :   \item{numeric2logical}{should \code{mask} be convert to logical ? \emph{logical}.} # MRIaggr-calcSmoothMask.Rd
Line 22 :   \item{numeric2logical}{should \code{mask} be converted to logical ? \emph{logical}.} # MRIaggr-calcTableHypoReperf.Rd
Line 16 :   \item{numeric2logical}{should \code{mask} and \code{maskN} values be converted to logical ? \emph{logical}.} # MRIaggr-calcTableLesion.Rd
Line 32 :   \item{numeric2logical}{should \code{seed} be converted to logical ? \emph{logical}.} # MRIaggr-calcThresholdMRIaggr.Rd
Line 14 :   \item{numeric2logical}{should \code{mask} be converted to logical ? \emph{logical}.} # MRIaggr-constReduceMRIaggr.Rd
Line 16 :   \item{numeric2logical}{if a parameter is specified for the index arguments, should it be converted to logical ? \emph{logical}.} # MRIaggr-initIndex.Rd
Line 23 :   \item{numeric2logical}{if a parameter is specified for the index argument, should it be converted to logical ? \emph{logical}.} # MRIaggr-outlineMRIaggr.Rd
Line 19 :   \item{numeric2logical}{should \code{mask} be convert to logical ? \emph{logical}.} # MRIaggr-plotLesion3D.Rd

#### 190- object #### 
Line 13 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-allocClinic.Rd
Line 13 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-allocContrast.Rd
Line 13 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-allocDescStats.Rd
Line 13 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-allocHemisphere.Rd
Line 13 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-allocNormalization.Rd
Line 14 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-allocTable.Rd
Line 13 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-allocW.Rd
Line 15 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-boxplotMask.Rd
Line 17 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcBrainMask.Rd
Line 14 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcControlateral.Rd
Line 14 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcDistMask.Rd
Line 12 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcDistTissues.Rd
Line 17 :   \item{object}{an \code{array} or an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcFilter.Rd
Line 14 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcGroupsMask.Rd
Line 18 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcHemisphere.Rd
Line 14 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcNormalization.Rd
Line 15 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcRegionaContrast.Rd
Line 14 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcROCthreshold.Rd
Line 17 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcSmoothMask.Rd
Line 15 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcTableHypoReperf.Rd
Line 13 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcTableLesion.Rd
Line 21 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcThresholdMRIaggr.Rd
Line 14 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcTissueType.Rd
Line 20 :   \item{object}{a \emph{data.frame} containing the coordinates of the observations or an \code{object} of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-calcW.Rd
Line 13 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-constCompressMRIaggr.Rd
Line 12 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-constReduceMRIaggr.Rd
Line 16 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-heatmapMRIaggr.Rd
Line 12 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}} or \code{NULL} .} # MRIaggr-initIndex.Rd
Line 13 :   \item{object}{an object of class \code{\linkS4class{Carto3D}} or \code{\linkS4class{MRIaggr}}.} # MRIaggr-initMask.Rd
Line 15 :   \item{object}{an object of class \code{\linkS4class{Carto3D}} or \code{\linkS4class{MRIaggr}}.} # MRIaggr-initNum.Rd
Line 14 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}.} # MRIaggr-initParameter.Rd
Line 25 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}, or a \code{\linkS4class{Carto3D}}, or a 2 or 3 column \code{data.frame} containing the coordinates of the observations in columns. REQUIRED.} # MRIaggr-multiplot.Rd
Line 18 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-outlineMRIaggr.Rd
Line 16 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-plotDistClass.Rd
Line 15 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-plotLesion3D.Rd
Line 16 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-plotTableLesion.Rd
Line 12 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}.} # MRIaggr-pointsHemisphere.Rd
Line 12 :   \item{object}{an \code{object} of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectClinic.Rd
Line 18 :   \item{object}{an \code{object} of class \code{\linkS4class{Carto3D}} or \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectContrast.Rd
Line 17 :   \item{object}{an \code{object} of class \code{\linkS4class{Carto3D}} or \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectCoords.Rd
Line 15 :   \item{object}{an \code{object} of class \code{\linkS4class{Carto3D}} or \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectDefault_value.Rd
Line 12 :   \item{object}{an \code{object} of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectDescStats.Rd
Line 12 :   \item{object}{an \code{object} of class \code{\linkS4class{Carto3D}} or \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectHemispheres.Rd
Line 12 :   \item{object}{an \code{object} of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectHistory.Rd
Line 15 :   \item{object}{an \code{object} of class \code{\linkS4class{Carto3D}} or \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectIdentifier.Rd
Line 12 :   \item{object}{an \code{object} of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectMidplane.Rd
Line 15 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectN.Rd
Line 13 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectNormalization.Rd
Line 15 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectParameter.Rd
Line 12 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectTable.Rd
Line 15 :   \item{object}{an \code{object} of class \code{\linkS4class{Carto3D}} or \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectVoxelDim.Rd
Line 12 :   \item{object}{an \code{object} of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectVoxelSize.Rd
Line 13 :   \item{object}{an \code{object} of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-selectW.Rd
Line 15 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-summary.MRIaggr.Rd
Line 13 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-supprContrast.Rd
Line 13 :   \item{object}{an object of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-supprDescStats.Rd
Line 15 : 	\item{object}{an \code{object} of class \code{\linkS4class{MRIaggr}}. REQUIRED.} # MRIaggr-writeMRIaggr.Rd

#### 191- operator #### 
Line 21 :   \item{operator}{should the median absolute deviation be used to estimte the variability of the group contrast (\code{"mad"}) or the standard deviation (\code{"sd"}).}   # GRalgo-GRalgo.Rd

#### 192- operator_index1 #### 
Line 36 :   \item{operator_index1}{the operator to apply between the index1 observations and the outlined observations. Can be \code{"none"} \code{"intersection"} \code{"difference"} or \code{"union"}.} # MRIaggr-outlineMRIaggr.Rd

#### 193- outline.default #### 
Line 18 :   \item{outline.default}{the default display for the spatial group (edge or entire group). \emph{logical}.} # MRIaggr-initIndex.Rd

#### 194- overwrite #### 
Line 16 :   \item{overwrite}{if clinical parameters with the same names are already stored in \code{object@clinic}, can they be overwritten ? \emph{logical}.}   # MRIaggr-allocClinic.Rd
Line 17 :   \item{overwrite}{if a contrast parameters with the same names are already stored in \code{object@data}, can they be overwritten ? \emph{logical}.}   # MRIaggr-allocContrast.Rd
Line 16 :   \item{overwrite}{if an element with the same name is already stored in \code{object@ls_descStats}, can it be overwritten ? \emph{logical}.}   # MRIaggr-allocDescStats.Rd
Line 15 :   \item{overwrite}{if the characteristics of a mid-saggital plan are already stored in \code{object}, can they be overwritten ? \emph{logical}.}   # MRIaggr-allocHemisphere.Rd
Line 15 :   \item{overwrite}{if normalization values are already stored in \code{object}, can they be overwritten ? \emph{logical}.}   # MRIaggr-allocNormalization.Rd
Line 17 :   \item{overwrite}{if tables are already stored in \code{object@normalization}, can they be overwritten ? \emph{logical}.}   # MRIaggr-allocTable.Rd
Line 16 :   \item{overwrite}{if an element with the same name is already stored in \code{object@ls_descStats}, can it be overwritten ? \emph{logical}.}   # MRIaggr-allocW.Rd
Line 35 :   \item{overwrite}{if a mask is already stored in \code{object@data}, can it be overwritten ? \emph{logical}.} # MRIaggr-calcBrainMask.Rd
Line 24 :   \item{overwrite}{if contrast parameters with the same names are already stored in \code{object@data}, can they be overwritten ? \emph{logical}.} # MRIaggr-calcControlateral.Rd
Line 23 :   \item{overwrite}{if contrast parameters with the same names are already stored in \code{object@data}, can they be overwritten ? \emph{logical}.} # MRIaggr-calcDistMask.Rd
Line 27 :   \item{overwrite}{if contrast parameters with the same names are already stored in \code{object@data}, can they be overwritten ? \emph{logical}.}   # MRIaggr-calcFilter.Rd
Line 24 :   \item{overwrite}{if spatial groups are already stored in \code{object@ls_descStats}, can they be overwritten ? \emph{logical}.}   # MRIaggr-calcGroupsMask.Rd
Line 40 :   \item{overwrite}{if a midplane is already stored in \code{object@midplane}, can it be overwritten ? \emph{logical}.}   # MRIaggr-calcHemisphere.Rd
Line 24 :   \item{overwrite}{if normalization values are already stored in \code{object@normalization}, can they be overwritten ? \emph{logical}.}   # MRIaggr-calcNormalization.Rd
Line 29 :   \item{overwrite}{if contrast parameters with the same names are already stored in \code{object} can they be overwritten ? \emph{logical}.}   # MRIaggr-calcRegionaContrast.Rd
Line 22 :   \item{overwrite}{if a threshold analysis is already stored in \code{object@ls_descStats}, can it be overwritten ? \emph{logical}.}   # MRIaggr-calcROCthreshold.Rd
Line 36 :   \item{overwrite}{if a mask is already stored in \code{object@data}, can it be overwritten ? \emph{logical}.}   # MRIaggr-calcSmoothMask.Rd
Line 29 :   \item{overwrite}{if reperfusion or hypoperfusion values are already stored in \code{object@table_reperfusion} or \code{object@table_hypofusion}, can they be overwritten ? \emph{logical}.}   # MRIaggr-calcTableHypoReperf.Rd
Line 20 :   \item{overwrite}{if a lesion table is already stored in \code{object@table_lesion}, can it be overwritten ? \emph{logical}.}   # MRIaggr-calcTableLesion.Rd
Line 39 :   \item{overwrite}{contrast parameters with the same names are already stored in \code{object@data}, can it be overwritten ? \emph{logical}.}   # MRIaggr-calcThresholdMRIaggr.Rd
Line 25 :   \item{overwrite}{if tissue types are already stored in \code{object@data}, can they be overwritten ? \emph{logical}.}   # MRIaggr-calcTissueType.Rd
Line 34 :   \item{overwrite}{if a neighbourhood matrix is already stored in \code{object@ls_descStats}, can it be overwritten ? \emph{logical}.} # MRIaggr-calcW.Rd
Line 45 :   \item{overwrite}{if a contrast parameter with the same names is already stored in \code{object@data}, can it be overwritten ? \emph{logical}.}   # MRIaggr-outlineMRIaggr.Rd

#### 195- p #### 
Line 24 :   \item{p}{the penalization factor. \emph{positive numeric}.} # MRIaggr-calcHemi_cpp.Rd
Line 21 :   \item{p}{the type of distance for the penalization. \emph{positive numeric}.} # MRIaggr-calcHemisphere.Rd
Line 18 :   \item{p}{The number of groups or colors. \emph{integer}.} # sfMM-simulPottsFast_cpp.Rd

#### 196- p_data #### 
Line 13 :   \item{p_data}{spatial dimensions of the data.} # MRIaggr-filtrage3D_cpp.Rd
Line 12 :   \item{p_data}{spatial dimensions of the data.} # MRIaggr-filtrage3Dmed_cpp.Rd

#### 197- p_operateur #### 
Line 15 :   \item{p_operateur}{spatial dimensions of the filter.} # MRIaggr-filtrage3D_cpp.Rd
Line 14 :   \item{p_operateur}{spatial dimensions of the filter.} # MRIaggr-filtrage3Dmed_cpp.Rd

#### 198- palette #### 
Line 17 :   \item{palette}{the colors or the palette to use when associating colors to intensities. \emph{character vector} or \emph{character}.} # MRIaggr-initCol.Rd
Line 15 :   \item{palette}{the colors or the palette to use when associating colors to observation intensities. \emph{character vector}.} # MRIaggr-legendMRI.Rd
Line 28 :   \item{palette}{the colors or the palette to use when associating colors to observation intensities. \emph{character vector} or \emph{character}.} # MRIaggr-outlineMRIaggr.Rd
Line 15 :   \item{palette}{the colors or the palette to use when associating colors to observation intensities. \emph{character vector}.} # MRIaggr-plotMRI.Rd

#### 199- param #### 
Line 14 :   \item{param}{the contrast parameter. \emph{character}. REQUIRED.} # Carto3D-constCarto3D.Rd
Line 19 :   \item{param}{the names of subdirectories containing the images. \emph{character vector} or \code{NULL} leading to use all subdirectories.} # Miscellaneous-constLatex.Rd
Line 23 :   \item{param}{the names of directories containing the images. \emph{character vector} or \code{NULL} leading to use all directories.} # Miscellaneous-initConstLatex.Rd
Line 15 :   \item{param}{the names of the contrast parameters. \emph{character vector} or \code{NULL} leading to use the name of the \code{value} argument.} # MRIaggr-allocContrast.Rd
Line 17 :   \item{param}{the contrast parameter(s) associated with the lesion mask(s). \emph{character vector}. REQUIRED.} # MRIaggr-boxplotMask.Rd
Line 18 :   \item{param}{the contrast parameter(s) that should be used to identify the brain observations. \emph{character vector}. REQUIRED.} # MRIaggr-calcBrainMask.Rd
Line 15 :   \item{param}{the contrast parameters to normalize. \emph{character vector}. REQUIRED.} # MRIaggr-calcControlateral.Rd
Line 13 :   \item{param}{the contrast parameters to consider. \emph{character vector}. REQUIRED.} # MRIaggr-calcDistTissues.Rd
Line 18 :   \item{param}{the contrast parameter to be filtered. \emph{character vector}. REQUIRED.} # MRIaggr-calcFilter.Rd
Line 19 :   \item{param}{the contrast parameter that should be used to distinguish the two hemispheres. \emph{character}. REQUIRED.} # MRIaggr-calcHemisphere.Rd
Line 15 :   \item{param}{the contrast parameters to normalize. \emph{character vector}. REQUIRED.} # MRIaggr-calcNormalization.Rd
Line 16 :   \item{param}{the contrast parameter(s) from which the regional parameter(s) will be computed. \emph{character vector}. REQUIRED.} # MRIaggr-calcRegionaContrast.Rd
Line 15 :   \item{param}{the contrast parameter(s) that should be used to identify the observations inside the mask. \emph{character vector}. REQUIRED.} # MRIaggr-calcROCthreshold.Rd
Line 16 :   \item{param}{the perfusion parameter(s). \emph{character vector}. REQUIRED.} # MRIaggr-calcTableHypoReperf.Rd
Line 23 :   \item{param}{the contrast parameters to be thresholded. \emph{character vector}. REQUIRED.} # MRIaggr-calcThresholdMRIaggr.Rd
Line 15 :   \item{param}{the contrast parameter that should be used to distinguish the WM, the GM and the CSF. \emph{character}. REQUIRED.} # MRIaggr-calcTissueType.Rd
Line 15 :   \item{param}{the contrast parameters to load in the new MRIaggr object. \emph{character vector} or \code{NULL}.} # MRIaggr-constCompressMRIaggr.Rd
Line 15 :   \item{param}{the contrast parameter(s). \emph{character vector} or \code{NULL}. REQUIRED.} # MRIaggr-constMRIaggr.Rd
Line 17 :   \item{param}{the contrast parameters used to compute the correlations. \emph{character vector}. REQUIRED.} # MRIaggr-heatmapMRIaggr.Rd
Line 14 :   \item{param}{the contrast parameter to display. \emph{character}.} # MRIaggr-initCol.Rd
Line 15 :   \item{param}{the contrast parameters to check or initialize. \emph{character vector} or \code{NULL}.} # MRIaggr-initParameter.Rd
Line 16 :   \item{param}{the name of the contrast parameters. \emph{character vector}.} # MRIaggr-legendMRI.Rd
Line 26 :   \item{param}{the contrast parameter to display. \emph{character}. REQUIRED.} # MRIaggr-multiplot.Rd
Line 19 :   \item{param}{the contrast parameter map on which the outline will be drawn. \emph{character}. REQUIRED.} # MRIaggr-outlineMRIaggr.Rd
Line 17 :   \item{param}{the contrast parameter to display. \emph{character}. REQUIRED.} # MRIaggr-plotDistClass.Rd
Line 13 :   \item{param}{the clinical parameters to extract. \emph{character vector} or \code{NULL} leading to extract all the clinical parameters.} # MRIaggr-selectClinic.Rd
Line 19 :   \item{param}{the contrast parameters to extract. \emph{character vector} or \code{NULL}.} # MRIaggr-selectContrast.Rd
Line 16 :   \item{param}{the contrast parameters for which the reference values should be returned. \emph{character vector} or \code{NULL} leading to extract reference values for all available contrast parameters.} # MRIaggr-selectDefault_value.Rd
Line 19 :   \item{param}{the contrast parameters for which the normalization values should be extracted. \emph{character vector} or \code{NULL} indicating all available contrast parameters.} # MRIaggr-selectNormalization.Rd
Line 16 :   \item{param}{should detailed information be printed for the contrast parameters ? \emph{logical}.} # MRIaggr-summary.MRIaggr.Rd
Line 16 : 	\item{param}{the contrast parameters to extract. \emph{character vector} or \code{NULL}. REQUIRED.} # MRIaggr-writeMRIaggr.Rd

#### 200- param.membership #### 
Line 14 :   \item{param.membership}{the parameters indicating the probabilistic membership of each observations to each cerebral structure. \emph{character vector}.}  # MRIaggr-calcDistTissues.Rd
Line 18 :   \item{param.membership}{the parameters indicating the probabilistic membership to the tissue classes. \emph{character vector}.} # MRIaggr-plotDistClass.Rd

#### 201- param.ref #### 
Line 18 :   \item{param.ref}{the parameter to use as a reference for the identification of the contralateral voxel. \emph{character} or \code{NULL} if no reference parameter available.} # MRIaggr-calcControlateral.Rd

#### 202- param.update #### 
Line 27 :   \item{param.update}{which type of parameter should be stored in the object ? Any of \code{"shift"} \code{"reperf"} \code{"reperf_pc"} \code{"deperf"} \code{"deperf_pc"}.} # MRIaggr-calcTableHypoReperf.Rd

#### 203- param_ref #### 
Line 18 :   \item{param_ref}{the parameter to be used as a reference to identify the contralateral voxel. \emph{character}.} # MRIaggr-calcContro_cpp.Rd

#### 204- parameter #### 
Line 11 :   \item{parameter}{the name of the contrast parameter. \emph{character}.}    # Carto3D-class.Rd

#### 205- path #### 
Line 14 :   \item{path}{the directory where the plot file will be created. \emph{character}.} # MRIaggr-initDisplayWindow.Rd
Line 14 :   \item{path}{the directory where the plot file will be created. \emph{character}.} # MRIaggr-initWindow.Rd

#### 206- pch #### 
Line 15 :   \item{pch}{the symbol with which the observations will be displayed. \emph{positive integer}.} # MRIaggr-initCol.Rd
Line 33 :   \item{pch}{the symbol with which the observations will be displayed. \emph{positive integer} or \code{NULL} leading to use the \code{image} function instead of \code{plot}.} # MRIaggr-multiplot.Rd
Line 16 :   \item{pch}{the symbol with which the observations will be displayed. \emph{positive integer}.} # MRIaggr-outline.Rd
Line 39 :   \item{pch}{the symbol with which the observations will be displayed. \emph{positive integer}.} # MRIaggr-outlineMRIaggr.Rd
Line 30 :   \item{pch}{the symbol with which the distribution will be displayed. \emph{positive integer}.} # MRIaggr-plotDistClass.Rd
Line 21 :   \item{pch}{the symbol with which the observations will be displayed. \emph{positive integer}.} # MRIaggr-plotMRI.Rd

#### 207- pch.default #### 
Line 20 :   \item{pch.default}{the default label used to plot the observations. \emph{numeric}.} # MRIaggr-initIndex.Rd

#### 208- pch.NA #### 
Line 25 :   \item{pch.NA}{the label to use to plot the NAs. \emph{postive integer}.} # MRIaggr-plotMRI.Rd

#### 209- penalty #### 
Line 23 :   \item{penalty}{the type of objective function. Can be \code{"symmetry"} or \code{"asymmetry"}.} # MRIaggr-calcHemisphere.Rd

#### 210- penaltyNA #### 
Line 22 :   \item{penaltyNA}{a penalty factor for the percent of voxel without controlateral correspondant. \emph{numeric}.} # MRIaggr-calcHemi_cpp.Rd

#### 211- performance #### 
Line 15 :   \item{performance}{an object of class \code{performance} can be supplied instead of arguments \code{x} and \code{y}.}   # Miscellaneous-calcAUPRC.Rd

#### 212- plot #### 
Line 25 :   \item{plot}{should the results be plotted ? \emph{logical}.} # MRIaggr-calcBrainMask.Rd
Line 37 :   \item{plot}{should the results be plotted ? \emph{logical}.} # MRIaggr-calcHemisphere.Rd
Line 17 :   \item{plot}{the type of the graphic to display? \emph{character} or \code{FALSE}. See the details section.} # MRIaggr-calcROCthreshold.Rd

#### 213- plotPerPage #### 
Line 29 :   \item{plotPerPage}{the number of image that should be displayed on the same page. \emph{strictly positive interger}.} # Miscellaneous-constLatex.Rd
Line 28 :   \item{plotPerPage}{the number of image that should be displayed on the same page. \emph{strictly positive interger}.} # Miscellaneous-initConstLatex.Rd

#### 214- points.values #### 
Line 22 :   \item{points.values}{should the correlation values be printed on the plot ? \emph{logical}.} # MRIaggr-heatmapMRIaggr.Rd

#### 215- pos_default_value #### 
Line 16 :   \item{pos_default_value}{the coordinates of the observation that contains the reference value. \emph{numeric vector} with length the number of dimension of array.} # Carto3D-constCarto3D.Rd
Line 17 :   \item{pos_default_value}{the coordinates of the observations that contains the reference value. \emph{numeric vector}.}    # MRIaggr-constMRIaggr.Rd

#### 216- power #### 
Line 13 :   \item{power}{the power of the kernel. \emph{numeric}.} # Miscellaneous-EDK.Rd
Line 18 :   \item{power}{the power of the kernel. \emph{postive numeric}.} # MRIaggr-calcRegionaContrast.Rd

#### 217- prior #### 
Line 16 : \item{prior}{Should the \code{sample} values be used as a prior ? \emph{logical}.} # sfMM-calcPotts.Rd
Line 32 : \item{prior}{should the \code{sample} values be used as a prior ? \emph{logical}.} # sfMM-calcPotts_cpp.Rd

#### 218- prior_prevalence #### 
Line 16 :   \item{prior_prevalence}{should a prior on class prevalence be including when estimating the regularisation parameters ? \emph{logical}.} # sfMM-rhoMF.Rd

#### 219- pty #### 
Line 22 :   \item{pty}{the type of plot region to be used. Can be \code{"s"} or \code{"m"}.} # MRIaggr-initDisplayWindow.Rd

#### 220- px_max #### 
Line 25 :   \item{px_max}{the maximum number of points that can be ploted. \emph{integer}.} # MRIaggr-plotLesion3D.Rd

#### 221- quantiles #### 
Line 22 :   \item{quantiles}{the quantiles values to display on the legend. \emph{numeric vector of size 5} or \code{NULL}.} # MRIaggr-legendMRI.Rd

#### 222- radius #### 
Line 26 :   \item{radius}{the radius of spheres. \emph{numeric}. See \code{plot3d} for more details.} # MRIaggr-plotLesion3D.Rd

#### 223- range #### 
Line 18 :   \item{range}{the range of acceptable contrast values for the growing region group. \emph{numeric vector of size 2}.} # GRalgo-calcGR.Rd
Line 16 :   \item{range}{the range of acceptable contrast values for the growing region group. \emph{numeric vector of size 2}.} # GRalgo-GRalgo.Rd
Line 17 :   \item{range}{the range of acceptable contrast values for the growing region group. \emph{numeric vector of size 2}.} # GRalgo-initGR.Rd
Line 21 :   \item{range}{only distances smaller than \code{range} are stored in \code{W}. \code{postive numeric}. REQUIRED.} # MRIaggr-calcW.Rd
Line 14 :   \item{range}{if argument \code{W_SR} is not specified, the range of the neighbourhood used to compute the local neighbourhood matrix. positive \emph{double}.} # sfMM-calcPottsParameter.Rd

#### 224- range.coords #### 
Line 15 :   \item{range.coords}{the maximum coordinate in each dimension to be considered. \emph{numeric vector} with length equal to the number of columns of \code{coords}.} # MRIaggr-df2array.Rd
Line 21 :     \item{range.coords}{the maximum coordinate in each dimension to be considered. \emph{numeric vector} of length 3.} # MRIaggr-writeMRIaggr.Rd

#### 225- range.seed #### 
Line 19 :   \item{range.seed}{the range of acceptable contrast values for the seeds. \emph{numeric vector of size 2}.} # GRalgo-calcGR.Rd
Line 18 :   \item{range.seed}{the range of acceptable contrast values for the seeds. \emph{numeric vector of size 2}.} # GRalgo-initGR.Rd

#### 226- refuse.duplicates #### 
Line 53 :   \item{refuse.duplicates}{Are duplicated values invalid values. \emph{logical}.} # Miscellaneous-valid.Rd

#### 227- refuse.NA #### 
Line 51 :   \item{refuse.NA}{Is \code{NA} an invalid value ? \emph{logical}.} # Miscellaneous-valid.Rd

#### 228- refuse.NULL #### 
Line 52 :   \item{refuse.NULL}{Is \code{NULL} an invalid value ? \emph{logical}.} # Miscellaneous-valid.Rd

#### 229- regional #### 
Line 21 :   \item{regional}{should the regional potential be computed ?. \emph{logical}.} # sfMM-simulPotts_cpp.Rd

#### 230- regionalGroups #### 
Line 24 :   \item{regionalGroups}{how should the regional potential be computed : last group versus the others (\code{"last_vs_others"}) or for each group (\code{"each"}).} # sfMM-rhoMF.Rd

#### 231- reinit.options #### 
Line 12 :   \item{reinit.options}{should the default values be reinitialized. \emph{logical}}  # options-optionsMRIaggr.Rd

#### 232- reltol #### 
Line 19 :   \item{reltol}{the relative accuracy requested. Positive \emph{numeric}.}   # Miscellaneous-calcAUPRC.Rd
Line 35 :   \item{reltol}{Relative convergence tolerance. \emph{positive numeric}. See the details section of \code{optim}.} # MRIaggr-calcHemisphere.Rd

#### 233- reorient #### 
Line 20 :   \item{reorient}{is a logical variable (default = TRUE) that enforces Qform/Sform transformations. Only active if \code{format} equals \code{nifti}.} # MRIaggr-readMRI.Rd

#### 234- res #### 
Line 18 :   \item{res}{the nominal resolution in ppi which will be recorded in the bitmap file. \emph{positive integer}.} # MRIaggr-initDisplayWindow.Rd
Line 18 :   \item{res}{the nominal resolution in ppi which will be recorded in the bitmap file. \emph{positive integer}.} # MRIaggr-initWindow.Rd

#### 235- rescale #### 
Line 22 :   \item{rescale}{should the contrast be scaled ? \emph{logical}.}   # GRalgo-calcGR.Rd
Line 30 :   \item{rescale}{should the contrast be scaled ? \emph{logical}.}   # GRalgo-initGR.Rd
Line 20 :   \item{rescale}{should the contrast parameters be scaled ? \emph{logical}.} # MRIaggr-boxplotMask.Rd
Line 19 :   \item{rescale}{should the contrast parameters be scaled ? \emph{logical}.} # MRIaggr-heatmapMRIaggr.Rd

#### 236- rho #### 
Line 15 : \item{rho}{Value of the spatial regularisation parameters. \emph{numeric vector}. REQUIRED.} # sfMM-calcPotts.Rd
Line 17 : \item{rho}{the value of the spatial regularisation parameters. \emph{numeric vector}.} # sfMM-calcPotts_cpp.Rd
Line 14 : \item{rho}{the value of the regularization parameter (also called potts parameter or inverse temperature). REQUIRED.} # sfMM-simulPotts.Rd
Line 17 :   \item{rho}{a \emph{numeric} corresponding to the Potts model parameter (i.e. intensity of the neighbourhood correlations).} # sfMM-simulPotts_cpp.Rd
Line 16 :   \item{rho}{A \emph{numeric} corresponding to the Potts model parameter (i.e. intensity of the neighbourhood correlations).} # sfMM-simulPottsFast_cpp.Rd

#### 237- rho_init #### 
Line 17 :   \item{rho_init}{the initial rho value. \emph{double}. If \code{NULL}, it is sample in a uniform law between 0 and \code{rho_max}} # sfMM-rhoLvfree.Rd

#### 238- rho_max #### 
Line 16 :   \item{rho_max}{maximum possible rho value, minimum is 0. \emph{double}.} # sfMM-rhoLvfree.Rd
Line 15 :   \item{rho_max}{Maximum possible rho value (\emph{numeric}), minimum is 0.} # sfMM-rhoMF.Rd

#### 239- rm.2Dhole #### 
Line 23 :   \item{rm.2Dhole}{should the 2D wholes inside the mask be removed ? \emph{logical}.} # MRIaggr-calcSmoothMask.Rd

#### 240- rm.3Dhole #### 
Line 27 :   \item{rm.3Dhole}{should the 3D wholes inside the mask be removed ? \emph{logical}.} # MRIaggr-calcSmoothMask.Rd

#### 241- rm.array #### 
Line 18 :   \item{rm.array}{should the object on which \emph{array} argument points be removed form the global environment ? \emph{logical}.} # Carto3D-constCarto3D.Rd

#### 242- rm.Carto3D #### 
Line 13 :   \item{rm.Carto3D}{should the object on which the \code{ls.Carto3D} argument points be removed form the global environment ? \emph{logical}.} # MRIaggr-Carto3D2MRIaggr.Rd

#### 243- rm.CSF #### 
Line 18 :   \item{rm.CSF}{should the cerebral spinal fluid observations be excluded ? \emph{logical}.} # MRIaggr-calcNormalization.Rd
Line 25 :   \item{rm.CSF}{should the cerebral spinal fluid observations be excluded ? \emph{logical} or \emph{character}.} # MRIaggr-calcThresholdMRIaggr.Rd

#### 244- rm.GM #### 
Line 19 :   \item{rm.GM}{should the grey matter observations be excluded ? \emph{logical}.} # MRIaggr-calcNormalization.Rd

#### 245- rm.ls.array #### 
Line 22 :   \item{rm.ls.array}{should the object on which the \code{ls.array} argument points be removed form the global environment ? \emph{logical}.} # MRIaggr-constMRIaggr.Rd

#### 246- rm.warning #### 
Line 18 :   \item{rm.warning}{should warning be displayed. \emph{logical}.} # GRalgo-calcCriteriaGR.Rd

#### 247- rm.WM #### 
Line 20 :   \item{rm.WM}{should the white matter observations be excluded ? \emph{logical}.} # MRIaggr-calcNormalization.Rd

#### 248- row.norm #### 
Line 29 :   \item{row.norm}{should the resulting matrix be row-normalized ? \code{TRUE/FALSE}.} # MRIaggr-calcW.Rd

#### 249- sample #### 
Line 15 : \item{sample}{The probability membership to the group. \emph{numeric vector} or \emph{character vector}. REQUIRED.} # sfMM-calcMultiPotential.Rd
Line 15 : \item{sample}{The group probability membership. \emph{numeric vector}.} # sfMM-calcMultiPotential_cpp.Rd
Line 14 : \item{sample}{The initial group probability membership. \emph{numeric vector}. REQUIRED.} # sfMM-calcPotts.Rd
Line 16 : \item{sample}{the initial group probability membership. \emph{numeric vector}.} # sfMM-calcPotts_cpp.Rd
Line 12 :   \item{sample}{the weight of each voxel in the computation of the barycenter. \emph{positive numeric}.} # sfMM-calcRadius_cpp.Rd
Line 14 :   \item{sample}{the initial observations (by rows) for the various groups (by columns). \emph{matrix}.}   # sfMM-simulPotts_cpp.Rd
Line 15 :   \item{sample}{A \emph{matrix} containing the initial observations (by rows) for the various groups (by columns).}   # sfMM-simulPottsFast_cpp.Rd

#### 250- scale #### 
Line 17 :   \item{scale}{the scaling factor to convert \code{height} and \code{height} to standard unit. \emph{numeric}.} # MRIaggr-initDisplayWindow.Rd

#### 251- sd #### 
Line 15 : \item{sd}{vector of standard deviations. \emph{numeric}. Default is \code{1}.} # Miscellaneous-dtnorm.Rd

#### 252- sd.robust #### 
Line 24 :   \item{sd.robust}{should the median absolute deviation be used to estimte the variability of the group contrast, or the standard deviation ? \emph{logical}.} # GRalgo-calcGR.Rd
Line 22 :   \item{sd.robust}{should the median absolute deviation be used to estimte the variability of the group contrast, or the standard deviation ? \emph{logical}.} # GRalgo-initGR.Rd

#### 253- sd_data #### 
Line 23 :   \item{sd_data}{the standard deviation of the parameter. \emph{numeric}.} # MRIaggr-calcHemi_cpp.Rd

#### 254- sd_rho_init #### 
Line 18 :   \item{sd_rho_init}{the standard deviation of the rho value for the proposal distribution. \emph{double}. It is updated at the end of the burn in.} # sfMM-rhoLvfree.Rd

#### 255- seed #### 
Line 16 :   \item{seed}{the index of the initial seeds or a binary indicator of the initial seeds. \emph{positive integer vector} or \emph{logical vector}. REQUIRED.} # GRalgo-calcGR.Rd
Line 15 :   \item{seed}{the index of the initial seeds or a binary indicator of the initial seeds. \emph{positive integer vector} or \emph{logical vector}. REQUIRED.} # GRalgo-calcSigmaGR.Rd
Line 14 :   \item{seed}{the index of the initial seeds or a binary indicator of the initial seeds. \emph{positive integer vector} or \emph{logical vector}.} # GRalgo-GRalgo.Rd
Line 15 :   \item{seed}{the index of the initial seeds or a binary indicator of the initial seeds. \emph{positive integer vector} or \emph{logical vector}.} # GRalgo-initGR.Rd
Line 31 :   \item{seed}{the index of the seeds for the growing region algorithm . \emph{positive integer vector}. } # MRIaggr-calcThresholdMRIaggr.Rd

#### 256- sep #### 
Line 19 :   \item{sep}{the separator between the parameter names and the time points. \emph{character}.} # MRIaggr-calcTableHypoReperf.Rd

#### 257- sequential #### 
Line 13 :   \item{sequential}{should the region edge be updated on the graphical device after each point ? \emph{logical}.} # MRIaggr-outline.Rd
Line 34 :   \item{sequential}{should the region edge be updated on the graphical device after each point ? \emph{logical}.} # MRIaggr-outlineMRIaggr.Rd

#### 258- sigma #### 
Line 16 :   \item{sigma}{the \code{sigma_max} that have been used in the GR algorithm. \emph{positive numeric vector}.} # GRalgo-calcCriteriaGR.Rd
Line 16 :   \item{sigma}{the sequence of maximum admissible values for the group variability \emph{positive numeric vector}. REQUIRED.} # GRalgo-calcSigmaGR.Rd
Line 16 :   \item{sigma}{should the scaling values for the normalization be returned. \emph{logical}.  Active only if \code{type} is \code{"slice"} or \code{"3slices"}.} # MRIaggr-selectNormalization.Rd

#### 259- sigma_max #### 
Line 17 :   \item{sigma_max}{the maximum admissible value for the variability of the group contrast. \emph{positive numeric}. REQUIRED.} # GRalgo-calcGR.Rd
Line 15 :   \item{sigma_max}{the maximum admissible value for the variability of the group contrast. \emph{positive numeric}.} # GRalgo-GRalgo.Rd
Line 16 :   \item{sigma_max}{the maximum admissible value for the variability of the group contrast. \emph{positive numeric}.} # GRalgo-initGR.Rd

#### 260- sigma_type #### 
Line 17 :   \item{sigma_type}{the type of scaling. Can be \code{"sd"} or \code{"mad"}.} # MRIaggr-calcNormalization.Rd

#### 261- site_order #### 
Line 13 :   \item{site_order}{a specific order to go all over the sites. \emph{integer vector}.}   # MRIaggr-calcBlockW.Rd
Line 13 :   \item{site_order}{a specific order to go all over the sites. \emph{integer vector}.}   # MRIaggr-calcBlockW_cpp.Rd
Line 17 : \item{site_order}{a specific order to go all over the sites. \emph{integer vector}.}   # sfMM-calcPotts.Rd
Line 19 : \item{site_order}{a specific order to go all over the sites. \emph{integer vector}.}   # sfMM-calcPotts_cpp.Rd
Line 19 :   \item{site_order}{a specific order to go all over the sites. Can be \code{NULL} or an \emph{integer vector}.}   # sfMM-rhoLvfree.Rd
Line 16 : \item{site_order}{a specific order to go all over the sites. Can be \code{NULL}, \code{TRUE} or an \emph{integer vector}.}   # sfMM-simulPotts.Rd
Line 16 :   \item{site_order}{a specific order to go all over the sites. An \emph{integer vector} or a negative number to indicate no specific order.}   # sfMM-simulPotts_cpp.Rd
Line 14 :   \item{site_order}{a specific order to go all over the sites. An \emph{integer vector} or a negative number to indicate no specific order.} # sfMM-simulPottsFast_cpp.Rd

#### 262- size #### 
Line 17 :   \item{size}{the number of bytes per element in the byte stream. \emph{integer}. See the documentation of the \code{writeBin} function for more details.} # MRIaggr-readMRI.Rd
Line 14 :   \item{size}{should the values in the table correspond to a number of voxels (\code{FALSE}) or a volume (\code{TRUE}).} # MRIaggr-selectTable.Rd
Line 15 :   \item{size}{the number of bytes per element in the byte stream. \emph{integer}. See the documentation of the \code{writeBin} function for more details.} # MRIaggr-writeMRI.Rd
Line 24 : 	\item{size}{the number of bytes per element in the byte stream. \emph{integer}. See the documentation of the \code{writeBin} function for more details.} # MRIaggr-writeMRIaggr.Rd

#### 263- size_2Dgroup #### 
Line 21 :   \item{size_2Dgroup}{the minimum size of the 2D groups. \emph{positive integer} or \code{"unique"}.} # MRIaggr-calcSmoothMask.Rd

#### 264- size_3Dgroup #### 
Line 25 :   \item{size_3Dgroup}{the minimum size of the 3D groups. \emph{positive integer} or \code{"unique"}.} # MRIaggr-calcSmoothMask.Rd

#### 265- skull.n_groups #### 
Line 30 :   \item{skull.n_groups}{the number of groups to use in the kmeans algorithm to obtain the skull.} # MRIaggr-calcBrainMask.Rd

#### 266- skull.param #### 
Line 29 :   \item{skull.param}{the parameter used to identify the skull. \emph{character}.} # MRIaggr-calcBrainMask.Rd

#### 267- slice_var #### 
Line 19 :   \item{slice_var}{the type of slice to extract. \code{"i"} for sagittal, \code{"j"} for coronal and \code{"k"} for transverse. \emph{character}.}   # MRIaggr-initNum.Rd
Line 22 :   \item{slice_var}{the type of slice to extract. \code{"i"} for sagittal, \code{"j"} for coronal and \code{"k"} for transverse. \emph{character}.}   # MRIaggr-selectContrast.Rd
Line 23 :   \item{slice_var}{the type of slice to extract. \code{"i"} for sagittal, \code{"j"} for coronal and \code{"k"} for transverse. \emph{character}.}   # MRIaggr-selectCoords.Rd
Line 18 :   \item{slice_var}{the type of slice to extract. \code{"i"} for sagittal, \code{"j"} for coronal and \code{"k"} for transverse. \emph{character}.}   # MRIaggr-selectW.Rd

#### 268- spatial_res #### 
Line 17 :   \item{spatial_res}{a dilatation factor for the coordinates. \emph{positive numeric vector of size 3}.} # MRIaggr-calcDistMask.Rd
Line 23 :   \item{spatial_res}{a dilatation factor for the coordinates. \emph{positive numeric vector of size 3}.} # MRIaggr-calcW.Rd
Line 20 :   \item{spatial_res}{a dilatation factor for the coordinates. \emph{positive numeric vector of size 3}.} # MRIaggr-plotLesion3D.Rd
Line 19 :   \item{spatial_res}{a dilatation factor for the coordinates. \emph{positive numeric vector of size 3}.} # MRIaggr-selectCoords.Rd

#### 269- SPM #### 
Line 19 :   \item{SPM}{is a logical variable (default = FALSE) that forces the voxel data values to be rescaled using the funused1 ANALYZE header field. This is an undocumented convention of ANALYZE files processed using the Statistical Parametric Mapping (SPM) software. Only active if \code{format} equals \code{analyse}.} # MRIaggr-readMRI.Rd

#### 270- step #### 
Line 19 :   \item{step}{the step between two consecutive breaks. \emph{numeric}.}   # GRalgo-GRalgo.Rd

#### 271- sub #### 
Line 19 :   \item{sub}{if \code{TRUE}, use the higher resolution model; otherwise, use the whole voxel method. \emph{logical}.} # MRIaggr-calcTissueType.Rd

#### 272- subdivisions #### 
Line 14 :   \item{subdivisions}{the maximum number of subintervals used for the integration. \emph{positive integer}. Only used if \code{method="integrate"}.} # Miscellaneous-calcAUPRC.Rd

#### 273- subsection #### 
Line 23 :   \item{subsection}{the names of subsections for the latex document. \emph{character vector} or \code{NULL} leading to use \code{param} for naming the subsections.} # Miscellaneous-constLatex.Rd
Line 25 :   \item{subsection}{the names of subsections for the latex document. \emph{character vector} or \code{NULL} leading to use \code{param} for naming the subsections.} # Miscellaneous-initConstLatex.Rd

#### 274- subset #### 
Line 13 :   \item{subset}{the subset of observations to use. \emph{positive integer vector} or \code{NULL} leading to use all observations.} # MRIaggr-calcGroupsW.Rd
Line 13 :   \item{subset}{the subset of observations to use. \emph{positive integer vector}.} # MRIaggr-calcGroupsW_cpp.Rd
Line 22 :   \item{subset}{the subset of observations to use. \emph{positive integer vector} or \code{NULL} leading to use all observations.} # MRIaggr-calcHemisphere.Rd
Line 26 :   \item{subset}{the subset of observations to use. \emph{positive integer vector} or \code{NULL} leading to use all observations.} # MRIaggr-calcW.Rd
Line 28 :   \item{subset}{the subset of observations to extract. \emph{positive integer vector} or \code{NULL} leading to use all observations} # MRIaggr-selectContrast.Rd
Line 22 :   \item{subset}{the subset of observations to extract. \emph{positive integer vector} or \code{NULL} leading to use all observations} # MRIaggr-selectCoords.Rd
Line 18 :   \item{subset}{the subset of observations to consider. \emph{positive integer vector} or \code{NULL} leading to consider all observations.} # MRIaggr-selectN.Rd

#### 275- subset_bary #### 
Line 14 :   \item{subset_bary}{an indicator of the observations that should be kept ? \emph{logical vector}.} # sfMM-calcRadius_cpp.Rd

#### 276- subset_W #### 
Line 15 :   \item{subset_W}{the subset of observations to select. \emph{integer vector} or \code{NULL} leading to select all the observations.} # MRIaggr-selectW.Rd

#### 277- superClasses #### 
Line 57 :   \item{superClasses}{Should the super-classes of the object's class be also considered or only the object's class ? \emph{logical}.} # Miscellaneous-valid.Rd

#### 278- symetrie #### 
Line 25 :   \item{symetrie}{the type of objective function. \code{TRUE} correspond to \code{"symmetry"} and \code{FALSE} to \code{"asymmetry"}.} # MRIaggr-calcHemi_cpp.Rd

#### 279- table_hypoperfusion #### 
Line 25 :   \item{table_hypoperfusion}{the volumic hypoperfusion data. \emph{data.frame}.}   # MRIaggr-class.Rd

#### 280- table_lesion #### 
Line 23 :   \item{table_lesion}{the vertical distribution of the lesion volumes. \emph{data.frame}.}   # MRIaggr-class.Rd

#### 281- table_reperfusion #### 
Line 24 :   \item{table_reperfusion}{the volumic reperfusion data. \emph{data.frame}.}   # MRIaggr-class.Rd

#### 282- tabular #### 
Line 20 :   \item{tabular}{a list of data.frame to display in the table format. \emph{list of data.frame} or \code{NULL} if there is no table to display.} # Miscellaneous-constLatex.Rd
Line 24 :   \item{tabular}{a list of data.frame to display in the table format. \emph{list of data.frame} or \code{NULL} if there is no table to display.} # Miscellaneous-initConstLatex.Rd

#### 283- test #### 
Line 15 :   \item{test}{should the mask be checked ? \emph{logical}.  } # MRIaggr-initMask.Rd
Line 17 :   \item{test}{should the slice numbers be checked ? \emph{logical}.  } # MRIaggr-initNum.Rd
Line 16 :   \item{test}{should the parameters be checked ? \emph{logical}.} # MRIaggr-initParameter.Rd

#### 284- test.regional #### 
Line 18 :   \item{test.regional}{Should regional regularization be considered. \emph{logical}.} # sfMM-rhoMF.Rd

#### 285- test_regional #### 
Line 23 : \item{test_regional}{should regional regularisation be used. \emph{logical}.} # sfMM-calcPotts_cpp.Rd

#### 286- th.breaks #### 
Line 21 :   \item{th.breaks}{the number of thresholds to use. \emph{postive integer}.} # MRIaggr-calcBrainMask.Rd

#### 287- th.select_optima #### 
Line 23 :   \item{th.select_optima}{the rank of the optimum to retain. \emph{postive integer}.} # MRIaggr-calcBrainMask.Rd

#### 288- th.smoothing #### 
Line 22 :   \item{th.smoothing}{should the derivative be smoothed ? \emph{logical}.} # MRIaggr-calcBrainMask.Rd

#### 289- th.upper #### 
Line 24 :   \item{th.upper}{should the observations above the selected threshold be retained ? Else the observations bellow will the selected threshold be retained. \emph{logical}.} # MRIaggr-calcBrainMask.Rd

#### 290- thin #### 
Line 27 :   \item{thin}{the thinning interval between consecutive observations. \emph{integer}.} # sfMM-rhoLvfree.Rd

#### 291- threshold #### 
Line 18 :   \item{threshold}{the value of the hypoperfusion thresholds. \emph{numeric vector}.} # MRIaggr-calcTableHypoReperf.Rd
Line 26 :   \item{threshold}{the thresholds to be used for the discretization of the contrast parameter. \emph{numeric vector}.} # MRIaggr-calcThresholdMRIaggr.Rd
Line 17 :   \item{threshold}{the value above which the local mean of the binary parameters is assigned to 1 (and otherwise to 0). \emph{numeric between 0 and 1}.} # MRIaggr-constCompressMRIaggr.Rd
Line 17 : \item{threshold}{The minimum value to consider non-negligible group membership. \emph{numeric}. Default is  \code{0.01}.} # sfMM-calcMultiPotential.Rd
Line 16 : \item{threshold}{The minimum value to consider non-negligible group membership. \emph{numeric}.} # sfMM-calcMultiPotential_cpp.Rd
Line 23 : \item{threshold}{The minimum value to consider non-negligible group membership. \emph{numeric}.} # sfMM-calcPotts.Rd
Line 25 : \item{threshold}{the minimum value to consider non-negligible group membership. \emph{numeric}.} # sfMM-calcPotts_cpp.Rd
Line 13 :   \item{threshold}{observations with a \code{sample} value below the value of \code{threshold} are discarded. \emph{numeric}.}  # sfMM-calcRadius_cpp.Rd
Line 21 :   \item{threshold}{the minimum value of the posterior probability for group G for being considered as lesioned when forming the spatial groups. \emph{double}.}  # sfMM-rhoMF.Rd

#### 292- timepoint #### 
Line 17 :   \item{timepoint}{one or two time points. \emph{character vector}. REQUIRED.} # MRIaggr-calcTableHypoReperf.Rd

#### 293- title #### 
Line 34 :   \item{title}{the title of the latex document. \emph{character}.} # Miscellaneous-constLatex.Rd

#### 294- tol #### 
Line 14 :   \item{tol}{numeric precision for the consistency check. \emph{positive numeric}.} # MRIaggr-Carto3D2MRIaggr.Rd
Line 18 :   \item{tol}{numeric precision for the consistency check. \emph{positive numeric}.} # MRIaggr-constMRIaggr.Rd

#### 295- trim #### 
Line 28 :   \item{trim}{the length in mm with which the imported images will be cropped (left, bottom, right top). \emph{numeric vector of size 4}.} # Miscellaneous-constLatex.Rd

#### 296- trim.legend #### 
Line 32 :   \item{trim.legend}{the length in mm with which the legend of the images will be cropped. \emph{numeric vector of size 4}.} # Miscellaneous-constLatex.Rd

#### 297- type #### 
Line 54 :   \item{type}{the operator used to compare the size. \emph{character}. See the details section for more information.} # Miscellaneous-valid.Rd
Line 16 :   \item{type}{the type of volumic information. Can be \code{"lesion"} \code{"reperfusion"} \code{"hypoperfusion"}. REQUIRED.} # MRIaggr-allocTable.Rd
Line 15 :   \item{type}{the type of element to be allocated. Can be \code{"Wmatrix"}, \code{"Wblocks"} or \code{"upper"}. REQUIRED.} # MRIaggr-allocW.Rd
Line 19 :   \item{type}{the method to use. Can be \code{"threshold"} or \code{"kmeans"}.} # MRIaggr-calcBrainMask.Rd
Line 17 :   \item{type}{the method used to compute the contralateral correspondent of each voxel. Can be \code{"mean"}, \code{"median"} or \code{"1NN_penalised"}.} # MRIaggr-calcControlateral.Rd
Line 23 :   \item{type}{the type of plot to display. Any of \code{"image"} or \code{"image.plot"} or \code{FALSE} meaning no plot.} # MRIaggr-heatmapMRIaggr.Rd
Line 29 :   \item{type}{the type of plot to display. \emph{character}. See \code{\link{plot.default}} for more details.} # MRIaggr-plotDistClass.Rd
Line 27 :   \item{type}{the type of item to plot. \emph{character}. See \code{plot3d} for more details.} # MRIaggr-plotLesion3D.Rd
Line 19 :   \item{type}{the type of plot to display. Can be \code{"matplot"} or \code{"evolution"}.} # MRIaggr-plotTableLesion.Rd
Line 14 :   \item{type}{the type of normalization. Must be on of \code{"global"}, \code{"slice"}, \code{"3slices"} or \code{NULL} leading to select all types of normalization.} # MRIaggr-selectNormalization.Rd
Line 16 :   \item{type}{the type of parameter to select. \emph{character}. See the details section.} # MRIaggr-selectParameter.Rd
Line 13 :   \item{type}{the table to extract. Can be \code{"lesion"}, \code{"reperfusion"} or \code{"hypoperfusion"}. REQUIRED.} # MRIaggr-selectTable.Rd
Line 14 :   \item{type}{the type of the element to select. Can be \code{"Wmatrix"}, \code{"Wblocks"} or \code{"upper"}.} # MRIaggr-selectW.Rd

#### 298- type.breaks #### 
Line 20 :   \item{type.breaks}{should the break points be equally space according the range of data values (\code{"range"}), centered (\code{"range_center"}) or correspond to the quantile values (\code{"quantile"}) ?} # MRIaggr-initCol.Rd

#### 299- type.plot #### 
Line 24 :   \item{type.plot}{the type of plot to be displayed. Can be \code{"plot3d"} or \code{"shapelist3d"}.} # MRIaggr-plotLesion3D.Rd

#### 300- type_med #### 
Line 21 :   \item{type_med}{should the median contralateral value be used ? \emph{logical}.} # MRIaggr-calcContro_cpp.Rd

#### 301- type_moy #### 
Line 20 :   \item{type_moy}{should the mean contralateral value be used ? \emph{logical}.} # MRIaggr-calcContro_cpp.Rd

#### 302- type_NN #### 
Line 22 :   \item{type_NN}{should the closest contralateral voxel according to the reference parameter be used ? \emph{logical}.} # MRIaggr-calcContro_cpp.Rd

#### 303- type_reg #### 
Line 31 : \item{type_reg}{the type image to regularize : continuous or categorical ? \emph{logical}.} # sfMM-calcPotts_cpp.Rd

#### 304- unit #### 
Line 17 :   \item{unit}{the units in which \code{height} and \code{width} are given. \emph{character}.} # MRIaggr-initWindow.Rd
Line 13 :   \item{unit}{should the unit be returned ? \emph{logical}.} # MRIaggr-selectVoxelSize.Rd

#### 305- unit_angle #### 
Line 30 :   \item{unit_angle}{the unit in which the angle is given. Can be \code{"radian"} or \code{"degree"}.} # MRIaggr-calcHemisphere.Rd

#### 306- update.object #### 
Line 34 :   \item{update.object}{should the resulting mask be stored in \code{object} as a \code{"mask"} parameter ? \emph{logical}.} # MRIaggr-calcBrainMask.Rd
Line 23 :   \item{update.object}{should the resulting contralateral parameters be stored in \code{object} ? \emph{logical}.} # MRIaggr-calcControlateral.Rd
Line 22 :   \item{update.object}{should the resulting distance parameters be stored in \code{object} ? \emph{logical}.} # MRIaggr-calcDistMask.Rd
Line 26 :   \item{update.object}{should the resulting filtered parameters be stored in \code{object} ? \emph{logical}.} # MRIaggr-calcFilter.Rd
Line 23 :   \item{update.object}{should the resulting spatial groups be stored in \code{object} ? \emph{logical}.} # MRIaggr-calcGroupsMask.Rd
Line 39 :   \item{update.object}{should the resulting midplane be stored in \code{object} ? \emph{logical}.} # MRIaggr-calcHemisphere.Rd
Line 23 :   \item{update.object}{should the resulting normalization values be stored in \code{object} ? \emph{logical}.} # MRIaggr-calcNormalization.Rd
Line 28 :   \item{update.object}{should the resulting regional parameters be stored in \code{object} ? \emph{logical}.} # MRIaggr-calcRegionaContrast.Rd
Line 21 :   \item{update.object}{should the resulting threshold analysis be stored in \code{object@ls_descStats} ? \emph{logical}.} # MRIaggr-calcROCthreshold.Rd
Line 35 :   \item{update.object}{should the resulting regularized mask be stored in \code{object} ? \emph{logical}.} # MRIaggr-calcSmoothMask.Rd
Line 28 :   \item{update.object}{should the resulting values be stored in \code{object} ? \emph{logical}.} # MRIaggr-calcTableHypoReperf.Rd
Line 19 :   \item{update.object}{should the resulting lesion table be stored in \code{object} ? \emph{logical}.} # MRIaggr-calcTableLesion.Rd
Line 38 :   \item{update.object}{should the resulting thresholded parameters be stored in \code{object} ? \emph{logical}.} # MRIaggr-calcThresholdMRIaggr.Rd
Line 24 :   \item{update.object}{should the resulting tissue types be stored in \code{object} ? \emph{logical}.} # MRIaggr-calcTissueType.Rd
Line 33 :   \item{update.object}{should the resulting neighbourhood matrix be stored in \code{object} ? \emph{logical}.} # MRIaggr-calcW.Rd
Line 44 :   \item{update.object}{should the new parameter be stored in \code{object} ? \emph{logical}.} # MRIaggr-outlineMRIaggr.Rd

#### 307- update_epsilon #### 
Line 23 :   \item{update_epsilon}{if over 1 the value by which the epsilon parameter is devided every 5\% of the total iterations, if under one the acceptance rate to reach. \emph{double}.} # sfMM-rhoLvfree.Rd

#### 308- upper #### 
Line 17 : \item{upper}{upper truncation point. \emph{numeric}. Default is \code{Inf}.} # Miscellaneous-dtnorm.Rd
Line 27 :   \item{upper}{should the entire matrix (\code{NULL}) or only the upper-triagonal (\code{TRUE}) or only the lower-triagonal (\code{FALSE}) values be calculated ?} # MRIaggr-calcW.Rd
Line 19 :   \item{upper}{the format of the matrix to extract. Can be the full matrix (\code{upper=NULL}) or upper- or lower-triangular matrix (\code{upper=TRUE} or \code{upper=FALSE}).}   # MRIaggr-selectW.Rd

#### 309- validClass #### 
Line 49 :   \item{validClass}{the valid classes for the argument. \emph{character vector}.} # Miscellaneous-valid.Rd

#### 310- validLength #### 
Line 48 :   \item{validLength}{the valid lengthes for the argument. \emph{integer vector}.} # Miscellaneous-valid.Rd

#### 311- validValues #### 
Line 50 :   \item{validValues}{the valid values for the argument. \emph{character vector}.} # Miscellaneous-valid.Rd

#### 312- value #### 
Line 14 :   \item{value}{the clinical data. A one row \emph{data.frame}. REQUIRED.} # MRIaggr-allocClinic.Rd
Line 14 :   \item{value}{the value of each contrast parameter (in columns) at each voxel (in rows). \emph{data.frame}. REQUIRED.} # MRIaggr-allocContrast.Rd
Line 14 :   \item{value}{any R object. REQUIRED.} # MRIaggr-allocDescStats.Rd
Line 14 :   \item{value}{a \emph{list} of \emph{data.frame}. Names must be among \code{"midplane"}, \code{"hemispheres"} \code{"data"}. See the Details section. REQUIRED.}   # MRIaggr-allocHemisphere.Rd
Line 14 :   \item{value}{the normalisation values. A \emph{list} of \emph{data.frame}. REQUIRED.} # MRIaggr-allocNormalization.Rd
Line 15 :   \item{value}{the volumic information. \emph{data.frame}. REQUIRED.} # MRIaggr-allocTable.Rd
Line 14 :   \item{value}{a list containing the neighbourhood matrix and associated elements. \emph{list}. See the details section. REQUIRED.} # MRIaggr-allocW.Rd
Line 17 :   \item{value}{the contrast parameter value for each voxel. \emph{numeric vector}.} # MRIaggr-calcHemi_cpp.Rd
Line 14 :   \item{value}{the name of the parameter(s) that should be removed. \emph{character vector}. REQUIRED.} # MRIaggr-supprContrast.Rd
Line 14 :   \item{value}{the name of the element(s) that should be removed. \emph{character vector}. REQUIRED.} # MRIaggr-supprDescStats.Rd

#### 313- value, value1, value2 #### 
Line 46 :   \item{value, value1, value2}{the value of the argument(s).} # Miscellaneous-valid.Rd

#### 314- var_ref #### 
Line 19 :   \item{var_ref}{the variance of the reference parameter. \emph{numeric}.} # MRIaggr-calcContro_cpp.Rd

#### 315- Vbackground_max #### 
Line 31 :   \item{Vbackground_max}{background observations with a proportion of neighbors belonging to the mask higher than \code{Vbackground_max} are attributed to the mask. \emph{numeric between 0 and 1}.} # MRIaggr-calcSmoothMask.Rd

#### 316- Vec_data #### 
Line 12 :   \item{Vec_data}{vector of data to which the filter will be applied.} # MRIaggr-filtrage3D_cpp.Rd
Line 11 :   \item{Vec_data}{vector of data to which the filter will be applied.} # MRIaggr-filtrage3Dmed_cpp.Rd

#### 317- Vec_operateur #### 
Line 14 :   \item{Vec_operateur}{vector representing the filter to be applied.} # MRIaggr-filtrage3D_cpp.Rd
Line 13 :   \item{Vec_operateur}{vector representing the filter to be applied.} # MRIaggr-filtrage3Dmed_cpp.Rd

#### 318- verbose #### 
Line 27 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.}   # GRalgo-calcGR.Rd
Line 24 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.}   # GRalgo-calcSigmaGR.Rd
Line 31 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.}   # GRalgo-initGR.Rd
Line 26 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # Miscellaneous-constLatex.Rd
Line 27 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # Miscellaneous-initConstLatex.Rd
Line 17 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-allocClinic.Rd
Line 18 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-allocContrast.Rd
Line 17 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-allocDescStats.Rd
Line 16 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-allocHemisphere.Rd
Line 16 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-allocNormalization.Rd
Line 18 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-allocTable.Rd
Line 17 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-allocW.Rd
Line 16 :   \item{verbose}{Should the process be verbose over iterations ? \emph{logical}.} # MRIaggr-calcBlockW.Rd
Line 16 :   \item{verbose}{Should the process be verbose over iterations ? \emph{logical}.} # MRIaggr-calcBlockW_cpp.Rd
Line 23 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-calcContro_cpp.Rd
Line 22 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-calcControlateral.Rd
Line 21 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.}  # MRIaggr-calcDistMask.Rd
Line 25 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-calcFilter.Rd
Line 16 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-calcGroupsCoords.Rd
Line 19 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-calcGroupsCoords_cpp.Rd
Line 22 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-calcGroupsMask.Rd
Line 15 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-calcGroupsW.Rd
Line 15 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-calcGroupsW_cpp.Rd
Line 22 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-calcNormalization.Rd
Line 26 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-calcRegionaContrast.Rd
Line 34 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-calcSmoothMask.Rd
Line 26 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-calcTableHypoReperf.Rd
Line 18 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-calcTableLesion.Rd
Line 37 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-calcThresholdMRIaggr.Rd
Line 22 :   \item{verbose}{indicate the level of output as the algorithm runs. \emph{logical}.} # MRIaggr-calcTissueType.Rd
Line 32 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-calcW.Rd
Line 16 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-Carto3D2MRIaggr.Rd
Line 18 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-constCompressMRIaggr.Rd
Line 21 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-constMRIaggr.Rd
Line 42 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-outlineMRIaggr.Rd
Line 20 :   \item{verbose}{should a summary of all attributes should be displayed or only those which are non-empty ? \emph{logical}.} # MRIaggr-summary.MRIaggr.Rd
Line 15 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-supprContrast.Rd
Line 15 :   \item{verbose}{should the execution of the function be traced ? \emph{logical}.} # MRIaggr-supprDescStats.Rd
Line 17 :   \item{verbose}{is a logical variable that allows text-based feedback during execution of the function.}  # MRIaggr-writeMRI.Rd
Line 26 : 	\item{verbose}{is a logical variable that allows text-based feedback during execution of the function.}  # MRIaggr-writeMRIaggr.Rd
Line 20 : \item{verbose}{Should the radius of the spatial groups be displayed ? \emph{logical}.} # sfMM-calcMultiPotential.Rd
Line 28 : \item{verbose}{should the ICM be be traced over iterations ? \emph{logical}. 1 to display each iteration and 2 to display convergence diagnostics.} # sfMM-calcPotts.Rd
Line 33 : \item{verbose}{should the running be be traced over iterations ? \emph{logical}. 1 to display each iteration and 2 to display convergence diagnostics.} # sfMM-calcPotts_cpp.Rd
Line 16 :   \item{verbose}{should the execution of the function be be traced ? Can be \code{0}, \code{1}, \code{2} or \code{3}.}   # sfMM-calcPottsParameter.Rd
Line 15 :   \item{verbose}{should the radius of the spatial group be printed ? \emph{logical}.}  # sfMM-calcRadius_cpp.Rd
Line 29 :   \item{verbose}{how should the execution of the function should be traced ? 1 traces display the initialization and the final result, \code{2} traces every 5\% of the total iterations and \code{3} also displays the update performed every 5\%.} # sfMM-rhoLvfree.Rd
Line 20 : \item{verbose}{should the simulation be be traced over iterations ? \emph{logical}.} # sfMM-simulPotts.Rd
Line 22 :   \item{verbose}{should the convergence criterion be printed at each step ? \emph{logical}.} # sfMM-simulPotts_cpp.Rd

#### 319- Vmask_min #### 
Line 30 :   \item{Vmask_min}{mask observations with a proportion of neighbors belonging to the mask lower than \code{Vmask_min} are attributed to the background. \emph{numeric between 0 and 1}.} # MRIaggr-calcSmoothMask.Rd

#### 320- voxelDim #### 
Line 14 :   \item{voxelDim}{the voxel size with its unit of measure. A four columns \emph{data.frame} with names \code{"i"}, \code{"j"}, \code{"k"} and \code{"unit"}.}   # Carto3D-class.Rd
Line 17 :   \item{voxelDim}{the voxel size with its unit of measure. A four columns \emph{data.frame} with names \code{"i"}, \code{"j"}, \code{"k"} and \code{"unit"}.} # Carto3D-constCarto3D.Rd
Line 14 :   \item{voxelDim}{the voxel size dimensions its unit of measure. A four columns \emph{data.frame} with names \code{"i"}, \code{"j"}, \code{"k"} and \code{"unit"}.}   # MRIaggr-class.Rd
Line 20 :   \item{voxelDim}{the voxel size with its unit of measure. A four columns \emph{data.frame} with names \code{"i"}, \code{"j"}, \code{"k"} and \code{"unit"}.} # MRIaggr-constMRIaggr.Rd

#### 321- W #### 
Line 15 :   \item{W}{the neighbourhood matrix. \emph{dgCMatrix} or \code{NULL} leading to not compute the d1 criterion.} # GRalgo-calcCriteriaGR.Rd
Line 15 :   \item{W}{the neighbourhood matrix. \emph{dgCMatrix}. REQUIRED.} # GRalgo-calcGR.Rd
Line 14 :   \item{W}{the neighbourhood matrix. \emph{dgCMatrix}. REQUIRED.} # GRalgo-calcSigmaGR.Rd
Line 13 :   \item{W}{the neighbourhood matrix. \emph{dgCMatrix}.} # GRalgo-GRalgo.Rd
Line 14 :   \item{W}{the neighbourhood matrix. \emph{dgCMatrix}.} # GRalgo-initGR.Rd
Line 12 :   \item{W}{the neighbourhood matrix. \emph{dgCMatrix}. REQUIRED.} # MRIaggr-calcBlockW.Rd
Line 18 :   \item{W}{the neighbourhood matrix. \emph{dgCMatrix} or \code{"ifany"} leading to use the neighbourhood matrix stored in the \code{object} if any and else computate this matrix.} # MRIaggr-calcGroupsMask.Rd
Line 12 :   \item{W}{the neighbourhood matrix. \emph{dgCMatrix}. REQUIRED.} # MRIaggr-calcGroupsW.Rd
Line 20 :   \item{W}{the neighbourhood matrix. \emph{dgCMatrix} or \code{"ifany"} leading to use the neighbourhood matrix stored in the \code{object} if possible, else to compute this matrix.} # MRIaggr-calcRegionaContrast.Rd
Line 30 :   \item{W}{the neighbourhood matrix. \emph{dgCMatrix} or \code{"ifany"} leading to use the neighbourhood matrix stored in the \code{object} if any and else computate this matrix.} # MRIaggr-calcThresholdMRIaggr.Rd
Line 21 :   \item{W}{the neighbourhood matrix. \emph{list}.}   # MRIaggr-class.Rd
Line 12 : \item{W}{the neighbourhood matrix. \emph{dgCMatrix}. Should be normalized by row (i.e. \code{rowSums(W)=1}). REQUIRED.} # sfMM-simulPotts.Rd

#### 322- W.range #### 
Line 19 :   \item{W.range}{the neighbourhood range. \emph{postive numeric}. REQUIRED.} # MRIaggr-calcGroupsMask.Rd
Line 21 :   \item{W.range}{the neighbourhood range. \emph{postive numeric}. Required only if \code{W} have to be computed.} # MRIaggr-calcRegionaContrast.Rd
Line 33 :   \item{W.range}{only distances smaller than \code{W.range} are stored in \code{W}. \emph{postive numeric}.} # MRIaggr-calcThresholdMRIaggr.Rd

#### 323- W.spatial_res #### 
Line 20 :   \item{W.spatial_res}{a dilatation factor for the coordinates. \emph{positive numeric vector of size 3}.} # MRIaggr-calcGroupsMask.Rd
Line 22 :   \item{W.spatial_res}{a dilatation factor for the coordinates. \emph{positive numeric vector of size 3}.} # MRIaggr-calcRegionaContrast.Rd
Line 34 :   \item{W.spatial_res}{a dilatation factor for the coordinates. \emph{positive numeric vector of size 3}.} # MRIaggr-calcThresholdMRIaggr.Rd

#### 324- W_i #### 
Line 11 :   \item{W_i}{the 0-based row numbers for each non-zero element in the sparse neighbourhood  matrix. \emph{integer vector}.}   # MRIaggr-calcBlockW_cpp.Rd
Line 11 :   \item{W_i}{the 0-based row numbers for each non-zero element in the sparse neighbourhood  matrix. \emph{integer vector}.}   # MRIaggr-calcGroupsW_cpp.Rd
Line 11 :   \item{W_i}{the 0-based row numbers for each non-zero element in the sparse neighbourhood  matrix. \emph{integer vector}.}   # sfMM-simulPottsFast_cpp.Rd

#### 325- W_LR #### 
Line 13 : \item{W_LR}{The regional neighborhood matrix. \emph{dgCMatrix}. Should contain the distances between the observations (\code{0} indicating infinite distance). REQUIRED.} # sfMM-calcMultiPotential.Rd
Line 14 : \item{W_LR}{The regional neighborhood matrix. \emph{dgCMatrix}. Should contain the distances between the observations (\code{0} indicating infinite distance).} # sfMM-calcMultiPotential_cpp.Rd
Line 19 : \item{W_LR}{The regional neighborhood matrix. \emph{dgCMatrix}. Should contain the distances between the observations (\code{0} indicating infinite distance).} # sfMM-calcPotts.Rd
Line 15 : \item{W_LR}{the regional neighborhood matrix. \emph{dgCMatrix}. Should contain the distances between the observations (\code{0} indicating infinite distance).} # sfMM-calcPotts_cpp.Rd
Line 19 :   \item{W_LR}{the regional neighbourhood matrix. \emph{dgCMatrix}. Should be contains the distances between the observations (0 indicating infinite distance).} # sfMM-rhoMF.Rd
Line 13 :   \item{W_LR}{the regional neighbourhood matrix. \emph{dgCMatrix}. Should contain the categroy of distance.} # sfMM-simulPotts_cpp.Rd

#### 326- W_p #### 
Line 12 :   \item{W_p}{the pointers to the initial (zero-based) index of elements in the colum of the sparse neighbourhood matrix. \emph{integer vector}.} # MRIaggr-calcBlockW_cpp.Rd
Line 12 :   \item{W_p}{the pointers to the initial (zero-based) index of elements in the colum of the sparse neighbourhood matrix. \emph{integer vector}.} # MRIaggr-calcGroupsW_cpp.Rd
Line 12 :   \item{W_p}{the pointers to the initial (zero-based) index of elements in the colum of the sparse neighbourhood matrix. \emph{integer vector}.} # sfMM-simulPottsFast_cpp.Rd

#### 327- W_SR #### 
Line 12 : \item{W_SR}{The local neighborhood matrix. \emph{dgCMatrix}. Should be normalized by row (i.e. \code{rowSums(Wweight_SR)=1}). REQUIRED.} # sfMM-calcMultiPotential.Rd
Line 13 : \item{W_SR}{The local neighborhood matrix. \emph{dgCMatrix}. Should be normalized by row (i.e. \code{rowSums(W_SR)=1}).} # sfMM-calcMultiPotential_cpp.Rd
Line 13 : \item{W_SR}{The local neighborhood matrix. \emph{dgCMatrix}. Should be normalized by row (i.e. \code{rowSums(W_SR)=1}). REQUIRED.} # sfMM-calcPotts.Rd
Line 14 : \item{W_SR}{the local neighborhood matrix. \emph{dgCMatrix}. Should be normalized by row (i.e. \code{rowSums(W_SR)=1}).} # sfMM-calcPotts_cpp.Rd
Line 12 :   \item{W_SR}{the local neighbourhood matrix. \emph{dgCMatrix}. Should be normalized by row (i.e. \code{rowSums(W_SR)=1}). REQUIRED.} # sfMM-calcPottsParameter.Rd
Line 15 :   \item{W_SR}{the local neighbourhood matrix. \emph{dgCMatrix}. Should be normalized by row (i.e. \code{rowSums(W_SR)=1}). REQUIRED.} # sfMM-rhoLvfree.Rd
Line 14 :   \item{W_SR}{the local neighbourhood matrix. \code{dgCMatrix}. Should be normalized by row (i.e. \code{rowSums(Wweight_SR)=1}). REQUIRED.} # sfMM-rhoMF.Rd
Line 12 :   \item{W_SR}{the local neighbourhood matrix. \emph{dgCMatrix}. Should be normalized by row (i.e. \code{rowSums(W_SR)=1}).} # sfMM-simulPotts_cpp.Rd

#### 328- W_x #### 
Line 13 :   \item{W_x}{the non-zero elements of the matrix. \emph{numeric vector}.}   # sfMM-simulPottsFast_cpp.Rd

#### 329- what #### 
Line 16 :   \item{what}{an object whose mode will give the mode of the vector to be read, or a character vector of length one describing the mode: one of "numeric", "double", "integer", "int", "logical", "complex", "character", "raw". Only active if \code{format} equals \code{rawb.gz}.} # MRIaggr-readMRI.Rd

#### 330- width #### 
Line 27 :   \item{width}{the width of each image relative to the linewidth. \emph{positive numeric}.} # Miscellaneous-constLatex.Rd
Line 15 :   \item{width}{the width of the device used to export the plot in inches. \emph{postive numeric}.} # MRIaggr-initDisplayWindow.Rd
Line 15 :   \item{width}{the width of the device used to export the plot. \emph{postive numeric}.} # MRIaggr-initWindow.Rd

#### 331- width.legend #### 
Line 31 :   \item{width.legend}{the width of the legend image relative to the linewidth. \emph{numeric between 0 and 1}.} # Miscellaneous-constLatex.Rd

#### 332- window #### 
Line 12 :   \item{window}{the type of device on which the plot will be displayed. \emph{logical}, \code{NULL} or \emph{character}.} # MRIaggr-initDisplayWindow.Rd
Line 12 :   \item{window}{the type of device on which the plot will be displayed. \emph{logical}, \code{NULL} or \emph{character}.} # MRIaggr-initWindow.Rd

#### 333- x #### 
Line 12 :   \item{x}{the biomarker values. \emph{numeric vector}. REQUIRED.} # Miscellaneous-calcAUPRC.Rd
Line 12 : \item{x}{vector of quantiles. \emph{numeric vector}.} # Miscellaneous-dtnorm.Rd
Line 11 :   \item{x}{the data on which the kernel will be applied. \emph{numeric} or \emph{numeric vector}.} # Miscellaneous-EDK.Rd
Line 14 :   \item{x}{a \emph{numeric vector}, ranging between 0 and 1 for \code{logit}.}   # Miscellaneous-logit.Rd

#### 334- x.legend #### 
Line 26 :   \item{x.legend}{the x coordinates of the legend. \emph{numeric} or \emph{character}.} # MRIaggr-boxplotMask.Rd
Line 32 :   \item{x.legend}{the x coordinates of the legend. \emph{numeric} or \emph{character}.} # MRIaggr-plotDistClass.Rd

#### 335- xlab #### 
Line 26 :   \item{xlab}{a title for the x axis. \emph{character}.} # MRIaggr-plotMRI.Rd

#### 336- xlim #### 
Line 21 :   \item{xlim}{the x limits of the plot. \emph{numeric vector of size 2}.} # MRIaggr-initWindow.Rd
Line 35 :   \item{xlim}{the x limits of the plot. \emph{numeric vector of size 2} or \code{NULL} leading to automatic setting of the x limits.} # MRIaggr-multiplot.Rd
Line 25 :   \item{xlim}{the y limits of the plot. \emph{numeric vector of size 2} or \code{NULL} leading to automatic setting of the x limits.} # MRIaggr-outlineMRIaggr.Rd
Line 21 :   \item{xlim}{the x limits of the plot. \emph{numeric vector of size 2} or \code{NULL} leading to automatic setting of the x limits.} # MRIaggr-plotLesion3D.Rd
Line 19 :   \item{xlim}{the x limits of the plot. \emph{numeric vector of size 2}.} # MRIaggr-plotMRI.Rd

#### 337- y #### 
Line 13 :   \item{y}{the class labels. \emph{numeric vector}, \emph{character vector} or \emph{logical vector}. REQUIRED.} # Miscellaneous-calcAUPRC.Rd

#### 338- Y #### 
Line 11 :   \item{Y}{a \emph{matrix} containing the observations (by rows) for the various groups (by columns). REQUIRED.}   # sfMM-calcPottsParameter.Rd
Line 14 :   \item{Y}{a \emph{matrix} containing the observations (by rows) for the various groups (by columns). REQUIRED.}   # sfMM-rhoLvfree.Rd
Line 13 :   \item{Y}{a \emph{matrix} containing the observations (by rows) for the various groups (by columns). REQUIRED.}   # sfMM-rhoMF.Rd

#### 339- y.legend #### 
Line 27 :   \item{y.legend}{the y coordinates of the legend. \emph{numeric} or \emph{character}.} # MRIaggr-boxplotMask.Rd
Line 33 :   \item{y.legend}{the y coordinates of the legend. \emph{numeric} or \emph{character}.} # MRIaggr-plotDistClass.Rd

#### 340- ylab #### 
Line 27 :   \item{ylab}{a title for the y axis. \emph{character}.} # MRIaggr-plotMRI.Rd

#### 341- ylim #### 
Line 22 :   \item{ylim}{the y limits of the plot. \emph{numeric vector of size 2} or \code{NULL} leading to automatic setting of the y limits.} # MRIaggr-boxplotMask.Rd
Line 22 :   \item{ylim}{the y limits of the plot. \emph{numeric vector of size 2}.} # MRIaggr-initWindow.Rd
Line 36 :   \item{ylim}{the y limits of the plot. \emph{numeric vector of size 2} or \code{NULL} leading to automatic setting of the y limits.} # MRIaggr-multiplot.Rd
Line 26 :   \item{ylim}{the y limits of the plot. \emph{numeric vector of size 2} or \code{NULL} leading to automatic setting of the y limits.} # MRIaggr-outlineMRIaggr.Rd
Line 24 :   \item{ylim}{the y limits of the plot. \emph{numeric vector of size 2} or \code{NULL} leading to automatic setting of the y limits.} # MRIaggr-plotDistClass.Rd
Line 22 :   \item{ylim}{the y limits of the plot. \emph{numeric vector of size 2} or \code{NULL} leading to automatic setting of the y limits.} # MRIaggr-plotLesion3D.Rd
Line 20 :   \item{ylim}{the y limits of the plot. \emph{numeric vector of size 2}.} # MRIaggr-plotMRI.Rd

#### 342- zlim #### 
Line 23 :   \item{zlim}{the z limits of the plot. \emph{numeric vector of size 2} or \code{NULL} leading to automatic setting of the z limits.} # MRIaggr-plotLesion3D.Rd


 
################################# 116 files .Rd #################################
Carto3D-class.Rd
Carto3D-constCarto3D.Rd
Data-MRIaggr.Pat1_red.Rd
GRalgo-calcCriteriaGR.Rd
GRalgo-calcGR.Rd
GRalgo-calcSigmaGR.Rd
GRalgo-GRalgo.Rd
GRalgo-initGR.Rd
GRalgo-plotSigmaGR.Rd
Miscellaneous-calcAUPRC.Rd
Miscellaneous-constLatex.Rd
Miscellaneous-dtnorm.Rd
Miscellaneous-EDK.Rd
Miscellaneous-initConstLatex.Rd
Miscellaneous-logit.Rd
Miscellaneous-valid.Rd
MRIaggr-allocClinic.Rd
MRIaggr-allocContrast.Rd
MRIaggr-allocDescStats.Rd
MRIaggr-allocHemisphere.Rd
MRIaggr-allocNormalization.Rd
MRIaggr-allocTable.Rd
MRIaggr-allocW.Rd
MRIaggr-array2df.Rd
MRIaggr-boxplotMask.Rd
MRIaggr-calcBlockW.Rd
MRIaggr-calcBlockW_cpp.Rd
MRIaggr-calcBrainMask.Rd
MRIaggr-calcContro_cpp.Rd
MRIaggr-calcControlateral.Rd
MRIaggr-calcDistMask.Rd
MRIaggr-calcDistTissues.Rd
MRIaggr-calcFilter.Rd
MRIaggr-calcGroupsCoords.Rd
MRIaggr-calcGroupsCoords_cpp.Rd
MRIaggr-calcGroupsMask.Rd
MRIaggr-calcGroupsW.Rd
MRIaggr-calcGroupsW_cpp.Rd
MRIaggr-calcHemi_cpp.Rd
MRIaggr-calcHemisphere.Rd
MRIaggr-calcNormalization.Rd
MRIaggr-calcRegionaContrast.Rd
MRIaggr-calcROCthreshold.Rd
MRIaggr-calcSmoothMask.Rd
MRIaggr-calcTableHypoReperf.Rd
MRIaggr-calcTableLesion.Rd
MRIaggr-calcThresholdMRIaggr.Rd
MRIaggr-calcTissueType.Rd
MRIaggr-calcW.Rd
MRIaggr-Carto3D2MRIaggr.Rd
MRIaggr-class.Rd
MRIaggr-constCompressMRIaggr.Rd
MRIaggr-constMRIaggr.Rd
MRIaggr-constReduceMRIaggr.Rd
MRIaggr-df2array.Rd
MRIaggr-filtrage2D_cpp.Rd
MRIaggr-filtrage2Dmed_cpp.Rd
MRIaggr-filtrage3D_cpp.Rd
MRIaggr-filtrage3Dmed_cpp.Rd
MRIaggr-heatmapMRIaggr.Rd
MRIaggr-initCol.Rd
MRIaggr-initDisplayWindow.Rd
MRIaggr-initFilter.Rd
MRIaggr-initIndex.Rd
MRIaggr-initMask.Rd
MRIaggr-initNeighborhood.Rd
MRIaggr-initNum.Rd
MRIaggr-initParameter.Rd
MRIaggr-initWindow.Rd
MRIaggr-legendMRI.Rd
MRIaggr-multiplot.Rd
MRIaggr-outline.Rd
MRIaggr-outlineMRIaggr.Rd
MRIaggr-plotDistClass.Rd
MRIaggr-plotLesion3D.Rd
MRIaggr-plotMRI.Rd
MRIaggr-plotOutline.Rd
MRIaggr-plotTableLesion.Rd
MRIaggr-pointsHemisphere.Rd
MRIaggr-readMRI.Rd
MRIaggr-selectClinic.Rd
MRIaggr-selectContrast.Rd
MRIaggr-selectCoords.Rd
MRIaggr-selectDefault_value.Rd
MRIaggr-selectDescStats.Rd
MRIaggr-selectHemispheres.Rd
MRIaggr-selectHistory.Rd
MRIaggr-selectIdentifier.Rd
MRIaggr-selectMidplane.Rd
MRIaggr-selectN.Rd
MRIaggr-selectNormalization.Rd
MRIaggr-selectParameter.Rd
MRIaggr-selectTable.Rd
MRIaggr-selectVoxelDim.Rd
MRIaggr-selectVoxelSize.Rd
MRIaggr-selectW.Rd
MRIaggr-summary.MRIaggr.Rd
MRIaggr-supprContrast.Rd
MRIaggr-supprDescStats.Rd
MRIaggr-writeMRI.Rd
MRIaggr-writeMRIaggr.Rd
options-allocOptionsMRIaggr.Rd
options-optionsMRIaggr.Rd
options-selectOptionsMRIaggr.Rd
Package-MRIaggr.Rd
sfMM-calcMultiPotential.Rd
sfMM-calcMultiPotential_cpp.Rd
sfMM-calcPotts.Rd
sfMM-calcPotts_cpp.Rd
sfMM-calcPottsParameter.Rd
sfMM-calcRadius_cpp.Rd
sfMM-rhoLvfree.Rd
sfMM-rhoMF.Rd
sfMM-simulPotts.Rd
sfMM-simulPotts_cpp.Rd
sfMM-simulPottsFast_cpp.Rd
