% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locAdj.R
\name{locAdjFun}
\alias{locAdjFun}
\title{Function that modifies the observation locations, to reduce the risk that 
they are on grid cell boundaries}
\usage{
locAdjFun(ifg, locAdj, ress)
}
\arguments{
\item{ifg}{Either a data.frame or tibble or sf-object with the locations and the data of the survey or census data,
or a list of such objects.}

\item{locAdj}{parameter to adjust the coordinates if they are exactly on the borders between grid cells. The values
can either be FALSE, or "jitter" (adding a small random value to the coordinates, essentially spreading
them randomly around the real location), "UR", "UL", "LR" or "LL", to describe which corner of the grid 
cell the location belong (upper right, upper left, lower right or lower left).}

\item{ress}{A vector with the different resolutions}
}
\value{
An \code{\link[sf]{sf}}-object with slightly modified locations for the 
survey or census data, according to the \code{locAdj}-parameter
}
\description{
Function that modifies the observation locations, to reduce the risk that 
they are on grid cell boundaries
}
\details{
This can be used as a pre-processing step before creating a multi-resolution grid.
The gridding procedure will have problems if the points are located exactly on grid cell
boundaries. The locations should therefore be slightly modified, to better control 
to which grid cells they are associated. This can either be a systematic modification,
or a random modification. 

In the case of FSS data, the coordinates have been reported as the lower left
corner of a 1 km grid.
}
\examples{
data(ifs_dk)

ifg = fssgeo(ifs_dk, locAdj = FALSE)
ifg = locAdjFun(ifg, "LL")

}
