% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_MRF_covariates.R
\name{prep_MRF_covariates}
\alias{prep_MRF_covariates}
\title{Cross-multiply response and covariate variables}
\usage{
prep_MRF_covariates(data, n_nodes)
}
\arguments{
\item{data}{Dataframe. The input data where the \code{n_nodes}
left-most variables are outcome variables to be represented by nodes in the graph}

\item{n_nodes}{Integer. The index of the last column in data
which is represented by a node in the final graph. Columns with index
greater than n_nodes are taken as covariates. Default is the number of
columns in data, corresponding to no additional covariates}
}
\value{
Dataframe of the prepped response and covariate variables necessary for
input in \code{\link{MRFcov}} models
}
\description{
This function performs the cross-multiplication necessary
for prepping datasets to be used in \code{\link{MRFcov}} models. This
function is called by several of the functions within the package.
}
\details{
Observations of nodes (species) in \code{data} are prepped for
\code{MRFcov} analysis by multiplication. This function is not designed to be called directly,
but is used by other functions in the package (namely \code{\link{MRFcov}},
\code{\link{MRFcov_spatial}},
\code{\link{cv_MRF_diag}}, and
\code{\link{bootstrap_MRF}})
}
