% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.MRFA.R
\name{predict.MRFA}
\alias{predict.MRFA}
\title{Prediction of Multi-Resolution Functional ANOVA (MRFA) Model}
\usage{
\method{predict}{MRFA}(object, xnew, lambda = object$lambda,
  parallel = FALSE, ...)
}
\arguments{
\item{object}{a class MRFA object estimated by \code{MRFA_fit}.}

\item{xnew}{a testing matrix with dimension \code{n_new} by \code{d} in which each row corresponds to a predictive location.}

\item{lambda}{a value, or vector of values, indexing the path. The default is \code{object$lambda}.}

\item{parallel}{logical. If \code{TRUE}, apply function in parallel in \code{ldply} using parallel backend provided by foreach.}

\item{...}{for compatibility with generic method \code{predict}.}
}
\value{
\item{lambda}{as above.}
\item{coefficients}{coefficients with respect to the basis function value.}
\item{y_hat}{a matrix with dimension \code{n_new} by \code{length(lambda)} displaying predicted responses at locations \code{xnew}.}
}
\description{
The function computes the predicted responses.
}
\examples{
\dontrun{

#####             Testing function: OTL circuit function                     #####
#####  Thanks to Sonja Surjanovic and Derek Bingham, Simon Fraser University #####
otlcircuit <- function(xx)
{
  Rb1  <- 50   + xx[1] * 100
  Rb2  <- 25   + xx[2] * 45
  Rf   <- 0.5  + xx[3] * 2.5
  Rc1  <- 1.2  + xx[4] * 1.3
  Rc2  <- 0.25 + xx[5] * 0.95
  beta <- 50   + xx[6] * 250

  Vb1 <- 12*Rb2 / (Rb1+Rb2)
  term1a <- (Vb1+0.74) * beta * (Rc2+9)
  term1b <- beta*(Rc2+9) + Rf
  term1 <- term1a / term1b

  term2a <- 11.35 * Rf
  term2b <- beta*(Rc2+9) + Rf
  term2 <- term2a / term2b

  term3a <- 0.74 * Rf * beta * (Rc2+9)
  term3b <- (beta*(Rc2+9)+Rf) * Rc1
  term3 <- term3a / term3b

  Vm <- term1 + term2 + term3
  return(Vm)
}

library(MRFA)
#####   Training data and testing data   #####
set.seed(2)
n <- 1000; n_new <- 100; d <- 6
X.train <- matrix(runif(d*n), ncol = d)
Y.train <- apply(X.train, 1, otlcircuit)
X.test <- matrix(runif(d*n_new), ncol = d)
Y.test <- apply(X.test, 1, otlcircuit)

#####   Fitting    #####
MRFA_model <- MRFA_fit(X.train, Y.train, verbose = TRUE)

#####   Prediction   ######
Y.pred <- predict(MRFA_model, X.test, lambda = min(MRFA_model$lambda))$y_hat
print(sqrt(mean((Y.test - Y.pred)^2)))
}
}
\author{
Chih-Li Sung <iamdfchile@gmail.com>
}
\seealso{
\code{\link{MRFA_fit}} for fitting a multiresolution functional ANOVA model.
}

