% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{negLLM}
\alias{negLLM}
\title{negLLM -ve log-normal likelihoods for multiple index time-series}
\usage{
negLLM(pars, funk, logobs, indat, index = "cpue", harvpen = TRUE, ...)
}
\arguments{
\item{pars}{the log-transformed parameter starting points. For a 
surplus production model these are r, K, Binit (if initial 
depletion is likely, otherwise omit this and it will be set =K
inside the function), then as many sigma values as there are 
time-series of indices; these are the associated standard 
deviations of the log-normal residuals.}

\item{funk}{the function that generates the predicted cpue values.
for multiple time-series in a SPM use simpspmM}

\item{logobs}{the log-transformed observed cpue columns in indat,
the data needed by funk tranferred inside the ...}

\item{indat}{the fisheries data used in the analysis}

\item{index}{the prefix of the columns of each of the indices, 
defaults to cpue}

\item{harvpen}{default = TRUE, which sets a penalty1 on each of the 
implied harvest rates to ensure we do not get harvest rates > 1.0}

\item{...}{the continuation ellisis to allow the transfer of other
arguments required by funk}
}
\value{
a single scalar as the -ve log-likelihood of the input data
}
\description{
negLLM we have negLL and negLL1 for use when using -ve
    log-likelihoods to fit surplus production models that only have 
    a single index of relative abundance, but there are many fisheries
    that have more than one index of relative abundance. negLLM is
    for those cases that have multiple (M) time-series of indices. It
    is used in conjunction with simpspmM and spmCE.
}
\examples{
 data(twoindex)
 fish <- as.matrix(twoindex)
 pars <- log(c(0.04,155000,0.4,0.3))
 bestSP <- nlm(f=negLLM,p=pars,funk=simpspmM,indat=fish,
             schaefer=TRUE,logobs=log(fish[,c("cpue1","cpue2")]),
             steptol=1e-06,harvpen=TRUE)
 outfit(bestSP,digits=5,title="negLLM example") #optimum solution
 answer <- plotspmmod(bestSP$estimate,indat=fish,
                      plotprod=TRUE,maxy=3.4)
}
