#' Chi-Square Example Data
#'
#' Dataset for use in \code{\link{v.chi.sq}},
#' Individuals were polled and asked to report their number of friends
#' (low, medium, high) and number of kids (1, 2, 3+)
#' to determine if there was a relationship between friend
#' groups and number of children. It was hypothesized that
#' those with more children may have less time for
#' friendship maintaining activities.
#'
#' @docType data
#'
#' @usage data(chisq_data)
#'
#' @format A data frame of number of friends and number of children
#'
#' friends: number of reported friends
#' kids: number of children
#'
#' @keywords datasets
#'
#' @references Nolan and Heizen Statistics for the Behavioral Sciences
#' (\href{https://www.macmillanlearning.com/Catalog/product/statisticsforthebehavioralsciences-rentalonly-fourthedition-nolan}{Book Link})
#'
"chisq_data"
