% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_proj4string.R
\name{check_proj4string}
\alias{check_proj4string}
\alias{check_proj4string.default}
\alias{check_proj4string.numeric}
\alias{check_proj4string.character}
\alias{check_proj4string.CRS}
\title{Check the validity of the input projection}
\usage{
check_proj4string(projection, abort = FALSE, verbose = TRUE)

\method{check_proj4string}{default}(projection, abort = FALSE,
  verbose = TRUE)

\method{check_proj4string}{numeric}(projection, abort = FALSE,
  verbose = TRUE)

\method{check_proj4string}{character}(projection, abort = FALSE,
  verbose = TRUE)

\method{check_proj4string}{CRS}(projection, abort = FALSE, verbose = TRUE)
}
\arguments{
\item{projection}{\code{character} or \code{integer} corresponding to the
proj4string to be checked, the EPSG code or a UTM zone (e.g. "32N");
alternatively, a \link{CRS} object is accepted.}

\item{abort}{\code{logical} if TRUE, the function aborts in case an invalid invalid
projection is passed. Otherwise, the function returns "NA", Default: TRUE}

\item{verbose}{\code{logical} if TRUE, return messages}
}
\value{
\code{character} proj4string of the object or file
}
\description{
helper function used to check that the input projection
(passed as UTM zone, EPSG code, PROJ4 string or \link{CRS} object)
is a valid string or CRS.
}
\note{
This function was forked from package \code{sprawl}, version 0.3.0.
}
\examples{

\dontrun{
check_proj4string("+init=epsg:32632")

check_proj4string("32631")

check_proj4string(32633)

check_proj4string(30)

check_proj4string("example of invalid string")

library(sp)
check_proj4string(CRS("+init=epsg:32632"))
}
}
\author{
Lorenzo Busetto, phD (2017) \href{mailto:lbusett@gmail.com}{lbusett@gmail.com}

Luigi Ranghetti, phD (2017) \href{mailto:ranghetti.l@irea.cnr.it}{ranghetti.l@irea.cnr.it}
}
