% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinate_conversion.R
\name{sin_to_ll}
\alias{sin_to_ll}
\title{Convert sinusoidal coordinates to lat / lon}
\usage{
sin_to_ll(x, y)
}
\arguments{
\item{x}{sinusoidal x coordinate (vector)}

\item{y}{sinusoidal y coordinate (vector)}
}
\description{
A full description of the sinusoidal projection is provided on the
lpdaac page:
https://lpdaac.usgs.gov/dataset_discovery/modis
and wikipedia:
https://en.wikipedia.org/wiki/Sinusoidal_projection
}
\examples{

\donttest{
# Download some test data
subset <- mt_subset(product = "MOD11A2",
                        lat = 40,
                        lon = -110,
                        band = "LST_Day_1km",
                        start = "2004-01-01",
                        end = "2004-03-31",
                        progress = FALSE)

# convert sinusoidal to lat / lon
lat_lon <- sin_to_ll(subset$xllcorner, subset$yllcorner)

# bind with the original dataframe
subset <- cbind(subset, lat_lon)
head(subset)
}
}
\seealso{
\code{\link[MODISTools]{mt_bbox}}
}
