% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{MLCR}
\alias{MLCR}
\title{Mean length with catch rate mortality estimator}
\usage{
MLCR(MLZ_data, ncp, CPUE.type = c(NA, "WPUE", "NPUE"),
  loglikeCPUE = c("lognormal", "normal"), start = NULL,
  grid.search = TRUE, parallel = ifelse(ncp > 2, TRUE, FALSE),
  min.time = 3, figure = TRUE)
}
\arguments{
\item{MLZ_data}{An object of class \code{\linkS4class{MLZ_data}} containing mean lengths and
life history data of stock.}

\item{ncp}{The number of change points in total mortality in the time series. \code{ncp + 1} total
mortality rates will be estimated.}

\item{CPUE.type}{Indicates whether CPUE time series is abundance or biomass based.}

\item{loglikeCPUE}{Indicates whether the log-likelihood for the CPUE will be lognormally or
normally distributed.}

\item{start}{An optional list of starting values. See details.}

\item{grid.search}{If \code{TRUE}, a grid search will be performed using the \code{\link{profile_MLCR}}
function to find the best starting values for the change points (the years when mortality changes).
Ignored if \code{ncp = 0} or if \code{start} is provided.}

\item{parallel}{Whether grid search is performed with parallel processing. Ignored if \code{grid.search = FALSE}.}

\item{min.time}{The minimum number of years between each change point for the grid search, passed
to \code{\link{profile_MLCR}}. Not used if \code{grid.search = FALSE}.}

\item{figure}{If \code{TRUE}, a call to \code{plot} of observed and predicted mean lengths will be produced.}
}
\value{
An object of class \code{\linkS4class{MLZ_model}}.
}
\description{
Estimator of instantaneous total mortality (Z) from a time series of mean length data.
}
\details{
For a model with \code{I} change points, the starting values in
\code{start} is a list with the following entries:
Z a vector of \code{length = I+1}.
yearZ a vector of \code{length = I}.

\code{start} can be \code{NULL}, in which case, the supplied starting values depend on
the value of \code{grid.search}. If \code{grid.search = TRUE}, starting values will use the
values for \code{yearZ} which minimize the negative log-likelihood from the grid search.
Otherwise, the starting values for \code{yearZ} evenly divide the time series.
}
\examples{
\dontrun{
data(MuttonSnapper)
MLCR(MuttonSnapper, ncp = 2, CPUE.type = "WPUE", grid.search = TRUE)
}
}
\references{
Huynh, Q.C., Gedamke, T., Porch, C.E., Hoenig, J.M., Walter, J.F, Bryan, M., and
Brodziak, J. In revision. Estimating Total Mortality Rates from Mean Lengths and
Catch Rates in Non-equilibrium Situations. Transactions of the American Fisheries Society.
}
\seealso{
\code{\link{profile_MLCR}}
}
