% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.index}
\alias{residuals.index}
\title{Extract Model Residuals}
\usage{
\method{residuals}{index}(object, ...)
}
\arguments{
\item{object}{an object of class \code{index}}

\item{...}{other arguments}
}
\value{
a numeric vector of matrix containing the residuals
}
\description{
For the index of dissimilarity (ID), the residuals are the differences
between the share of the Y population and the share of the X population per
neighbourhood. For the multilevel index, the residuals are estimated at and
partitioned between each level of the model.
}
\examples{
data(aggdata)
index <- id(aggdata, vars = c("Bangladeshi", "WhiteBrit"))
# The ID can be derived from the residuals
0.5 * sum(abs(residuals(index)))
# which is the same as
index[1]

# Extract the standardized and look for regions where the share of the
# Bangladeshi population is unusualy high with respect to the White British
# resids <- rstandard(index)
# table(aggdata$RGN[resids > 2.58])

# Residuals for a multilevel index
index <- id(aggdata, vars = c("Bangladeshi", "WhiteBrit"),
levels = c("MSOA","LAD","RGN"))
resids <- residuals(index)
head(resids)
# Again, the ID can be derived from the residuals
0.5 * sum(abs(rowSums(resids)))

# Looking at the residuals, the London effect is different from other regions
sort(tapply(resids[,4], aggdata$RGN, mean))

# At the local authority scale it is Tower Hamlets and Newham
# (both in London) that have the highest share of the Bangladeshi population
# with respect to the White British:
tail(sort(tapply(resids[,3], aggdata$LAD, mean)),5)
}
\seealso{
\code{\link{rstandard.index}} \code{\link{rstudent.index}}
}
