% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transpose_microbioevents.R
\name{transpose_microbioevents}
\alias{transpose_microbioevents}
\alias{duplicated_microbioevents_records}
\title{Transpose microbiology events dataset}
\usage{
transpose_microbioevents(raw_df,
                                 key_columns,
                                 required_columns,
                                 transpose_key_column,
                                 transpose_value_column,
                                 fill="NA",
                                 non_empty_filter_column,
                                 remove_duplicates=TRUE)
}
\arguments{
\item{key_columns}{(Optional) Primary Key/ Key columns for duplicate check
: Default Value = c('subject_id','micro_specimen_id','isolate_num',
'org_name','ab_itemid')}

\item{raw_df}{A data frame containing microbiology events}

\item{required_columns}{(Optional) columns should contain in final dataset
: Default Value c('subject_id','hadm_id','micro_specimen_id',
'order_provider_id', 'chartdate','charttime',
'spec_itemid','spec_type_desc','storedate',
'storetime','test_itemid','test_name',
'org_itemid','isolate_num','org_name')}

\item{transpose_key_column}{(Optional) The column that should be transposed
(                        - distinct values of that column will become separate columns)
:Default 'ab_name'}

\item{transpose_value_column}{(optional) Values of 'transpose_key_column' column
:Default 'interpretation'}

\item{fill}{(optional) Fill character for empty columns- Default : "NA"}

\item{non_empty_filter_column}{(optional) Filter input dataframe
where 'non_empty_filter_column' is not empty
or na. Default :'ab_itemid'}

\item{remove_duplicates}{(optional) Default :TRUE}
}
\value{
Data Frame
}
\description{
This function helps to transpose (rows to columns) microbiology events.
}
\examples{
test_data <- data.frame(subject_id=c('10016742','10016742','10016742',
                                     '10016742','10016742','10038332',
                                     '10038332','10038332','10038332',
                                     '10038332','10038332'),
                       chartdate= c('2178-07-03','2178-08-01','2178-08-01',
                                    '2178-08-01','2178-09-25','2164-07-31',
                                    '2164-12-22','2164-12-22','2165-01-07',
                                    '2165-04-17','2165-05-05'),
                       ab_name=c('CEFEPIME','CEFTAZIDIME','CEFEPIME',
                                'CEFEPIME','CEFTAZIDIME','CEFTAZIDIME',
                                'CEFEPIME','CEFEPIME','CEFTAZIDIME',
                                'CEFTAZIDIME','CEFEPIME'),
                       interpretation=c('S','R','S','R','R','S','S','S','R','R','S'))

transpose_microbioevents(test_data,
                         key_columns = c('subject_id','chartdate','ab_name'),
                         required_columns = c('subject_id','chartdate'),
                         transpose_key_column = 'ab_name',
                         transpose_value_column = 'interpretation',
                         fill = "N/A",
                         non_empty_filter_column = 'subject_id')
}
