% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectModel.R
\name{projectModel}
\alias{projectModel}
\title{Project model across explanatory data.}
\usage{
projectModel(
  model,
  transformations,
  data,
  clamping = FALSE,
  raw = FALSE,
  rescale = FALSE,
  filename = NULL
)
}
\arguments{
\item{model}{The model to be projected. This may be the object returned by
\code{\link{chooseModel}}, or the 'selectedmodel' returned by
\code{\link{selectEV}}.}

\item{transformations}{Transformation functions used to create the derived
variables in the model. I.e. the 'transformations' returned by
\code{\link{deriveVars}}. Equivalently, the full file pathway of the
'transformations.Rdata' file saved as a result of \code{\link{deriveVars}}.}

\item{data}{Data frame of all the explanatory variables (EVs) included in the
model (see \code{\link{readData}}). Alternatively, an object of class
'SpatRaster' containing rasters for all EVs included in the model. Column
or raster names must match EV names.}

\item{clamping}{Logical. Do clamping \emph{sensu} Phillips et al. (2006).
Default is \code{FALSE}.}

\item{raw}{Logical. Return raw maxent output instead of probability ratio
output (PRO)? Default is FALSE. Irrelevant for "LR"-type models.}

\item{rescale}{Logical. Linearly rescale model output (PRO or raw) with
respect to the projection \code{data}? This has implications for the
interpretation of output values with respect to reference values (e.g. PRO
= 1). See details. Irrelevant for "LR"-type models.}

\item{filename}{Full file pathway to write raster model predictions if
\code{data} is an object of class 'SpatRaster'. File format is inferred
from the filename extension as in \code{terra::writeRaster}.}
}
\value{
List of 2: \enumerate{ \item output: A data frame with the model
 output in column 1 and the corresponding explanatory data in subsequent
 columns, or a raster containing predictions if \code{data} is a SpatRaster.
 \item ranges: A list showing the range of \code{data} compared to the
 training data, on a 0-1 scale.} If \code{data} is a SpatRaster, the output
 is also plotted.
}
\description{
\code{projectModel} calculates model predictions for any points where values
of the explanatory variables in the model are known. It can be used to get
model predictions for the training data, or to project the model to a new
space or time.
}
\details{
Missing data (NA) for a continuous variable will result in NA output for that
point. Missing data for a categorical variable is treated as belonging to
none of the categories.

When \code{rescale = FALSE} the scale of the maxent model output (PRO or raw)
returned by this function is dependent on the data used to train the model.
For example, a location with PRO = 2 can be interpreted as having a
probability of presence twice as high as an average site in the
\emph{training} data (Halvorsen, 2013, Halvorsen et al., 2015). When
\code{rescale = TRUE}, the output is linearly rescaled with respect to the
data onto which the model is projected. In this case, a location with PRO = 2
can be interpreted as having a probability of presence twice as high as an
average site in the \emph{projection} data. Similarly, raw values are on a
scale which is dependent on the size of either the training data extent
(\code{rescale = FALSE}) or projection data extent (\code{rescale = TRUE}).
}
\examples{
\dontrun{
# From vignette:
EVfiles <- c(list.files(system.file("extdata", "EV_continuous", package="MIAmaxent"),
                        full.names=TRUE),
             list.files(system.file("extdata", "EV_categorical", package="MIAmaxent"),
                        full.names=TRUE))
EVstack <- rast(EVfiles)
names(EVstack) <- gsub(".asc", "", basename(EVfiles))
grasslandPreds <- projectModel(model = grasslandmodel,
                               transformations = grasslandDVs$transformations,
                               data = EVstack)
grasslandPreds
}

}
\references{
Halvorsen, R. (2013) A strict maximum likelihood explanation of
 MaxEnt, and some implications for distribution modelling. Sommerfeltia, 36,
 1-132.

Halvorsen, R., Mazzoni, S., Bryn, A. & Bakkestuen, V. (2015)
 Opportunities for improved distribution modelling practice via a strict
 maximum likelihood interpretation of MaxEnt. Ecography, 38, 172-183.

Phillips, S.J., Anderson, R.P. & Schapire, R.E. (2006) Maximum
 entropy modeling of species geographic distributions. Ecological Modelling,
 190, 231-259.
}
