% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univDecomp.R
\name{givenBasis}
\alias{givenBasis}
\title{Use given basis functions for univariate representation}
\usage{
givenBasis(funDataObject, functions, scores = NULL, ortho = NULL)
}
\arguments{
\item{funDataObject}{An object of class \code{\link[funData]{funData}} 
containing the observed functional data samples and for which the basis 
representation is to be calculated.}

\item{functions}{A \code{funData} object that contains the basis 
functions.}

\item{scores}{An optional matrix containing the scores or coefficients of 
the individual observations and each basis function. If \code{N} denotes
the number of observations and \code{K} denotes the number of basis 
functions, then \code{scores} must be a matrix of dimensions \code{N x 
K}. If not supplied, the scores are calculated as projection of each 
observation on the basis functions.}

\item{ortho}{An optional parameter, specifying whether the given basis 
functions are orthonormal (\code{ortho = TRUE}) or not (\code{ortho = 
FALSE}). If not supplied, the basis functions are considered as 
non-orthonormal and their pairwise scalar product is calculated for 
later use in the MFPCA.}
}
\value{
\item{scores}{The coefficient matrix.} \item{B}{A matrix
  containing the scalar product of all pairs of basis functions. This is
  \code{NULL}, if \code{ortho = TRUE}.}\item{ortho}{Logical, set to 
  \code{TRUE}, if basis functions are orthonormal.} \item{functions}{A 
  functional data object containing the basis functions.}
 
 @keywords internal
}
\description{
Use given basis functions for univariate representation
}
