% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFPCAfit_methods.R
\name{scoreplot.MFPCAfit}
\alias{scoreplot.MFPCAfit}
\title{Plot the Scores of a Multivariate Functional Principal Component Analysis}
\usage{
\method{scoreplot}{MFPCAfit}(PCAobject, choices = 1:2, scale = FALSE, ...)
}
\arguments{
\item{PCAobject}{An object of class \code{MFPCAfit}, typically returned by the
\link{MFPCA} function.}

\item{choices}{The indices of the scores that should by displayed. Defaults 
to \code{1:2}, i.e. the scores corresponding to the two leading modes of 
variability in the data.}

\item{scale}{Logical. Should the scores be scaled by the estimated
eigenvalues to emphasize the proportions of total variance explained by the
components. Defaults to \code{FALSE}.}

\item{...}{Further parameters passed to the
\code{\link[graphics]{plot.default}} function.}
}
\value{
A bivariate plot of scores.
}
\description{
This function plots two scores of a multivariate functional principal 
component analysis for each observation.
}
\examples{
# and calculate MFPCA (cf. MFPCA help)
set.seed(1)
# simulate data (one-dimensional domains)
sim <-  simMultiFunData(type = "split", argvals = list(seq(0,1,0.01), seq(-0.5,0.5,0.02)),
                       M = 5, eFunType = "Poly", eValType = "linear", N = 100)
# MFPCA based on univariate FPCA
PCA <- MFPCA(sim$simData, M = 5, uniExpansions = list(list(type = "uFPCA"),
                                                     list(type = "uFPCA")))

# Plot the first two scores
scoreplot(PCA) # no scaling (default)
scoreplot(PCA, scale = TRUE) # scale the scores by the first two eigenvalues 
}
\seealso{
\code{\link{MFPCA}}
}
