% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdp.R
\name{runPolicyIteDiscount}
\alias{runPolicyIteDiscount}
\title{Perform policy iteration (discounted reward criterion) on the MDP.}
\usage{
runPolicyIteDiscount(
  mdp,
  w,
  dur,
  rate = 0,
  rateBase = 1,
  discountFactor = NULL,
  maxIte = 100,
  discountMethod = "continuous",
  getLog = TRUE
)
}
\arguments{
\item{mdp}{The MDP loaded using \code{\link[=loadMDP]{loadMDP()}}.}

\item{w}{The label of the weight we optimize.}

\item{dur}{The label of the duration/time such that discount rates can be calculated.}

\item{rate}{The interest rate.}

\item{rateBase}{The time-horizon the rate is valid over.}

\item{discountFactor}{The discount rate for one time unit. If specified \code{rate} and \code{rateBase} are not used to calculate the discount rate.}

\item{maxIte}{Max number of iterations. If the model does not satisfy the unichain assumption the algorithm may loop.}

\item{discountMethod}{Either 'continuous' or 'discrete', corresponding to discount factor \code{exp(-rate/rateBase)} or \code{1/(1 + rate/rateBase)}, respectively. Only used if \code{discountFactor} is \code{NULL}.}

\item{getLog}{Output the log messages.}
}
\value{
Nothing.
}
\description{
The policy can afterwards be received using functions \code{getPolicy} and \code{getPolicyW}.
}
\seealso{
\code{\link[=getPolicy]{getPolicy()}}.
}
