% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convertBinary2HMP}
\alias{convertBinary2HMP}
\title{Convert a HMDP model stored in binary format to a \code{hmp} (XML) file.
The function simply parse the binary files and create \code{hmp} files using
the \code{\link[=hmpMDPWriter]{hmpMDPWriter()}}.}
\usage{
convertBinary2HMP(
  prefix = "",
  binNames = c("stateIdx.bin", "stateIdxLbl.bin", "actionIdx.bin", "actionIdxLbl.bin",
    "actionWeight.bin", "actionWeightLbl.bin", "transProb.bin"),
  out = paste0(prefix, "converted.hmp"),
  duration = 1,
  getLog = TRUE
)
}
\arguments{
\item{prefix}{A character string with the prefix which will be added to the binary files.}

\item{binNames}{A character vector of length 7 giving the names of the binary files storing the model.}

\item{out}{The name of the HMP file (e.g. \code{r.hmp}).}

\item{duration}{Weight number storing the duration (NULL if none).}

\item{getLog}{Output log text.}
}
\value{
NULL (invisible).
}
\description{
Convert a HMDP model stored in binary format to a \code{hmp} (XML) file.
The function simply parse the binary files and create \code{hmp} files using
the \code{\link[=hmpMDPWriter]{hmpMDPWriter()}}.
}
\note{
Note all indexes are starting from zero (C/C++ style).
}
\examples{
## Set working dir
wd <- setwd(system.file("models", package = "MDP2"))

## Convert the machine example to a hmp file
prefix1 <- "machine1_"
getBinInfoStates(prefix1)
convertBinary2HMP(prefix1, duration = NULL)
# have a look at the hmp file
cat(readr::read_file("machine1_converted.hmp"))

## Convert the machine example hmp file to binary files
prefix2 <- "machine_cov_"
convertHMP2Binary("machine1.hmp", prefix2)
getBinInfoStates(prefix2)
## Convert the machine example with a single dummy node to a hmp file
#convertBinary2HMP("machine2_")  # error since using scope = 3 not supported in hmp files

## Reset working dir
setwd(wd)
}
\seealso{
\code{convertHMP2Binary}.
}
