% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_contin_table_with_clustered_AE.R
\name{generate_contin_table_with_clustered_AE}
\alias{generate_contin_table_with_clustered_AE}
\title{Generate simulated contingency tables with the option of incorporating
adverse event correlation within clusters.}
\usage{
generate_contin_table_with_clustered_AE(
  row_marginal,
  column_marginal,
  signal_mat,
  contin_table = NULL,
  AE_idx = NULL,
  n_rep = 1,
  rho = NULL,
  seed = NULL
)
}
\arguments{
\item{row_marginal}{Marginal sums for the rows of the contingency table.}

\item{column_marginal}{Marginal sums for the columns of the contingency
table.}

\item{signal_mat}{A data matrix of the same dimension as the contingency
table with entries representing the signal strength. The values should
be greater or equal to 1, where 1 indicates no signal, and values
greater than 1 indicate signal.}

\item{contin_table}{A data matrix of an \eqn{I} x \eqn{J} contingency
table with row (adverse event) and column (drug or vaccine) names, of which
the row and column marginals are used to generate the simulated data.
Please first check the input contingency table using the function
\code{check_and_fix_contin_table()}. Default is NULL.}

\item{AE_idx}{A data frame or list.
In case of data frame it must contain two variables \code{idx} and \code{AE},
where \code{idx} indicates the cluster index (a number),
and \code{AE} lists the adverse event names. See the
\code{statin49_AE_idx} for \code{statin49} data as an example.
In case of a list, make sure the cluster indices are aligned with the
corresponding row marginal.}

\item{n_rep}{Number of contingency tables to be generated.}

\item{rho}{A numeric value, matrix, or NULL indicating the correlation
structure.If a numeric value (float or int) is provided, it represents the
correlation value \code{rho} to be used between all elements within each
cluster specified by \code{AE_idx}. If a matrix is provided, it must be a
square matrix with dimensions equal to the number of rows in
\code{contin_table}. In this case, \code{rho} defines the correlation
structure directly, and \code{AE_idx} is not used. If \code{rho} is NULL,
a covariance matrix is generated based on the correlation coefficients of
\code{contin_table}.}

\item{seed}{An optional integer to set the seed for reproducibility.
If NULL, no seed is set.}
}
\value{
A list of \code{n_rep} simulated contingency tables.
}
\description{
Generate simulated contingency tables with the option of
incorporating adverse event correlation within clusters.
}
\examples{
# using statin49 as an example
data(statin49)
data(statin49_AE_idx)

# Prepare a matrix of signal strength with the same dimension as
# statin49, where 1 indicates no signal and values > 1 indicate
# signal
lambda_matrix <- matrix(1, nrow = nrow(statin49), ncol = ncol(statin49))

# Assign the cell (45,1) with signal strength 4
lambda_matrix[45, 1] <- 4

# Generate 5 simulated tables
set.seed(123)
simulated_tables <- generate_contin_table_with_clustered_AE(
  contin_table = statin49,
  n_rep = 5,
  AE_idx = statin49_AE_idx,
  rho = 0.5,
  signal_mat = lambda_matrix
)
}
