% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powMCTGen.R
\name{powMCTGen}
\alias{powMCTGen}
\title{Calculate Power for Multiple Contrast Test (General Case)}
\usage{
powMCTGen(
  nSample,
  family = c("negative binomial", "binomial", "poisson"),
  link = c("log", "logit", "sqrt", "probit", "cauchit", "cloglog", "identity",
    "risk ratio", "log risk ratio"),
  modelPar = NULL,
  placEff = NULL,
  theoResp = NULL,
  doses = NULL,
  Ntype = c("arm", "total", "actual"),
  alRatio = NULL,
  altModels,
  alpha = 0.025,
  df = NULL,
  critV = TRUE,
  alternative = c("one.sided", "two.sided"),
  verbose = FALSE,
  offset = NULL
)
}
\arguments{
\item{nSample}{An integer if \code{Ntype} is 'arm' or 'total', or a numerical
vector of patient allocations for each arm if \code{Ntype} is 'actual'.}

\item{family}{A character string containing the error distribution to be used
in the model.}

\item{link}{A character string for the model link function.}

\item{modelPar}{A numeric vector containing the additional parameters for the
family argument. If the family is negative binomial, the dispersion
parameter should be supplied. If the family is binomial, no model parameter
should be supplied.}

\item{placEff}{A numeric value specifying the mean response at the placebo
This is required if \code{link} = 'risk ratio' and ignored otherwise.}

\item{theoResp}{A numerical vector of theoretical response values, on the
transformed scale (e.g. on the log-scale for the negative binomial family).
This should be the same length as the doses argument.}

\item{doses}{A numerical vector of doses, corresponding to the theoretical
response values provided.}

\item{Ntype}{One of 'arm', 'total', or 'actual'. See documentation for
\code{Ntype} in \code{\link[DoseFinding:powMCT]{powMCT}} for descriptions
of 'arm' and 'total'. For 'actual', the nSample should be a numerical
vector containing the actual patient allocation for each dose provided.}

\item{alRatio}{Vector describing the relative patient allocations to the dose
groups up to proportionality, e.g. \code{rep(1, length(doses))} corresponds
to balanced allocations.}

\item{altModels}{An object of class \code{Mods}, defining the mean vectors
under which the power should be calculated.}

\item{alpha}{Significance level to use.}

\item{df}{Degrees of freedom to assume.}

\item{critV}{Critical value, if equal to \code{TRUE} the critical value will
be calculated. Otherwise one can directly specify the critical value here.}

\item{alternative}{Character determining the alternative for the multiple
contrast trend test.}

\item{verbose}{A logical specifying whether the patient allocation should be
printed, in addition to the results.}

\item{offset}{A positive numeric value specifying the offset term for the
negative binomial distribution. If offset = 1 (the default), then the
offset has no effect. Theoretically, the offset should be a numeric vector
the same length as the number of observations, but for planning purposes,
it is unlikely to know the individual offsets in advance.}
}
\value{
Numeric containing the calculated power values
}
\description{
Like the powMCT function, this function allows the user to calculate power
for a multiple contrast test for a set of specified alternatives for the
general case, but without specifying and S matrix. The user supplies the
patient allocation, the alternative models, and any parameters needed for the
distribution family (e.g. the dispersion parameter for the negative binomial
distribution). The function works by calculating the \eqn{\mu} and \eqn{S} for each
model in the alternative models and supplying the calculated values to the
powMCT function from the DoseFinding package, forwarding relevant arguments.
\cr This function also allows a new Ntype, namely 'actual'. If nSample is a
vector and Ntype is 'actual', the function interprets nSample to be the exact
patient allocation. This is useful for slightly modifying patient allocation
and avoiding messy ratios. \cr Furthermore, the function also accepts a
theoResp and doses argument, which together describe the theoretical
dose-response relationship. The returned power is the probability of
accepting at least one of the models specified in altModels.
}
\examples{
dose.vec = c(0, 5, 10, 20, 30, 40)
models.full = Mods(doses = dose.vec, linear = NULL,
      sigEmax = rbind(c(9, 2), c(6, 3)),
      emax = 0.8,
      quadratic = -0.02,
      placEff = 0, maxEff = 2)
## Calculate the power using the responses and doses specified in Mods
powMCTGen(30, 'negative binomial', 'log', modelPar = 0.1, Ntype = 'arm',
      alpha = 0.05, altModels = models.full)
## Calculate the power at theoretical dose-response values
powMCTGen(30, 'negative binomial', 'log', modelPar = 0.1,
      theoResp = c(0, 0.01, 0.02, 1, 1.6, 1.8), doses = c(0, 10, 20, 30, 40, 50),
      alpha = 0.05, altModels = models.full)
}
