\name{summaryPlot}
\alias{summaryPlot}
\title{
Wrapper function for ggplot2 to make bar and line graphs of 
mcmc.qpcr() results
}
\description{
This function is called automatically by HPDsummary() and also
can be used separately to plot the results produced by HPDsummary() 
with more plotting options 
}
\usage{
summaryPlot(data, xgroup, facet = NA, type = "bar", x.order = NA, 
whiskers = "ci", genes = NA)
}
\arguments{
  \item{data}{
A summary table generated by HPDplot(), it is the first element in the 
returned list.
}
  \item{xgroup}{
Which factor will be used to form the x axis (for 2-way designs).
}
  \item{facet}{
The factor by which the plot will be split into facets (for 2-way designs).
}
  \item{type}{
Two types are supported: "bar" and "line" ("line" also has points). 
"bar" is more useful to plot fold-changes returned when HPDsummary() 
is run with the option 'relative=TRUE'. "line" is better for plotting 
actual inferred transcript abundances across factor levels; it is particularly 
good for time courses and other cases when multiple factor levels must be 
compared to each other (rather than comparing all of them against a single 
global control). "bar" is good to plot log(fold-changes) relative to 
global control.  
}
  \item{x.order}{
A vector giving the order of factor levels on the x-axis. If unspecified, 
an alphanumeric order will be used.
}
  \item{whiskers}{
The interval indicated by the whiskers. Default is "ci", the 95\% credible 
interval; another option is "sd" - standard deviation of the posterior.
}
  \item{genes}{
Vector of gene names to plot. By default, all genes in the summary will be plotted.
}
}
\details{
The function invokes ggplot() functon from the ggplot2 package to plot 
the results either as a single panel (one-way designs) or a multi-panel 
(2-way designs, one panel per level of the factor specified by 'facet' argument).
}
\value{
A ggplot object. See http://docs.ggplot2.org/0.9.2.1/theme.html for ways 
to modify it, such as add text, rotate labels, change fonts, etc.
}
\references{
Matz MV, Wright RM, Scott JG (2013) No Control Genes Required: Bayesian 
Analysis of qRT-PCR Data. PLoS ONE 8(8): e71448. doi:10.1371/journal.pone.0071448
}
\author{
Mikhail V. Matz, University of Texas at Austin
<matz@utexas.edu>
}
