% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inconsistency.functions.R, R/nodesplit-class.R
\name{mbnma.nodesplit}
\alias{mbnma.nodesplit}
\alias{plot.nodesplit}
\title{Node-splitting model for testing consistency at the treatment level using MBNMA}
\usage{
mbnma.nodesplit(
  network,
  fun = "linear",
  user.fun = NULL,
  beta.1 = "rel",
  beta.2 = "rel",
  beta.3 = "rel",
  beta.4 = "rel",
  method = "common",
  knots = 3,
  comparisons = NULL,
  incldr = TRUE,
  ...
)

\method{plot}{nodesplit}(x, plot.type = NULL, ...)
}
\arguments{
\item{network}{An object of class \code{mbnma.network}.}

\item{fun}{A character vector specifying a functional form to be assigned to the
dose-response. Options are given in \code{details}.}

\item{user.fun}{A formula specifying any relationship including \code{dose} and
one/several of: \code{beta.1}, \code{beta.2}, \code{beta.3}, \code{beta.4}.}

\item{beta.1}{Refers to dose-parameter(s) specified within the dose-response function(s).
Can take either \code{"rel"}, \code{"common"}, \code{"random"}, or be assigned a numeric value (see details).}

\item{beta.2}{Refers to dose-parameter(s) specified within the dose-response function(s).
Can take either \code{"rel"}, \code{"common"}, \code{"random"}, or be assigned a numeric value (see details).}

\item{beta.3}{Refers to dose-parameter(s) specified within the dose-response function(s).
Can take either \code{"rel"}, \code{"common"}, \code{"random"}, or be assigned a numeric value (see details).}

\item{beta.4}{Refers to dose-parameter(s) specified within the dose-response function(s).
Can take either \code{"rel"}, \code{"common"}, \code{"random"}, or be assigned a numeric value (see details).}

\item{method}{Can take either \code{"common"} or \code{"random"} to indicate whether relative effects
should be modelled with between-study heterogeneity or not (see details).}

\item{knots}{The number/location of knots if a restricted cubic spline dose-response function is fitted (\code{fun="rcs"}).
If a single number is given it indicates the number of knots (they will
be equally spaced across the range of doses). If a numeric vector is given it indicates the location of the knots.
Minimum number of knots is 3.}

\item{comparisons}{A matrix specifying the comparisons to be split (one row per comparison).
The matrix must have two columns indicating each treatment for each comparison. Values can
either be character (corresponding to the treatment names given in \code{network}) or
numeric (corresponding to treatment codes within the \code{network} - note that these
may change if \code{drop.discon = TRUE}).}

\item{incldr}{A boolean object indicating whether or not to allow for indirect evidence contributions via
the dose-response relationship. This can be used when node-splitting in dose-response MBNMA to allow
for a greater number of potential loops in which to check for consistency.}

\item{...}{Arguments to be sent to \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}}

\item{x}{An object of \code{class("nodesplit")}}

\item{plot.type}{A character string that can take the value of \code{"forest"} to plot
only forest plots, \code{"density"} to plot only density plots, or left as \code{NULL} (the
default) to plot both types of plot.}
}
\value{
Plots the desired graph(s) and returns an object (or list of object if
\code{plot.type=NULL}) of \code{class(c("gg", "ggplot"))}
}
\description{
Splits contributions for a given set of treatment comparisons into direct and
indirect evidence. A discrepancy between the two suggests that the consistency
assumption required for NMA and MBNMA may violated.
}
\details{
The S3 method \code{plot()} on an \code{nodesplit} object generates either
forest plots of posterior medians and 95\\\% credible intervals, or density plots
of posterior densities for direct and indirect evidence.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: Plot outputs from treatment-level nodesplit MBNMA models
}}

\examples{
\donttest{
# Using the triptans data
network <- mbnma.network(HF2PPITT)

split <- mbnma.nodesplit(network, fun="emax", likelihood = "binomial", link="logit",
  method="common")


#### To perform nodesplit on selected comparisons ####

# Check for closed loops of treatments with independent evidence sources
# Including indirect evidence via the dose-response relationship
loops <- inconsistency.loops(network$data.ab, incldr=TRUE)

# This...
single.split <- mbnma.nodesplit(network, fun="exponential", likelihood = "binomial", link="logit",
             method="random", comparisons=rbind(c("sumatriptan_1", "almotriptan_1")))

#...is the same as...
single.split <- mbnma.nodesplit(network, fun="exponential", likelihood = "binomial", link="logit",
             method="random", comparisons=rbind(c(6, 12)))


# Plot results
plot(split, plot.type="density") # Plot density plots of posterior densities
plot(split, plot.type="forest") # Plot forest plots of direct and indirect evidence

# Print and summarise results
print(split)
summary(split) # Generate a data frame of summary results
}
}
