% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.functions.R
\name{plot.mbnma.predict}
\alias{plot.mbnma.predict}
\title{Plots predicted responses from a dose-response MBNMA model}
\usage{
\method{plot}{mbnma.predict}(x, disp.obs = FALSE,
  overlay.split = FALSE, method = "common", agent.labs = NULL,
  scales = "free_x", ...)
}
\arguments{
\item{x}{An object of class \code{"mbnma.predict"} generated by
\code{predict("mbnma")}}

\item{disp.obs}{A boolean object to indicate whether to show the location of observed doses
in the data on the 95\% credible intervals of the predicted dose-response curves as shaded regions (\code{TRUE})
or not (\code{FALSE}). If set to \code{TRUE} the original network object used for the model
\strong{must} be specified in \code{network}.}

\item{overlay.split}{A boolean object indicating whether to overlay a line
showing the split (treatment-level) NMA results on the plot (\code{TRUE}) or not (\code{FALSE}). This will
require automatic running of a split NMA model.
For \code{overlay.split=TRUE} the original network object used for the model
\strong{must} be specified in \code{network}.}

\item{method}{Indicates the type of split (treatment-level) NMA to perform when \code{overlay.split=TRUE}. Can
take either \code{"common"} or \code{"random"}.}

\item{agent.labs}{A character vector of agent labels to display on plots. If
left as \code{NULL} (the default) the names of agents will be taken from \code{predict}. The position of
each label corresponds to each element of \code{predict}. The number of labels must equal
the number of active agents in \code{predict}. If placebo / dose=0 data is included in the predictions
then a label for placebo \strong{should not} be included in \code{agent.labs}. It will not be shown
in the final plot since placebo is the point within each plot at which dose = 0 (rather
than a separate agent).}

\item{scales}{Should scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"},
\code{"free_y"})?}

\item{...}{Arguments for \code{ggplot2}}
}
\description{
Plots predicted responses on the natural scale from a dose-response MBNMA model.
}
\details{
For the S3 method \code{plot()}, it is advisable to ensure predictions in
\code{predict} are estimated using a sufficient number of doses to ensure a smooth
predicted dose-response curve. If \code{disp.obs = TRUE} it is
advisable to ensure predictions in \code{predict} are estimated using an even
sequence of time points to avoid misrepresentation of shaded densities.
}
\examples{
\donttest{
# Using the triptans data
network <- mbnma.network(HF2PPITT)

# Run an Emax dose-response MBNMA and predict responses
emax <- mbnma.emax(network, method="random")
pred <- predict(emax, E0 = 0.5)
plot(pred)

# Display observed doses on the plot
plot(pred, disp.obs=TRUE)

# Display split NMA results on the plot
plot(pred, overlay.split=TRUE)

# Split NMA results estimated using random treatment effects model
plot(pred, overlay.split=TRUE, method="random")

# Add agent labels
plot(pred, agent.labs=c("Elet", "Suma", "Frov", "Almo", "Zolmi",
      "Nara", "Riza"))

# These labels will throw an error because "Placebo" is included in agent.labs when
#it will not be plotted as a separate panel
#### ERROR ####
#plot(pred, agent.labs=c("Placebo", "Elet", "Suma", "Frov", "Almo", "Zolmi",
#      "Nara", "Riza"))


# If insufficient predictions are made across dose-response function
# then the plotted responses are less smooth and can be misleading
pred <- predict(emax, E0 = 0.5, n.doses=3)
plot(pred)
}

}
