% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.MBWCov.R
\name{coef.MBWCov}
\alias{coef.MBWCov}
\title{Regression coefficients of MBWCov models}
\usage{
\method{coef}{MBWCov}(object, ncomp = object$call$ncomp, ...)
}
\arguments{
\item{object}{An object resulting from \code{\link{MBWCov}}.}

\item{ncomp}{The number of components to be considered in the model. By default, all components computed in \code{\link{MBPLS}} or \code{\link{MBWCov}} are considered.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A matrix of regression coefficients where each row corresponds to a variable in X and each column corresponds to a variable in Y.
}
\description{
Computes regression coefficients from \code{\link{MBWCov}}.
}
\examples{
data(ham)
X=ham$X
block=ham$block
Y=ham$Y
res.mbwcov <- MBWCov(X, Y, block, name.block = names(block))
coef(res.mbwcov)

}
\seealso{
\code{\link{predict.MBWCov}}
}
