% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.MBPLS.R
\name{summary.MBPLS}
\alias{summary.MBPLS}
\title{Summary Results for Multiblock Partial Least Squares (MB-PLS) regression}
\usage{
\method{summary}{MBPLS}(object, nvar = NULL, ncompprint = NULL, digits = 2, ...)
}
\arguments{
\item{object}{An object of class \code{MBPLS}.}

\item{nvar}{Number of variables to print. By default (NULL), all the variables are printed.}

\item{ncompprint}{Number of global components to print.
By default (NULL), the number of global components printed for the main function MBPLS.}

\item{digits}{Number of decimal points (by default 2).}

\item{...}{Further arguments.}
}
\value{
Returns the percentages of inertia explained by successive global components (for both X and Y), their cumulative values
and the correlations of the variables with the global components.
}
\description{
Gives key results for MB-PLS.
}
\examples{
data(ham)
X=ham$X
group=ham$group
Y=ham$Y
res.mbpls <- MBPLS(X, Y, group, plotgraph=FALSE)
summary(res.mbpls)
}
\seealso{
\code{\link{MBPLS}}
}
\author{
Essomanda TCHANDAO MANGAMANA \email{tchanesso@yahoo.fr}, Véronique CARIOU, Evelyne VIGNEAU.
}
