% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_mave.R
\name{coef.mave}
\alias{coef.mave}
\alias{coef.mave.dim}
\title{Directions of CS or CMS of given dimension}
\usage{
\method{coef}{mave}(object, dim, ...)

\method{coef}{mave.dim}(object, dim = "dim.min", ...)
}
\arguments{
\item{object}{the output of \code{\link{mave}} or the output of \code{\link{mave.dim}}}

\item{dim}{the dimension of CS or CMS. The value of dim should be given when the class of the
argument dr is mave. When the class of the argument dr is mave.dim and dim is not given, the
function will return the basis matrix of CS or CMS of dimension selected by \code{\link{mave.dim}}}

\item{...}{no use.}
}
\value{
dir the matrix of CS or CMS of given dimension
}
\description{
This function returns the basis matrix of CS or CMS of given dimension
}
\examples{
x <- matrix(rnorm(400),100,4)
y <- x[,1]+x[,2]+as.matrix(rnorm(100))
dr <- mave(y~x)
dir3 <- coef(dr,3)

dr.dim <- mave.dim(dr)
dir3 <- coef(dr.dim,3)
dir.best <- coef(dr.dim)

}
\seealso{
\code{\link{mave.data}} for obtaining the reduced data
}
