% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Visualizing_MAGMA_functions.R
\name{Table_MAGMA}
\alias{Table_MAGMA}
\title{Table_MAGMA}
\usage{
Table_MAGMA(Balance, filename = NULL, verbose = TRUE)
}
\arguments{
\item{Balance}{A result of \code{\link{Balance_MAGMA}} Compare the function
\code{\link{Balance_MAGMA}}.}

\item{filename}{Optional argument.  A character specifying the filename that
the resulting Word document with the table should have.}

\item{verbose}{TRUE or FALSE indicating whether matching information should
be printed to the console.}
}
\value{
A 4x5 APA table showing the four balance
criteria and the respective sample sizes per group for four scenarios. In
each of these scenarios, one balance criteria has its optimal value. It can
print a Word Document with this table.
}
\description{
This function prints an APA Table of the Balance criteria. It displays the
balance criteria for four different sample sizes per group. In each scenario,
one balance criteria has its optimal value. Thus, the table is a 4x5 table
showing the four balance criteria and the respective sample size per group
for the four scenarios.
}
\details{
This function creates an APA Table including the optimal models for each
balance criterion, the other criteria for the respective sample size per
group as well as the sample size itself. With an optional argument you can
save a the APA table in Word.
}
\examples{
# This function bases on a MAGMA function as well as Balance_MAGMA
# Defining the names of the metric and binary covariates
covariates_vector <- c("GPA_school", "IQ_score", "Motivation", "parents_academic", "gender")


# Estimating balance of a two-group matching using the data set
# 'MAGMA_sim_data'.
# Matching variable 'gifted_support' (received giftedness support yes or no)
Balance_gifted <- Balance_MAGMA(Data = MAGMA_sim_data[MAGMA_sim_data$step_gifted < 200, ],
                                group = "gifted_support",
                                covariates = covariates_vector,
                                step = "step_gifted")

Table_MAGMA(Balance_gifted)

\donttest{
# 2x2 matching using the data set 'MAGMA_sim_data'
# Matching variables are 'gifted_support' (received giftedness support yes
# or no) and 'enrichment' (participated in enrichment or not)
# 'MAGMA_sim_data_gift_enrich' contains the result of the matching
# 2x2 matching is equivalent to four-group matching
MAGMA_sim_data_gift_enrich <- MAGMA(Data = MAGMA_sim_data,
                                   group = c("gifted_support", "enrichment"),
                                   dist = "ps_2x2",
                                   cores = 2)


# Estimating Balance. Covariates same as above
Balance_2x2 <- Balance_MAGMA(Data = MAGMA_sim_data_gift_enrich,
                             group = c("gifted_support", "enrichment"),
                             covariates = covariates_vector,
                             step = "step") #step created during matching

Table_MAGMA(Balance_2x2)
}

}
\author{
Julian Urban
}
